<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Forgot Password - Send OTP">
    <meta name="author" content="Creative Tim">
    <title>{{ env('APP_NAME') }}</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('admin_template/assets/logo/Favicon_1.svg') }}">
    <link rel="apple-touch-icon" href="{{ asset('admin_template/assets/logo/Favicon_1.svg') }}">

    <!-- Fonts & Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="{{ asset('admin_template/assets/vendor/nucleo/css/nucleo.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('admin_template/assets/vendor/@fortawesome/fontawesome-free/css/all.min.css') }}" type="text/css">

    <!-- Argon Dashboard CSS -->
    <link rel="stylesheet" href="{{ asset('admin_template/css/dashboard.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('css/app-custom.css') }}">

    <style>
    .btn-primary {
    color: #252424 !important;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
}
</style>

</head>

<body class="bg-light">

    <div class="main-content">
        <div class="container py-5">
            <div class="row justify-content-center">
                <div class="col-md-6 col-lg-5">

                    <div class="card shadow border-0 rounded-3">
                        <div class="card-header bg-primary text-white text-center py-3">
                            <h4 class="mb-0">Verify Otp</h4>
                            <small>Enter your registered email to receive OTP</small>
                        </div>

                        <div class="card-body px-4 py-4">

                            {{-- Success / Error Messages --}}
                            @if (session('success'))
                                <div class="alert alert-success text-center mb-3">{{ session('success') }}</div>
                            @elseif (session('error'))
                                <div class="alert alert-danger text-center mb-3">{{ session('error') }}</div>
                            @endif

                            {{-- Send OTP Form --}}
                            <form method="POST" action="{{ route('otp.check') }}">
                                @csrf

                                <div class="form-group mb-4">
                                    <label for="forgotcode" class="form-label fw-bold">Verify Otp</label>
                                    <div class="input-group input-group-alternative">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="ni ni-forgotcode-83"></i></span>
                                        </div>
                                        <input id="forgotcode" type="forgotcode"
                                            class="form-control @error('forgotcode') is-invalid @enderror"
                                            name="forgotcode" value="" required
                                            placeholder="Enter your otp code">
                                        @error('forgotcode')
                                            <span class="invalid-feedback d-block" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary my-4" style="margin-top: 8px !important;">Send OTP</button>
                                    <!-- <button type="submit" class="btn btn-primary w-100 py-2">
                                        <i class="fas fa-paper-plane me-1"></i> Send OTP
                                    </button> -->
                                </div>

                            </form>
                        </div>

                        <div class="card-footer text-center bg-white py-3">
                            <a href="{{ url('/') }}" class="text-muted small">
                                <i class="fas fa-arrow-left me-1"></i> Back to Login
                            </a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

</body>
</html>
