<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Forgot Password - Send OTP">
    <meta name="author" content="Creative Tim">
    <title>{{ env('APP_NAME') }}</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('admin_template/assets/logo/Favicon_1.svg') }}">
    <link rel="apple-touch-icon" href="{{ asset('admin_template/assets/logo/Favicon_1.svg') }}">

    <!-- Fonts & Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="{{ asset('admin_template/assets/vendor/nucleo/css/nucleo.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('admin_template/assets/vendor/@fortawesome/fontawesome-free/css/all.min.css') }}" type="text/css">

    <!-- Argon Dashboard CSS -->
    <link rel="stylesheet" href="{{ asset('admin_template/css/dashboard.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('css/app-custom.css') }}">

    <style>
        .btn-primary {
            color: #252424 !important;
            box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
        }
        .error-message {
            color: red;
            font-size: 14px;
            margin-top: 5px;
        }
        .password-wrapper {
            position: relative;
        }
        .password-wrapper i {
            position: absolute;
            top: 50%;
            right: 10px;
            transform: translateY(-50%);
            cursor: pointer;
            color: #666;
        }
        .password-wrapper i:hover {
            color: #000;
        }
    </style>
</head>

<body class="bg-light">
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">

            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">{{ __('Reset Password') }}</div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if (session('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif

                    <form method="POST" action="{{ route('password.update') }}" id="resetPasswordForm">
                        @csrf

                        {{-- Hidden email field --}}
                        <input type="hidden" name="email" value="{{ session('otp_email') }}">

                        {{-- New Password --}}
                        <div class="form-group row mb-3">
                            <label for="password" class="col-md-4 col-form-label text-md-right">
                                {{ __('New Password') }}
                            </label>
                            <div class="col-md-6 password-wrapper">
                                <input id="password" 
                                       type="password" 
                                       class="form-control @error('password') is-invalid @enderror" 
                                       name="password" 
                                       required 
                                       autocomplete="new-password"
                                       placeholder="Enter new password">
                                <i class="fas fa-eye toggle-password" data-target="password"></i>

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        {{-- Confirm Password --}}
                        <div class="form-group row mb-3">
                            <label for="password-confirm" class="col-md-4 col-form-label text-md-right">
                                {{ __('Confirm Password') }}
                            </label>
                            <div class="col-md-6 password-wrapper">
                                <input id="password-confirm" 
                                       type="password" 
                                       class="form-control" 
                                       name="password_confirmation" 
                                       required 
                                       autocomplete="new-password"
                                       placeholder="Confirm new password">
                                <i class="fas fa-eye toggle-password" data-target="password-confirm"></i>

                                <div id="passwordError" class="error-message" style="display:none;">
                                    Passwords do not match.
                                </div>
                            </div>
                        </div>

                        {{-- Submit Button --}}
                        <div class="form-group row mb-0">
                            <div class="col-md-8 offset-md-4">
                                <button type="submit" class="btn btn-success">
                                    {{ __('Reset Password') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- JS for Eye Toggle + Password Match -->
<script>
    // 👁️ Toggle Password Visibility
    document.querySelectorAll('.toggle-password').forEach(icon => {
        icon.addEventListener('click', function() {
            const target = document.getElementById(this.dataset.target);
            const type = target.getAttribute('type') === 'password' ? 'text' : 'password';
            target.setAttribute('type', type);
            this.classList.toggle('fa-eye-slash');
        });
    });

    // ❌ Check Password Match Before Submit
    document.getElementById('resetPasswordForm').addEventListener('submit', function(e) {
        let password = document.getElementById('password').value;
        let confirmPassword = document.getElementById('password-confirm').value;
        let errorDiv = document.getElementById('passwordError');

        if (password !== confirmPassword) {
            e.preventDefault();
            errorDiv.style.display = 'block';
            document.getElementById('password-confirm').classList.add('is-invalid');
        } else {
            errorDiv.style.display = 'none';
            document.getElementById('password-confirm').classList.remove('is-invalid');
        }
    });
</script>
</body>
</html>
