<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Change Password">
    <meta name="author" content="Creative Tim">
    <title>{{ env('APP_NAME') }}</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('public/admin_template/assets/logo/Favicon_1.svg') }}">
    <link rel="apple-touch-icon" href="{{ asset('apublic/dmin_template/assets/logo/Favicon_1.svg') }}">

    <!-- Fonts & Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="{{ asset('public/admin_template/assets/vendor/nucleo/css/nucleo.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('public/admin_template/assets/vendor/@fortawesome/fontawesome-free/css/all.min.css') }}" type="text/css">

    <!-- Argon Dashboard CSS -->
    <link rel="stylesheet" href="{{ asset('public/admin_template/css/dashboard.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('public/css/app-custom.css') }}">

    <style>
    .btn-primary {
    color: #252424 !important;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
}
</style>

</head>

<body class="bg-light">

    <div class="main-content">
        <div class="container py-5">
            <div class="row justify-content-center">
                <div class="col-md-6 col-lg-5">

                    <div class="card shadow border-0 rounded-3">
                        <div class="card-header bg-primary text-white text-center py-3">
                            <h4 class="mb-0">Change Password</h4>
                            <small>Enter your Old Password</small>
                        </div>

                        <div class="card-body px-4 py-4">

                            {{-- Success / Error Messages --}}
                            @if (session('success'))
                                <div class="alert alert-success text-center mb-3">{{ session('success') }}</div>
                            @elseif (session('error'))
                                <div class="alert alert-danger text-center mb-3">{{ session('error') }}</div>
                            @endif

                            {{-- Send OTP Form --}}
                            <form method="POST" action="{{ route('oldpass') }}">
                                @csrf

                                <div class="form-group mb-4">
                                    <label for="password" class="form-label fw-bold">Old Password</label>
                                    <div class="input-group">
                                        <input id="password" type="password"
                                            class="form-control @error('password') is-invalid @enderror"
                                            name="password" required
                                            placeholder="Enter your Old password">

                                        <div class="input-group-append">
                                            <span class="input-group-text" id="togglePassword" style="cursor: pointer;">
                                                <i class="fa fa-eye"></i>
                                            </span>
                                        </div>

                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                </div>

                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary my-4" style="margin-top: 8px !important;">Confirm Password</button>
                                </div>

                            </form>
                        </div>

                        <div class="card-footer text-center bg-white py-3">
                            <a href="{{ url('/') }}" class="text-muted small">
                                <i class="fas fa-arrow-left me-1"></i> Back to Login
                            </a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

</body>
</html>

<script>
document.getElementById('togglePassword').addEventListener('click', function () {
    const password = document.getElementById('password');
    const icon = this.querySelector('i');

    if (password.type === 'password') {
        password.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        password.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
});
</script>

