<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Fresh Groceries Delivered to Your Doorstep">
    <!-- <meta name="description" content="Start your development with a Dashboard for Bootstrap 4."> -->
    <meta name="author" content="Creative Tim">
    <!-- <title>{{ env('APP_NAME') }}</title> -->
    <title>GIRLIES</title>

    <!-- Favicon -->
   <link rel="icon" href="{{ asset('assets/img/brand/Mobile_LOGO.svg') }}" type="image/svg+xml">

    <!-- Fonts -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <!-- Icons -->
    <link rel="stylesheet" href="{{ asset('/admin_template/assets/vendor/nucleo/css/nucleo.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('/admin_template/assets/vendor/@fortawesome/fontawesome-free/css/all.min.css') }}" type="text/css">
    <!-- Argon CSS -->
    <link rel="stylesheet" href="{{ asset('/admin_template/css/dashboard.css') }}" type="text/css">
    <!-- Custom style -->
    <link rel="stylesheet" href="{{ asset('/css/app-custom.css') }}">
</head>


<body class="bg-white">
    <!-- Main content -->
    <div class="main-content">
        <!-- Header -->
        <div class="header bg-gradient-primary py-7 py-lg-8">
            <!--<div class="container">
                <div class="header-body text-center mb-7">
                    <div class="row justify-content-center">
                        <div class="col-xl-5 col-lg-6 col-md-8">
                            <h1 class="text-white">Glossary Keeper </h1>
                        </div>
                    </div>
                </div>
            </div>-->
            <div class="separator separator-bottom separator-skew zindex-100">
                <svg x="0" y="0" viewBox="0 0 2560 100" preserveAspectRatio="none" version="1.1" xmlns="http://www.w3.org/2000/svg">
                    <polygon class="fill-white" points="2560 0 2560 100 0 100"></polygon>
                </svg>
            </div>
        </div>
        <!-- Page content -->
        <div class="container mt--9 pb-5 text-gray">
            <div class="row justify-content-center">
                <div class="col-lg-5 col-md-7">
                    <div class="card bg-secondary border border-soft mb-0">
                        <div class="img_logo loginpageLogo" style="    display: flex;     align-items: center;">
                            <img src="{{ asset('/admin_template/assets/img/brand/logo.png') }}" style=" width: 100%;max-width: 206px; height: 100px;" alt="Logo">
                        </div>
                        <!--  <h1 style="margin-top: 41px;text-align: center;">Glossary</h1> -->
                        <div class="card-body px-lg-3 py-lg-3" style="">
                            <div class="text-center mb-4">
                            </div>

                            @if(session('error'))
                                <div class="alert alert-danger">
                                    {{ session('error') }}
                                </div>
                            @endif
                            <form role="form" action="{{ route('adminlogin') }}" method="post">
                                @csrf
                                <div class="login-alert-container" >
                                    @include('layouts.messages')
                                </div>
                                <div class="form-group mb-3">
                                    <div class="input-group input-group-merge input-group-alternative">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="ni ni-email-83"></i></span>
                                        </div>
                                        <input class="form-control @error('email') is-invalid @enderror" placeholder="Email" type="email" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group input-group-merge input-group-alternative">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="ni ni-lock-circle-open"></i></span>
                                        </div>
                                        <input class="form-control @error('password') is-invalid @enderror" placeholder="Password" type="password" name="password" required autocomplete="current-password">
                                    </div>
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary my-4">Login</button>
                                </div>

                            <div class="form-group default-admin">
                            <!--<div class="border p-3 rounded-3" style="border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);     border-radius: 10px;">

                                    <div class="crediantials-field" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                                        <b style="color: #000; font-size: 16px; font-weight: bold;">
                                            Email:
                                            <span id="email_field" style="font-size: 16px; color: #000; margin-right: 10px;">demo@imart.com</span>
                                        </b>
                                        <a href="javascript:void(0)" onclick="copyToClipboard('email_field')" style="display: inline;">
                                            <i class="fa fa-copy" style="color: #A3CB38;"></i>
                                        </a>
                                    </div>


                                   <div class="crediantials-field" style="display: flex; justify-content: space-between; align-items: center;">
                                        <b style="color: #000; font-size: 16px; font-weight: bold;">
                                            Password:
                                            <span id="password_field" style="font-size: 16px; color: #000; margin-right: 10px;">123456</span>
                                        </b>
                                        <a href="javascript:void(0)" onclick="copyToClipboard('password_field')" style="display: inline;">
                                            <i class="fa fa-copy" style="color: #A3CB38;"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>-->

                            <script>
                                function copyToClipboard(fieldId) {
                                    // Get the text content of the field
                                    const textToCopy = document.getElementById(fieldId).textContent;

                                    // Create a temporary input element to copy the text
                                    const tempInput = document.createElement('input');
                                    tempInput.value = textToCopy;
                                    document.body.appendChild(tempInput);

                                    // Select the text and copy it to the clipboard
                                    tempInput.select();
                                    tempInput.setSelectionRange(0, 99999); // For mobile devices
                                    document.execCommand('copy');

                                    // Remove the temporary input element
                                    document.body.removeChild(tempInput);
                                }
                            </script>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Core -->
    <script src="{{ asset('/admin_template/assets/vendor/jquery/dist/jquery.min.js') }}"></script>
    <script src="{{ asset('/admin_template/assets/vendor/js-cookie/js.cookie.js') }}"></script>
    <!-- Argon JS -->
    <script src="{{ asset('/admin_template/assets/js/dashboard.js?v=1.2.0') }}"></script>
    <!-- Custom script -->
    <script src="{{ asset('/js/app-custom.js') }}"></script>
</body>

</html>

<style>
    .large-icon {
        font-size: 24px; /* Adjust size as needed */
        width: 30px; /* Optional: control icon width */
        height: 30px; /* Optional: control icon height */
    }
</style>

<style>

.img_logo {
    margin-top: 45px;
}

    /*css start*/

        .text-white {
        font-size:50px;
    }

    button.btn.btn-primary.my-4 {
        background: black !important;
        color: white !important;

    }

    button.btn.btn-primary.my-4:hover {
        background: rgb(255, 255, 255) !important;
        color: rgb(0, 0, 0) !important;

    }

    .mt--9 {
    margin-top: -17rem !important;
}

.py-lg-8 {
    padding-top: 22rem !important;
}

  /*   img {
    height: 285px;
    width: 290px;
    margin: 0px 8px 36px 0;
} */

    .card{
            align-items: center;
        }

   /*  .card-body {
        margin-top: -75px;
    } */

    .input-group-text{
        color:black;
    }

    .form-group {
    margin-bottom: 0.5rem !important;
}

.my-4 {
    margin-bottom: 1.5rem !important;
}

    .form-control{
        color:black;
        height: 40px;
        width: 350px;
    }

    .form-control:focus{
        color:#212121 !important;
    }

    .focused .input-group-text{
        color:black;
    }

    .input-group-text{
        border-color:green;
    }



    .btn-primary{
        padding:6px 25px;
    }

    /*responsive css start*/

    /*small desktop*/
    @media (min-width:1024px) and (max-width:1199px) {


        .card{
            align-items: center;
        }

        .text-white {
            font-size:45px;
        }

        .form-control {
            height: 40px;
            width: 290px;
    }


    }


    /*tablate*/

    @media (min-width:768px) and (max-width:1023px) {
        img {

        }

        .card{
            align-items: center;
        }

        .text-white {
            font-size:35px;
        }

        .form-control {
            height: 35px;
            width: 270px;
        }

        .img_logo {
    margin-top: 45px;
}

    }

    /*mobile*/

    @media (min-width: 320px) and (max-width:767px)	{
        img {

        }

        .card {
            align-items: center;
            width: 400px;
            margin: auto;
        }
        .img_logo {
    margin-top: 45px;
}

        .text-white {
            font-size:30px;
        }

        .form-control {
            height: 35px;
            width: 250px;
        }
        .mt--9 {
    margin-top: -12rem !important;
}

.py-lg-8 {
    padding-top: 14rem !important;
}
    }

    @media (min-width: 200px) and (max-width:450px)	{
        .card {
            align-items: center;
            width:300px;
            margin: auto !important;
        }

        .img_logo {
    margin-top: 45px;
}
    }
    /*responsive css end*/


    @media (min-width: 1200px) {
    .separator-skew {
        height: 80px;
    }
}
   .bg-gradient-primary {
    background: linear-gradient(87deg, #F79DA2 0, #F79DA2 100%) !important;
}



</style>
