@extends('layouts.admin.main')
@section('title', 'user')
@section('header')
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-lg-6 col-7">
                <h6 class="h2 text-white d-inline-block mb-0"></h6>
            </div>
        </div>
    </div>
@endsection

@section('content')

    <div class="row">

        <!-- Light table -->

        <div class="col">

            <div class="card">

                <!-- Card header -->

                <div class="card-header border-0">

                    @if (isset($users))
                        <h3 class="mb-0">Edit Admin User</h3>
                    @else
                        <h3 class="mb-0">Add Admin User</h3>
                    @endif
                </div>

                <div class="card-body pt-0" style="padding-bottom:20px !important;">

                    @include('layouts.messages')
                    <form enctype="multipart/form-data" method="POST"
                        action="@if (isset($users)) {{ route('admin.usereditadmin') }} @else {{ route('admin.users.create') }} @endif"
                        id="create-plan">
                        @csrf

                    </form>

                    <div class="row restaurant_payout_create ">

                        <div class="restaurant_payout_create-inner">

                            <fieldset>
                            <legend style="background: #013921  !important;">User Details</legend>
                            
                                            <div class="form-group row width-50">

                                                <label class="col-3 control-label">Name<span class="m-l-1 text-red">*</span></label>

                                          
                                                @if (isset($users))
                                                    <input type="hidden" form="create-plan" id="roleid" class="form-control"
                                                        name="customerid" placeholder="Identificación" 
                                                        value="@if (isset($users)) {{ $users['id'] }}  @endif" >
                                                @endif

                                                <div class="col-7">

                                                    {{-- <input type="text" form="create-plan" id="name" class="form-control"
                                                        name="firstname" placeholder="Name"
                                                        value="@if (isset($users)) {{ $users['name'] }} @endif" @if(!isset($users)) required @endif> --}}
                                                    <input type="text" 
                                                        form="create-plan" 
                                                        id="name" 
                                                        class="form-control"
                                                        name="firstname" 
                                                        placeholder="Name"
                                                        value="{{ isset($users) ? $users['name'] : '' }}" 
                                                        required>
                                                </div>
                                            </div>

                                            <div class="form-group row width-50">

                                                <label class="col-3 control-label">Last Name<span class="m-l-1 text-red">*</span></label>

                                            
                                                <div class="col-7">

                                                    <input type="text" form="create-plan" id="name" class="form-control"
                                                        name="lastname" placeholder="Last Name"
                                                        value="@if (isset($users)) {{ $users['lastname'] }} @endif"  required >

                                                </div>
                                            </div>

                                            <div class="form-group row width-50">

                                                <label class="col-3 control-label">Email<span class="m-l-1 text-red">*</span></label>

                                            
                                                <div class="col-7">

                                                    <input type="text" form="create-plan" id="name" class="form-control"
                                                        name="email" placeholder="Email"
                                                        value="@if (isset($users)) {{ $users['email'] }} @endif" required>

                                                </div>
                                            </div>

                                               @if (!isset($users))
                                                <div class="form-group row width-50">
                                                    <label class="col-3 control-label">Password<span class="m-l-1 text-red">*</span></label>
                                                
                                                    <div class="col-7">
                                                        <input type="password" form="create-plan" id="name" class="form-control" name="password" placeholder="Password" value="" @if(!isset($users)) required @endif>
                                                    </div>
                                                </div>
                                                @endif

                                            <div class="form-group row width-5">
                                                <label class="col-3 control-label">Contact No<span class="m-l-1 text-red">*</span></label>
                                            
                                                <div class="col-7">
                                                    <input type="text" form="create-plan" id="mobile" class="form-control" name="mobile" placeholder="Contact No" value="@if (isset($users)) {{ $users['contact_no'] }} @endif" required >
                                                </div>
                                            </div>

                                            <script>
                                                document.getElementById('mobile').addEventListener('input', function (e) {
                                                    var input = e.target.value;
                                                    if (!/^\d{0,10}$/.test(input)) {
                                                        e.target.value = input.slice(0, 10);
                                                    }
                                                });
                                            </script>

                                            <div class="form-group row width-5">
                                                <label class="col-3 control-label">Role<span class="m-l-1 text-red">*</span></label>
                                            
                                            <div class="col-7">
                                                <select name="rolename" form="create-plan" class="form-control" required>
                                                    <option value="">--Select--</option>
                                                    @foreach ($rolenam as $value)
                                                        <option value="{{ $value['id'] }}" @if (isset($users) && $value['id'] == $users['role']) selected="selected" @endif>
                                                            {{ $value['rolename'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            </div>

                                            <div class="row check">
                                                <table class="mt-1">
                                                    <thead class="col col-12">
                                                        <tr>
                                                            <th class="col-2" style="white-space: nowrap;">Module
                                                                Permission
                                                            </th>
                                                            <th class="col-2" style="white-space: nowrap;">All
                                                            </th>
                                                            <th class="col-2" style="white-space: nowrap;">Module Selection
                                                            </th>
                                                            <th class="col-2" style="white-space: nowrap;">Points Of View
                                                            </th>
                                                            <th class="col-2">Edit</th>
                                                            <th class="col-2">Create</th>
                                                            <th class="col-2">Delete</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="col-md-12 col-12">
                                                            <td class="col-2">Role</td>
                                                            @php
                                                                $roleFound = false; 
                                                            @endphp
                                                            @if(isset($modulelist))
                                                                @foreach ($modulelist as $key => $value)
                                                                    @if($value['menuname'] == 'role')
                                                                        @php
                                                                            $roleFound = true; 
                                                                        @endphp
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="role_all" name="role[all]" value="1" {{ $value['all'] == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="role_add" name="role[module]" value="role" {{ $value['menuname'] == 'role' ? 'checked' : '' }}  />
                                                                            <span></span>
                                                                        </td>
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="role_view" name="role[views]" value="1" {{ $value['view'] == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>  
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="role_edit" name="role[edit]" value="1" {{ $value->edit == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="role_addv" name="role[create]" value="1" {{ $value->addv == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="role_deletev" name="role[delete]" value="1" {{ $value->deletev == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>
                                                                    @endif
                                                                @endforeach
                                                            @endif
                                                            @if (!$roleFound)
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="role_all" name="role[all]" value="1" />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox"  id="role_add" name="role[module]" value="role" />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="role_view" name="role[views]" value="1" />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="role_edit" name="role[edit]" value="1" />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="role_addv" name="role[create]" value="1" />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="role_deletev" name="role[delete]" value="1" />
                                                                    <span></span>
                                                                </td>
                                                            @endif
                                                        </tr>
                                                          <tr>
                                                            <td></td>
                                                        </tr>

                                                        <tr class="col col-12">
                                                            <td class="col-2">Client</td>
                                                             @php
                                                                $ClientFound = false; 
                                                            @endphp
                                                            
                                                         @if (isset($modulelist))
                                                          
                                                            @foreach ($modulelist as $key => $value)
                                                            
                                                             @if($value['menuname']=='customer')
                                                                
                                                               @php
                                                                    $ClientFound = true; 
                                                                @endphp
                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_all"
                                                                    name="customer[all]" value="1"
                                                                    <?php if($value['all']=='1'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_module"
                                                                    name="customer[module]" value="customer"
                                                                    <?php if($value['menuname']=='customer'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_view"
                                                                    name="customer[views]" value="1"
                                                                    <?php if($value['view']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_edit"
                                                                    name="customer[edit]" value="1"
                                                                    <?php if($value['edit']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_create"
                                                                    name="customer[create]" value="1"
                                                                    <?php if($value['addv']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_delete"
                                                                    name="customer[delete]" value='1'
                                                                    <?php if($value['deletev']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                             @endif
                                                                @endforeach
                                                            @endif
                                                            @if (!$ClientFound)

                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_all"
                                                                    name="customer[all]" value="1" readonly />
                                                                <span></span>

                                                            </td>

                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_module"
                                                                    name="customer[module]" value="customer" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_view"
                                                                    name="customer[views]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_edit"
                                                                    name="customer[edit]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_create"
                                                                    name="customer[create]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Client_delete"
                                                                    name="customer[delete]" value='1' />
                                                                <span></span>

                                                            </td>
                                                            @endif
                                                        </tr>

                                                        <tr class="col col-12">
                                                            <td class="col-2">Categories</td>
                                                             @php
                                                                $CategoriesFound = false; 
                                                            @endphp
                                                            
                                                         @if (isset($modulelist))
                                                          
                                                            @foreach ($modulelist as $key => $value)
                                                            
                                                             @if($value['menuname']=='categories')
                                                                
                                                               @php
                                                                    $CategoriesFound = true; 
                                                                @endphp
                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_all"
                                                                    name="categories[all]" value="1"
                                                                    <?php if($value['all']=='1'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_module"
                                                                    name="categories[module]" value="categories"
                                                                    <?php if($value['menuname']=='categories'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_view"
                                                                    name="categories[views]" value="1"
                                                                    <?php if($value['view']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_edit"
                                                                    name="categories[edit]" value="1"
                                                                    <?php if($value['edit']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_create"
                                                                    name="categories[create]" value="1"
                                                                    <?php if($value['addv']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_delete"
                                                                    name="categories[delete]" value='1'
                                                                    <?php if($value['deletev']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                             @endif
                                                                @endforeach
                                                            @endif
                                                            @if (!$CategoriesFound)

                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_all"
                                                                    name="categories[all]" value="1" readonly />
                                                                <span></span>

                                                            </td>

                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_module"
                                                                    name="categories[module]" value="categories" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_view"
                                                                    name="categories[views]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_edit"
                                                                    name="categories[edit]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_create"
                                                                    name="categories[create]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Categories_delete"
                                                                    name="categories[delete]" value='1' />
                                                                <span></span>

                                                            </td>
                                                            @endif
                                                        </tr>

                                                        <tr class="col col-12">
                                                            <td class="col-2">Item Attribute</td>
                                                             @php
                                                                $ItemFound = false; 
                                                            @endphp
                                                            
                                                         @if (isset($modulelist))
                                                          
                                                            @foreach ($modulelist as $key => $value)
                                                            
                                                             @if($value['menuname']=='item')
                                                                
                                                               @php
                                                                    $ItemFound = true; 
                                                                @endphp
                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_all"
                                                                    name="item[all]" value="1"
                                                                    <?php if($value['all']=='1'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_module"
                                                                    name="item[module]" value="item"
                                                                    <?php if($value['menuname']=='item'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_view"
                                                                    name="item[views]" value="1"
                                                                    <?php if($value['view']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_edit"
                                                                    name="item[edit]" value="1"
                                                                    <?php if($value['edit']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_create"
                                                                    name="item[create]" value="1"
                                                                    <?php if($value['addv']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_delete"
                                                                    name="item[delete]" value='1'
                                                                    <?php if($value['deletev']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                             @endif
                                                                @endforeach
                                                            @endif
                                                            @if (!$ItemFound)

                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_all"
                                                                    name="item[all]" value="1" readonly />
                                                                <span></span>

                                                            </td>

                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_module"
                                                                    name="item[module]" value="item" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_view"
                                                                    name="item[views]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_edit"
                                                                    name="item[edit]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_create"
                                                                    name="item[create]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Item_delete"
                                                                    name="item[delete]" value='1' />
                                                                <span></span>

                                                            </td>
                                                            @endif
                                                        </tr>

                                                        <tr class="col col-12">
                                                            <td class="col-2">Product</td>
                                                            @php
                                                                $productFound = false; 
                                                            @endphp
                                                            @if(isset($modulelist))
                                                                @foreach ($modulelist as $key => $value)
                                                                    @if($value['menuname'] == 'product')
                                                                        @php
                                                                            $productFound = true;  
                                                                        @endphp
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="product_all" name="product[all]" value="1" {{ $value['all'] == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="product_module" name="product[module]" value="product" {{ $value['menuname'] == 'product' ? 'checked' : '' }} readonly />
                                                                            <span></span>
                                                                        </td>
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="product_view" name="product[views]" value="1" {{ $value['view'] == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="product_edit" name="product[edit]" value="1" {{ $value['edit'] == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="product_create" name="product[create]" value="1" {{ $value['addv'] == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>
                                                                        <td class="col-2">
                                                                            <input form="create-plan" type="checkbox" id="product_delete" name="product[delete]" value="1" {{ $value['deletev'] == '1' ? 'checked' : '' }} />
                                                                            <span></span>
                                                                        </td>
                                                                    @endif
                                                                @endforeach
                                                            @endif
                                                            @if (!$productFound)
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="product_all" name="product[all]" value="1" readonly />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="product_module" name="product[module]" value="product" readonly />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="product_view" name="product[views]" value="1" />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="product_edit" name="product[edit]" value="1" />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="product_create" name="product[create]" value="1" />
                                                                    <span></span>
                                                                </td>
                                                                <td class="col-2">
                                                                    <input form="create-plan" type="checkbox" id="product_delete" name="product[delete]" value="1" />
                                                                    <span></span>
                                                                </td>
                                                            @endif
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                        </tr>
                                                        
                                                        <tr>
                                                            <td></td>
                                                        </tr>
                                                        <tr class="col col-12">
                                                            <td class="col-2">Order list</td>
                                                            @php
                                                                $orderlistFound = false; 
                                                            @endphp
                                                            
                                                         @if (isset($modulelist))
                                                          
                                                            @foreach ($modulelist as $key => $value)
                                                            
                                                             @if($value['menuname']=='orderlist')
                                                               
                                                               @php
                                                                    $orderlistFound = true; 
                                                                @endphp
                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_all"
                                                                    name="orderlist[all]" value="1"
                                                                    <?php if($value['all']=='1'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_module"
                                                                    name="orderlist[module]" value="orderlist"
                                                                    <?php if($value['menuname']=='orderlist'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_view"
                                                                    name="orderlist[views]" value="1"
                                                                    <?php if($value['view']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_edit"
                                                                    name="orderlist[edit]" value="1"
                                                                    <?php if($value['edit']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_create"
                                                                    name="orderlist[create]" value="1"
                                                                    <?php if($value['addv']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_delete"
                                                                    name="orderlist[delete]" value='1'
                                                                    <?php if($value['deletev']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            @if(!$orderlistFound)
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_all"
                                                                    name="orderlist[all]" value="1" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_module"
                                                                    name="orderlist[module]" value="orderlist" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_view"
                                                                    name="orderlist[views]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_edit"
                                                                    name="orderlist[edit]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_create"
                                                                    name="orderlist[create]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="order_delete"
                                                                    name="orderlist[delete]" value='1' />
                                                                <span></span>

                                                            </td>
                                                           @endif
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                        </tr>

                                                        <tr class="col col-12">
                                                            <td class="col-2">Drivers</td>
                                                             @php
                                                                $DriversFound = false; 
                                                            @endphp
                                                            
                                                         @if (isset($modulelist))
                                                          
                                                            @foreach ($modulelist as $key => $value)
                                                            
                                                             @if($value['menuname']=='drivers')
                                                                
                                                               @php
                                                                    $DriversFound = true; 
                                                                @endphp
                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_all"
                                                                    name="drivers[all]" value="1"
                                                                    <?php if($value['all']=='1'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_module"
                                                                    name="drivers[module]" value="drivers"
                                                                    <?php if($value['menuname']=='drivers'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_view"
                                                                    name="drivers[views]" value="1"
                                                                    <?php if($value['view']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_edit"
                                                                    name="drivers[edit]" value="1"
                                                                    <?php if($value['edit']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_create"
                                                                    name="drivers[create]" value="1"
                                                                    <?php if($value['addv']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_delete"
                                                                    name="drivers[delete]" value='1'
                                                                    <?php if($value['deletev']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                             @endif
                                                                @endforeach
                                                            @endif
                                                            @if (!$DriversFound)

                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_all"
                                                                    name="drivers[all]" value="1" readonly />
                                                                <span></span>

                                                            </td>

                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_module"
                                                                    name="drivers[module]" value="drivers" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_view"
                                                                    name="drivers[views]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_edit"
                                                                    name="drivers[edit]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_create"
                                                                    name="drivers[create]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Drivers_delete"
                                                                    name="drivers[delete]" value='1' />
                                                                <span></span>

                                                            </td>
                                                            @endif
                                                        </tr>

                                                        <tr class="col col-12">
                                                            <td class="col-2">Notification</td>
                                                             @php
                                                                $NotificationFound = false; 
                                                            @endphp
                                                            
                                                         @if (isset($modulelist))
                                                          
                                                            @foreach ($modulelist as $key => $value)
                                                            
                                                             @if($value['menuname']=='notification')
                                                                
                                                               @php
                                                                    $NotificationFound = true; 
                                                                @endphp
                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_all"
                                                                    name="notification[all]" value="1"
                                                                    <?php if($value['all']=='1'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_module"
                                                                    name="notification[module]" value="notification"
                                                                    <?php if($value['menuname']=='notification'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_view"
                                                                    name="notification[views]" value="1"
                                                                    <?php if($value['view']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_edit"
                                                                    name="notification[edit]" value="1"
                                                                    <?php if($value['edit']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_create"
                                                                    name="notification[create]" value="1"
                                                                    <?php if($value['addv']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_delete"
                                                                    name="notification[delete]" value='1'
                                                                    <?php if($value['deletev']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                             @endif
                                                                @endforeach
                                                            @endif
                                                            @if (!$NotificationFound)

                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_all"
                                                                    name="notification[all]" value="1" readonly />
                                                                <span></span>

                                                            </td>

                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_module"
                                                                    name="notification[module]" value="notification" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_view"
                                                                    name="notification[views]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_edit"
                                                                    name="notification[edit]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_create"
                                                                    name="notification[create]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Notification_delete"
                                                                    name="notification[delete]" value='1' />
                                                                <span></span>

                                                            </td>
                                                            @endif
                                                        </tr>

                                                        <tr class="col col-12">
                                                            <td class="col-2">Promo codes</td>
                                                             @php
                                                                $PromocodesFound = false; 
                                                            @endphp
                                                            
                                                         @if (isset($modulelist))
                                                          
                                                            @foreach ($modulelist as $key => $value)
                                                            
                                                             @if($value['menuname']=='promocodes')
                                                                
                                                               @php
                                                                    $PromocodesFound = true; 
                                                                @endphp
                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_all"
                                                                    name="promocodes[all]" value="1"
                                                                    <?php if($value['all']=='1'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_module"
                                                                    name="promocodes[module]" value="promocodes"
                                                                    <?php if($value['menuname']=='promocodes'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_view"
                                                                    name="promocodes[views]" value="1"
                                                                    <?php if($value['view']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_edit"
                                                                    name="promocodes[edit]" value="1"
                                                                    <?php if($value['edit']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_create"
                                                                    name="promocodes[create]" value="1"
                                                                    <?php if($value['addv']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_delete"
                                                                    name="promocodes[delete]" value='1'
                                                                    <?php if($value['deletev']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                             @endif
                                                                @endforeach
                                                            @endif
                                                            @if (!$PromocodesFound)

                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_all"
                                                                    name="promocodes[all]" value="1" readonly />
                                                                <span></span>

                                                            </td>

                                                                <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_module"
                                                                    name="promocodes[module]" value="promocodes" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_view"
                                                                    name="promocodes[views]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_edit"
                                                                    name="promocodes[edit]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_create"
                                                                    name="promocodes[create]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2">

                                                                <input form="create-plan" type="checkbox" id="Promocodes_delete"
                                                                    name="promocodes[delete]" value='1' />
                                                                <span></span>

                                                            </td>
                                                            @endif
                                                        </tr>
                                                        

                                                        <tr class="col-12">
                                                            <td class="col-2 pb-2">Settings</td>
                                                            @php
                                                                $settingsFound = false; 
                                                            @endphp
                                                            
                                                         @if (isset($modulelist))
                                                          
                                                            @foreach ($modulelist as $key => $value)
                                                            
                                                             @if($value['menuname']=='settings')
                                                                
                                                               @php
                                                                    $settingsFound = true; 
                                                                @endphp
                                                                <td class="col-12">

                                                                <input form="create-plan" type="checkbox" id="setting_all"
                                                                    name="settings[all]" value="1"
                                                                    <?php if($value['all']=='1'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-12">

                                                                <input form="create-plan" type="checkbox" id="setting_module"
                                                                    name="settings[module]" value="settings"
                                                                    <?php if($value['menuname']=='settings'){ ?> checked <?php  } ?>
                                                                    readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_view"
                                                                    name="settings[views]" value="1"
                                                                    <?php if($value['view']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_edit"
                                                                    name="settings[edit]" value="1"
                                                                    <?php if($value['edit']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_create"
                                                                    name="settings[create]" value="1"
                                                                    <?php if($value['addv']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_delete"
                                                                    name="settings[delete]" value='1'
                                                                    <?php if($value['deletev']=='1'){ ?> checked <?php  } ?> />
                                                                <span></span>

                                                            </td>
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            @if(!$settingsFound)
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_all"
                                                                    name="settings[all]" value="1" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_module"
                                                                    name="settings[module]" value="settings" readonly />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_view"
                                                                    name="settings[views]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_edit"
                                                                    name="settings[edit]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_create"
                                                                    name="settings[create]" value="1" />
                                                                <span></span>

                                                            </td>
                                                            <td class="col-2 pb-2">

                                                                <input form="create-plan" type="checkbox" id="setting_delete"
                                                                    name="settings[delete]" value='1' />
                                                                <span></span>

                                                            </td>
                                                            @endif
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                        <div class="col-sm-12 d-flex">
                                            <div class="add_button">
                                                @if (isset($users))
                                                    <button type="submit" form="create-plan"
                                                        class="btn btn-primary mr-1">Edit</button>
                                                @else
                                                    <button type="submit" form="create-plan"
                                                        class="btn btn-primary mr-1">Add</button>
                                                @endif

                                                <a href="{{ url()->previous() }}" class="btn btn-primary mr-1">Cancel</a>
                                            </div>
                                        </div>
  

                            </fieldset>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="checkbox-toggle.js"></script>
    <script>
    $('#role_all').click(function() {
        $('#role_add').prop('checked', this.checked);
        $('#role_view').prop('checked', this.checked);
        $('#role_edit').prop('checked', this.checked);
        $('#role_addv').prop('checked', this.checked);
        $('#role_deletev').prop('checked', this.checked);
    });

    $('#Client_all').click(function() {
        $('#Client_module').prop('checked', this.checked);
        $('#Client_view').prop('checked', this.checked);
        $('#Client_edit').prop('checked', this.checked);
        $('#Client_create').prop('checked', this.checked);
        $('#Client_delete').prop('checked', this.checked);
    });

    $('#Categories_all').click(function() {
        $('#Categories_module').prop('checked', this.checked);
        $('#Categories_view').prop('checked', this.checked);
        $('#Categories_edit').prop('checked', this.checked);
        $('#Categories_create').prop('checked', this.checked);
        $('#Categories_delete').prop('checked', this.checked);
    });

    $('#Item_all').click(function() {
        $('#Item_module').prop('checked', this.checked);
        $('#Item_view').prop('checked', this.checked);
        $('#Item_edit').prop('checked', this.checked);
        $('#Item_create').prop('checked', this.checked);
        $('#Item_delete').prop('checked', this.checked);
    });

    $('#product_all').click(function() {
        $('#product_module').prop('checked', this.checked);
        $('#product_view').prop('checked', this.checked);
        $('#product_edit').prop('checked', this.checked);
        $('#product_create').prop('checked', this.checked);
        $('#product_delete').prop('checked', this.checked);
    });

    $('#order_all').click(function() {
        $('#order_module').prop('checked', this.checked);
        $('#order_view').prop('checked', this.checked);
        $('#order_edit').prop('checked', this.checked);
        $('#order_create').prop('checked', this.checked);
        $('#order_delete').prop('checked', this.checked);
    });

    $('#Drivers_all').click(function() {
        $('#Drivers_module').prop('checked', this.checked);
        $('#Drivers_view').prop('checked', this.checked);
        $('#Drivers_edit').prop('checked', this.checked);
        $('#Drivers_create').prop('checked', this.checked);
        $('#Drivers_delete').prop('checked', this.checked);
    });
    
    $('#Notification_all').click(function() {
        $('#Notification_module').prop('checked', this.checked);
        $('#Notification_view').prop('checked', this.checked);
        $('#Notification_edit').prop('checked', this.checked);
        $('#Notification_create').prop('checked', this.checked);
        $('#Notification_delete').prop('checked', this.checked);
    });

    $('#Promocodes_all').click(function() {
        $('#Promocodes_module').prop('checked', this.checked);
        $('#Promocodes_view').prop('checked', this.checked);
        $('#Promocodes_edit').prop('checked', this.checked);
        $('#Promocodes_create').prop('checked', this.checked);
        $('#Promocodes_delete').prop('checked', this.checked);
    });
   
    
    $('#setting_all').click(function() {
        $('#setting_module').prop('checked', this.checked);
        $('#setting_view').prop('checked', this.checked);
        $('#setting_edit').prop('checked', this.checked);
        $('#setting_create').prop('checked', this.checked);
        $('#setting_delete').prop('checked', this.checked);
    });
</script>
@endsection
 


<style>
    .form-control {
    background-color: #f5f5f5;
    border: 1px solid #ccc;
}
.form-control {
    color: #67757c;
    min-height: 38px;
    display: initial;
}
.form-control {
    display: block;
    width: 100%;
    /* padding: .375rem .75rem; */
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #ced4da;
    border-radius: .25rem;
    transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
}

.row.restaurant_payout_create .form-group.row .col-7 .form-control {
    width: 100%;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

    .row.restaurant_payout_create {
    max-width: 70%;
    margin: 0 auto;
    display: table;
    width: 100%;
}

.restaurant_payout_create .restaurant_payout_create-inner {
    margin: 0 -10px;
}
.restaurant_payout_create-inner {
    position: relative;
}

.restaurant_payout_create-inner fieldset {
    padding: 10px;
    border: 1px solid #ccc;
    margin-bottom: 15px;
    border-radius: 5px;
    background: #fff;
    position: relative;
}

.restaurant_payout_create-inner fieldset legend {
    background: #013921 ;
}
.restaurant_payout_create-inner fieldset legend {
    display: inline-block;
    width: auto;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    color: #fff;
    padding: 7px 14px;
    background: #013921;
    border-radius: 5px;
}

.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.row.restaurant_payout_create label.control-label {
    color: #000;
    font-weight: 500;
    -webkit-box-flex: 0;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

.row.restaurant_payout_create .form-group.row .col-7 {
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}
.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.form-group.row.width-50 {
    width: 50%;
}

@media screen and (max-width: 991px) {
    .row.restaurant_payout_create {
        max-width: 100%;
    }
    .restaurant_payout_create-inner fieldset {
    display: grid
    }

    .form-group.row.width-50 {
    width: 100%;
}
.row.check{

margin: 15px 0px;
}
}
    .align {
        align-items: center;
    }


    body.g-sidenav-hidden {
        overflow-x: hidden;
    }

    .justify {
        justify-content: center !important;

    }

    h6.h2 {
        font-size: 32px;
    }

    .col-2 {
        padding-right: 30px !important;
        padding-left: 30px !important;
    }

    h3 {
        color: green !important;
        font-size: 18px !important;
    }

    .tab-content-title {
        border-bottom: solid green 2px !important;
        padding: 20px 20px 20px 20px !important;
    }

    .navbar-top.border-bottom.navbar-dark {
        background-color: white !important;
        border-style: doted !important;
    }

    .pb-6,
    .py-6 {
        padding: 0 27px;
    }

    .navbarflex {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
    }

    .navbar-expand .navbar-nav {
        margin-left: 0 !important;
    }



    div#planlist_info {
        color: #4F8A10;
    }

    th {
        color: black !important;
        font-size: 12px !important;
        font-weight: 800 !important;

    }

    .d-flex {
        display: flex !important;
        flex-wrap: wrap;
        justify-content: space-evenly;
    }

    .form-body .form-control {

        border-radius: 10px !important;

        padding: 8px 15px;
        height: 40px;
    }

    label {

        font-size: 16px;
    }

    .navbar .form-control {
        border-radius: 8px;
        border: solid green 2px;
        height: 30px;
        margin: 0px 5px;
        width: 200px;
    }

    .card-header.border-0 {
        border-bottom: solid green 2px !important;
    }

    table.mt-1 {
        max-width: 100%;
        margin: 0 auto;
    }




    th {
        text-align: center;

    }

    .add_button .btn {
        padding: 7px 30px;
    }

    .add_button button.btn {
        margin: 0 30px 0 0px !important;
    }

    .add_button {
        padding-top: 20px;
        padding-bottom: 0px;
    }

    tr {
        text-align: center !important;
    }

    td input {
        padding: 4px 68px;
        margin: 0 6px;
    }

    td.col-2 {
        font-size: 15px;
        padding-top: 10px;
        font-family: serif;

    }

    body.g-sidenav-show.g-sidenav-pinned {
        overflow-x: hidden !important;
    }

    .footer {
        padding-left: 30px !important;
        background: #f8f9fe;
        padding: 30px 0;
    }

    .new-alert.alert.alert-success.alert-dismissible.mb-2 {
        width: 275px !important;
        margin: auto !important;
    }

    .new-alert.alert.alert-success.alert-dismissible.mb-2 {
        width: 275px !important;
    }

    .new-alert.alert.alert-danger.alert-dismissible.mb-2 {
        width: 370px !important;
        margin: 10px auto !important;
    }

    .pb-6,
    .py-6 {
        padding: 40 0px !important;
    }

    /*tablat*/
    @media (min-width:768px) and (max-width:1023px) {
        .main-content .navbar-top .collapse {
            justify-content: space-between;
            ;
        }

        .row {
            overflow: scroll;
        }

        .navbar-expand .navbar-nav {
            margin-left: 0 !important;
        }

        .table td {
            font-size: 16px !important;
        }

        th {
            color: black !important;
            font-size: 16px !important;
            font-weight: 800 !important;
        }

        H3 {
            font-size: 20px !important;
        }

        .btn {
            font-size: 16px !important;

        }

        .actions .delete-action .btn {
            font-size: 14px !important;
            padding: 6px 19px !important;

        }

        table.dataTable.no-footer {
            padding: 15px 0 0 0;
        }

        div#planlist_filter {
            padding: 15px 0px;
        }

        label {
            padding: 0 !important;
            font-size: 18px;
        }

        .col.col-12 {
            border: solid white;
            overflow: auto;
        }

        .col-2 {
            font-size: 16px !important;
        }
    }

    /*mobile*/
    @media (min-width:320px) and (max-width:767px) {
        .alert-dismissible .close {
            top: 50% !important;
            right: 0.5rem !important;
        }

        .new-alert.alert.alert-danger.alert-dismissible.mb-2 {
            width: 300px !important;
            margin: auto !important;
            margin-top: 10px !important;
        }

        .new-alert {
            padding: 10px !important;
            margin-bottom: 10px;
        }

        .table td {
            font-size: 14px !important;
        }

        h6.h2 {
            font-size: 24px;
        }

        th.col-2 {
            text-align: center;
            padding: 0px 0px 10px 0px;
        }

        .row {
            overflow: scroll;
        }



        .footer {
            padding-left: 0px !important;
            background: #f8f9fe;
            padding: 30px 0;
        }

        th {
            color: black !important;
            font-size: 14px !important;
            font-weight: 800 !important;
        }

        H3 {
            font-size: 17px !important;
        }

        .btn {
            font-size: 14px !important;
        }

        .actions .delete-action .btn {
            font-size: 12px !important;
            padding: 6px 19px !important;

        }

        table.dataTable.no-footer {
            padding: 15px 0 0 0;
        }

        div#planlist_filter {
            padding: 15px 0px;
        }

        label {
            padding: 0;
            font-size: 14 px !important;

        }

        .form-control {
            width: 100% !important;
        }

        .col.col-12 {
            border: solid white;
            overflow: auto;
        }

        .col-2 {
            font-size: 14px !important;
        }
    }
</style>
 