@if (count($generalsettings) > 0)

<script>
$(document).ready(function() {
    $('#generalsettings').DataTable({
        "oLanguage": {
            "sSearch": "Search:" // Customize the search placeholder
        },
        "searching": true, // Enable the search functionality
        "order": [[1, "desc"]], // Optional: Sort by the second column (Page Name)
        "fnDrawCallback": function() {
            var api = this.api();
            api.column(0, {search: 'applied', order: 'applied'}).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1; // Update index (ID column) after sorting and searching
            });
        }
    });
});
</script>

<?php 
    $user_id = request()->session()->get('user_id');
    $alldetails = DB::table('rolemenumanage')
     ->where('u_id', $user_id)
     ->get();
?>

<div class="table-responsive">
  <table class="table align-items-center table-flush table-striped" id="generalsettings">
    <thead class="thead-light">
      <tr>
        <th scope="col">ID</th>
        <th scope="col">Page Name</th>
        <th scope="col">Value</th>
        <th scope="col">Action</th>
      </tr>
    </thead>
    <tbody class="list">
      @foreach ($generalsettings as $settings)
      <tr>
        <td class="budget">{{ $settings->id }}</td>
        <td class="budget">{{ $settings->pagename }}</td>        
        <td class="budget">
          @if(strtolower($settings->pagename) == 'contact support')
            {{ $settings->mobile_no }}
          @else
            <span class="description-text">
              {!! strip_tags($settings->description) !!}
            </span>
          @endif
        </td>
        <td class="actions">
        @if(isset($alldetails))
          @foreach($alldetails as $menunamelist)
          @if($menunamelist->menuname == 'settings')
              @if($menunamelist->edit == '1' || Session::get('role') == '1')
              <a style="padding:0 10px;" href="settingsedit/{{$settings->id}}" class="" data-id="{{$settings->id}}">
                <i class="far far fa-edit text-danger" style="padding-top: 12px;"></i>
              </a>
              @endif

              @if($menunamelist->deletev == '1' || Session::get('role') == '1')
              @if ($settings->id != 1)
                <form class="delete-action" style="padding:0 10px;" method="post" action="{{ route('admin.settings.delete', ['id' =>$settings->id]) }}">
                    @csrf
                    @method('DELETE')

                    <label for="deleteButton{{ $settings->id }}" class="none-display">
                        <i class="fa fa-trash text-danger"></i>
                    </label>

                    <input type="submit" id="deleteButton{{ $settings->id }}" style="display: none;">
                </form>
              @endif
              @endif
          @endif
          @endforeach
        @endif
        </td>
      </tr>
      @endforeach
    </tbody>
  </table>
</div>

@else
  <div class="col-md-12 text-center mt-1 mb-1">
    <h3>No plans found</h3>
  </div>
@endif

<script>
function showPermissionAlerts() {
    alert("This is for demo, you are not allowed to edit this content.");
}

function showPermissionAlert() {
    alert("This is for demo, you are not allowed to delete this content.");
}
</script>

<style>
/* Ensure Page Name and Value stay in the same line */
td.budget {
    white-space: nowrap; /* Prevent wrapping and force items to stay on the same line */
    overflow: hidden;
    text-overflow: ellipsis;
}

/* Display the full text in multiple lines without truncating */
.description-text {
    display: block;
    white-space: normal; /* Allow wrapping */
    word-wrap: break-word; /* Break long words to the next line */
    overflow-wrap: break-word; /* Ensure the text wraps correctly */
}

/* Action buttons styling (edit and delete) */
td.actions {
    display: flex;
    align-items: baseline;
}

label.none-display {
    cursor: pointer;
}

/* No hover effect for description */
.description-text:hover {
    overflow: visible;
    white-space: normal;
    word-wrap: break-word;
    background: none;
    padding: 0;
    border-radius: 0;
    position: static;
    box-shadow: none;
}
</style>