@if (count($categorys) > 0)

    <div class="table-responsive">

        <table class="table align-items-center table-flush table-striped" id="categorys">

            <thead class="thead-light">

                <tr>


                    <th scope="col" style="display:none;">

                    <th scope="col">ID</th>

                    <th scope="col">Title</th>

                    <th scope="col">Banner Image</th>

                    <th scope="col">Status</th>

                    <th scope="col">Action</th>

                </tr>

            </thead>

            <tbody class="list">

               <?php $count = count($categorys); ?>

                @foreach ($categorys as $key => $category)

                    <tr>



                        <td class="budget" style="display:none;">{{ $category->id }}</td>

                        <td class="budget">{{ $count - $key }}</td>

                        <td class="budget">{{ $category->title }}</td>

                        <td>

                            <?php $dirpath = URL::asset(''); ?>

                            @if (!empty($category->Banner_Image))

                                <img src="{{ asset('/image/'.$category->image) }}" width="50" height="50">

                            @else

                                <img src="{{ $dirpath }}/image/noimages.png" alt="No Image" width="50" height="50">

                            @endif

                        </td>



                        <td>

                            @if ($category->status == '1')

                                <a class="deactive action active" data-id="{{ $category->id }}" statusid="1"

                                    dataid-id="1" style="color: red;"></a>

                                <label class="switch" style="margin-left: 8px;">

                                    <input type="checkbox" checked>

                                    <span class="slider round" onclick="changeStatus({{ $category->id }}, 2)"></span>

                                </label>

                            @else

                                <a class="deactive action" data-id="{{ $category->id }}" statusid="2" dataid-id="2"

                                    style="color: green;"></a>

                                <label class="switch" style="margin-left: 8px;">

                                    <input type="checkbox">

                                    <span class="slider round" onclick="changeStatus({{ $category->id }}, 1)"></span>

                                </label>

                            @endif

                        </td>



                 <td class="actions">


                                <form class="delete-action" style="padding:0 10px"; method="post"

                                    action="{{ route('admin.categorys.delete', ['id' => $category->id]) }}">

                                    @csrf

                                    @method('DELETE')

                                    <label for="deleteButton{{ $category->id }}" class="none-display">
                                        <i class="fa fa-trash text-danger"></i>
                                    </label>
                                    <input type="submit" id="deleteButton{{ $category->id }}" style="display: none;">

                                </form>



                        <a style="padding:0 10px;" href="categorysedit/{{$category->id}}" class="" data-id="{{$category->id}}">

                            <i class="far far fa-edit text-danger" style="padding-top: 12px;"></i>

                        </a>


        </td>

      </tr>@endforeach</tbody>

    </table>

  </div>@else

  <div class="col-md-12 text-center mt-1 mb-1">

    <h3>No categorys found</h3>

  </div>@endif


  <script>
        function showPermissionAlert() {
    alert("This is for demo, you are not allow to delete this content.");
        }

</script>

<script>

    $(document).ready(function() {

        $('#categorys').dataTable({

            "oLanguage": {

                "sSearch": "search:"

            },

           "searching": true,
        "order": [[1, "desc"]], // Sort by hidden database ID column
        "columnDefs": [
            { "targets": [1], "visible": false, "searchable": false } // Hide database ID column
        ],
        "fnDrawCallback": function() {
            var api = this.api();
            api.column(2, {search: 'applied', order: 'applied'}).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1; // Set row index to start from 1
            });
        }

        });

    });

</script>

<style>

td.actions {
        display: flex;
        align-items: baseline;
    }

    label.none-display {
        cursor: pointer;
    }

    .switch {
            position: relative;
            display: inline-block;
            width: 50px;
            height: 24px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 1px;
            left: 1px;
            right: 0;
            bottom: 0;
            background-color: #f40707 !important;
            transition: 0.4s;
            border-radius: 34px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 20px;
            width: 20px;
            left: 2px;
            bottom: 2px;
            background-color: white;
            transition: 0.4s;
            border-radius: 50%;
        }

        input:checked + .slider {
            background-color: #013921;
        }

        input:checked + .slider:before {
            transform: translateX(26px);
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

    /* Rounded sliders */
    .slider.round {
        border-radius: 34px;
    }

    .slider.round:before {
        border-radius: 50%;
    }

    table#categorys {
    width: 100% !important;
}

</style>

<script>
$(document).ready(function() {
    // Select All functionality
    $('#select-all').change(function() {
        const isChecked = $(this).is(':checked');
        $('input[name="delete_ids[]"]').prop('checked', isChecked);
    });


});
</script>

