@extends('layouts.admin.main') @section('title', 'Category edit')
@section('header')
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-lg-6 col-7">
                <h6 class="h2 text-white d-inline-block mb-0"></h6>
            </div>
        </div>
    </div>
@endsection
@section('content')


    <div class="row">
        <!-- Light table -->
        <div class="col">
            <div class="card">
                <!-- Card header -->
                <div class="card-header border-0">

                    @if (isset($categorys))
                        <h3 class="mb-0">Edit Category</h3>
                    @else
                        <h3 class="mb-0">Add Category</h3>
                    @endif

                </div>
                <div class="card-body mt-3">@include('layouts.messages')
                    @include('layouts.messages')

                    <form enctype="multipart/form-data" method="POST"
                        action="@if (isset($categorys)) {{ route('admin.categoryseditadmin') }} @else {{ route('admin.categorys.add') }} @endif"
                        id="create-canclereason">
                        @csrf
                        <div class="row restaurant_payout_create ">

                            <div class="restaurant_payout_create-inner">

                            <fieldset>
                                <legend >Category Details</legend>
                                            @if (isset($categorys))
                                                <input type="hidden" form="create-canclereason" id="categoryid" name="categoryid"
                                                    value="{{ $categorys->id }}">
                                            @endif


                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label">Name
                                                    <span class=" text-red" style="margin-left: -4px !important;">*</span>
                                                </label>
                                                <div class="col-7">
                                                    <input type="text" form="create-canclereason" id="name" class="form-control" name="name"
                                                        placeholder="Name" value="{{ $categorys->name ?? '' }}" required/>
                                                </div>
                                            </div>

                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label">Image
                                                   @if (!isset($categorys)) <span class=" text-red" style="margin-left: -4px !important;" >*</span>@endif
                                                </label>
                                                <div class="col-7">
                                                    <input type="file" form="create-canclereason" id="image" class="form-control" name="image" accept="image/*"
                                                    placeholder="Image" onchange="loadFile(event)"
                                                    @if (!isset($categorys) || !$categorys->image) required @endif>

                                                    <div id="image-preview-container">
                                                        <!-- Image will be displayed here -->
                                                        @if (isset($categorys) && $categorys->image)
                                                            <!-- Display the current image for edit mode -->
                                                            <img src="{{ asset('/image/' . $categorys->image) }}"
                                                                style="height: 65px; width: 65px; margin-top: 11.1px" id="output"
                                                                class="selected" />
                                                        @else
                                                            <!-- Display the default image -->
                                                            <img src="{{ asset('image') }}"
                                                                style="display: none; height: 65px; width: 65px; margin-top: 11.1px"
                                                                id="output" />
                                                        @endif
                                                     </div>
                                                </div>
                                            </div>


                                            <div class="form-group row width-50">
                                                <div class="col-sm-12">
                                                <label>Status
                                                    <span class="text-red" style="margin-left: -4px !important;" >*</span>
                                                </label>

                                                    <label class="switch" style="margin-left: 8px;">
                                                        <input type="checkbox" id="status-toggle" @if(isset($categorys) && $categorys->status == 1) checked @endif>
                                                        <span class="slider round" onclick="changeStatus()"></span>
                                                    </label>
                                                    <input type="hidden" name="status" id="status" value="{{ isset($categorys) ? $categorys->status : 2,1 }}">
                                                </div>

                                            </div>



                                            <?php if (isset($categorys)): ?>

                                                <button type="submit" form="create-canclereason" class="btn btn-primary mr-1" style=" height: 36px; padding: 7px 30px !important; left: 35%;">Edit</button>


                                                <button  type="submit" form="create-canclereason" class="btn btn-primary mr-1" style=" height: 36px; padding: 7px 30px !important; left: 35%;">Add</button>

                                        <?php endif; ?>
                                        <a href="{{ url()->previous() }}" class="btn btn-primary mr-1" style=" height: 36px; padding: 7px 30px !important;     left: 39%;" >Cancel</a>

                                </fieldset>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    @endsection @section('scripts') @parent
<script></script>@endsection

<script>

document.getElementById('saveButton').addEventListener('click', function(event) {
event.preventDefault();
});

function showPermissionAlertadd(){
    alert("This is for demo, you are not allow to add this content.");
}

function showPermissionAlertedit(){
    alert("This is for demo, you are not allow to update this content.");
}

</script>

<script>

    function changeStatus() {
        var statusToggle = document.getElementById('status-toggle');
        var statusInput = document.getElementById('status');

        if (statusToggle.checked) {
            statusToggle.parentElement.querySelector('.slider').classList.remove('slider-red');
            statusToggle.parentElement.querySelector('.slider').classList.add('slider-green');
            statusInput.value = 1;
        } else {
            statusToggle.parentElement.querySelector('.slider').classList.remove('slider-green');
            statusToggle.parentElement.querySelector('.slider').classList.add('slider-red');
            statusInput.value = 2;
        }
    }

        document.addEventListener('DOMContentLoaded', function () {
            const statusToggle = document.getElementById('status-toggle');
            const statusInput = document.getElementById('status');

            statusToggle.addEventListener('click', function () {
                statusInput.value = statusInput.value === '1' ? '2' : '1';

                if (statusInput.value === '1') {
                    statusToggle.classList.remove('btn-danger');
                    statusToggle.classList.add('btn-success');
                } else {
                    statusToggle.classList.remove('btn-success');
                    statusToggle.classList.add('btn-danger');
                }
            });
        });
</script>
<style>
     .form-control {
    background-color: #f5f5f5;
    border: 1px solid #ccc;
}
.form-control {
    color: #67757c;
    min-height: 38px;
    display: initial;
}
.form-control {
    display: block;
    width: 100%;
    /* padding: .375rem .75rem; */
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #ced4da;
    border-radius: .25rem !important;
    transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
}

.row.restaurant_payout_create .form-group.row .col-7 .form-control {
    width: 100%;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

    .row.restaurant_payout_create {
    max-width: 70%;
    margin: 0 auto;
    display: table;
    width: 100%;
}

.restaurant_payout_create .restaurant_payout_create-inner {
    margin: 0 -10px;
}
.restaurant_payout_create-inner {
    position: relative;
}

.restaurant_payout_create-inner fieldset {
    padding: 10px;
    border: 1px solid #ccc;
    margin-bottom: 15px;
    border-radius: 5px;
    background: #fff;
    position: relative;
}

.restaurant_payout_create-inner fieldset legend {
    background: #013921;
}
.restaurant_payout_create-inner fieldset legend {
    display: inline-block;
    width: auto;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    color: #fff;
    padding: 7px 14px;
    background: #013921;
    border-radius: 5px;
}

.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.row.restaurant_payout_create label.control-label {
    color: #000;
    font-weight: 500;
    -webkit-box-flex: 0;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

.row.restaurant_payout_create .form-group.row .col-7 {
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}
.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.form-group.row.width-50 {
    width: 50%;
}

@media screen and (max-width: 991px) {
    .row.restaurant_payout_create {
        max-width: 100%;
    }
    .restaurant_payout_create-inner fieldset {
    display: grid
    }

    .form-group.row.width-50 {
    width: 100%;
}
.row.check{

margin: 15px 0px;
}
}
td.actions {
        display: flex;
        align-items: baseline;
    }

    label.none-display {
        cursor: pointer;
    }

    .switch {
        position: relative;
        display: inline-block;
        width: 44px;
        height: 21px;
        top: -15px;

    }

    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #f40707;
        -webkit-transition: .4s;
        transition: .4s;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 16px;
        width: 16px;
        left: 2px;
        bottom: 3px;
        background-color: white;
        -webkit-transition: .4s;
        transition: .4s;
    }

    input:checked+.slider {
        background-color: #0d5610;
    }

    input:focus+.slider {
        box-shadow: 0 0 1px #2196F3;
    }

    input:checked+.slider:before {
        -webkit-transform: translateX(26px);
        -ms-transform: translateX(26px);
        transform: translateX(26px);
    }

    /* Rounded sliders */
    .slider.round {
        border-radius: 34px;
    }

    .slider.round:before {
        border-radius: 50%;
    }
element.style {
    display: flex;
    align-items: center;
}

td.actions {
    display: flex;
    align-items: baseline;
}

label.none-display {
        cursor: pointer;
    }

    .justify {
        justify-content: center !important;
    }

    h6.h2 {
        font-size: 32px;
    }

    h3 {
        color: green !important;
        font-size: 18px !important;
    }

    .tab-content-title {
        border-bottom: solid green 2px !important;
        padding: 20px 20px 20px 20px !important;
    }

    .navbar-top.border-bottom.navbar-dark {
        background-color: white !important;
        border-style: doted !important;
    }

    .pb-6,
    .py-6 {
        padding: 0 27px;
    }

    .navbarflex {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
    }

    .navbar-expand .navbar-nav {
        margin-left: 0 !important;
    }

    div#planlist_info {
        color: #4F8A10;
    }

    th {
        color: black !important;
        font-size: 12px !important;
        font-weight: 800 !important;
    }

    .d-flex {
        justify-content: center;
        flex-wrap: wrap;
    }

    .navbar .form-control {
        border-radius: 8px;
        border: solid green 2px;
        height: 30px;
        margin: 0px 5px;
        width: 200px;
    }



    label {

        font-size: 16px;
    }

    .form-control {

        width: 79%;
        padding: 8px 15px;
        height: 40px;
    }



    .add_button .btn {
        padding: 7px 30px;
    }

    h3.mb-0 {
        font-size: 17px !important;
    }



    .card-header.border-0 {
        border-bottom: solid green 2px !important;
    }

    body.g-sidenav-hidden {
        overflow-x: hidden;
    }

    body.g-sidenav-show.g-sidenav-pinned {
        overflow-x: hidden;
    }

    .footer {
        background: #f8f9fe;
        padding: 30px 0;
        padding-left: 30px !important;
    }

    form#create-canclereason {
        margin-bottom: 0px;
    }

    .new-alert.alert.alert-danger.alert-dismissible.mb-2 {
        width: 370px !important;
        margin: 10px auto !important;
    }

    .pb-6,
    .py-6 {
        padding: 40 0px !important;
    }

    /*tablate*/
    @media (min-width:768px) and (max-width:1023px) {
        .main-content .navbar-top .collapse {
            justify-content: space-between;
            ;
        }

        .navbar-expand .navbar-nav {
            margin-left: 0 !important;
        }

        .table td {
            font-size: 16px !important;
        }

        th {
            color: black !important;
            font-size: 16px !important;
            font-weight: 800 !important;
        }

        H3 {
            font-size: 20px !important;
        }

        .btn {
            font-size: 16px !important;

        }

        .actions .delete-action .btn {
            font-size: 14px !important;
        }

        table.dataTable.no-footer {
            padding: 15px 0 0 0;
        }

        div#planlist_filter {
            padding: 15px 0px;
        }

        label {

            font-size: 18px !important;
        }



        .col-md-3 {
            padding-right: 0 !important;
        }

    }

    /*mobile*/
    @media (min-width:320px) and (max-width:767px) {
        .alert-dismissible .close {
            top: 50% !important;
            right: 0.5rem !important;
        }

        .new-alert.alert.alert-danger.alert-dismissible.mb-2 {
            width: 300px !important;
            margin: auto !important;
            margin-top: 10px !important;
        }

        .new-alert {
            padding: 10px !important;
            margin-bottom: 10px;
        }

        .table td {
            font-size: 14px !important;
        }

        th {
            color: black !important;
            font-size: 14px !important;
            font-weight: 800 !important;
        }

        H3 {
            font-size: 27px !important;
        }

        .btn {
            font-size: 14px !important;
        }

        .actions .delete-action .btn {
            font-size: 12px !important;
        }

        table.dataTable.no-footer {
            padding: 15px 0 0 0;
        }

        div#planlist_filter {
            padding: 15px 0px;
        }

        label {
            padding: 0;
            font-size: 14px !important;
        }

        .form-control {
            width: 100% !important;
        }

        .add_button button {
            margin: 0 0 0 0 !important
        }

        .footer {
            background: #f8f9fe;
            padding: 30px 0;
            padding-left: 0px !important;
        }
    }
            footer.footer.pt-0 {
        padding-left: 0px !important;
}
</style>
<script>    function loadFile(event) {
    var output = document.getElementById('output');
    output.src = URL.createObjectURL(event.target.files[0]);
    output.style.display = 'block'; // Show the image preview
}
</script>
