@extends('layouts.admin.main')
@section('title', 'product')
@section('header')
<div class="container-fluid"> 
    <div class="row align-items-center ">
        <div class="col-lg-6 col-7">
            <h6 class="h2 text-white d-inline-block mb-0"></h6>
        </div>
    </div>
</div>
@endsection
@section('content')
<?php 
    $user_id=request()->session()->get('user_id');
    $alldetails = DB::table('rolemenumanage')
    ->where('u_id',$user_id)
    ->get();
?>
<div class="row ">
    <!-- Light table -->
    <div class="col">
        <div class="card">
            <!-- Card header -->
            <div class="card-header border-0">

            @if(isset($products))
                <h3 class="mb-0">Edit Product</h3>
                @else
                <h3 class="mb-0">Add Product</h3>
                @endif

            </div>
            <div class="card-body mt-3">@include('layouts.messages')
            @if(isset($alldetails))
                    @foreach($alldetails as $menunamelist)
                    @if($menunamelist->menuname=='product')
                    @if($menunamelist->addv == '1' || $menunamelist->edit == '1' || $menunamelist->addv == '0' || $menunamelist->edit == '0' || Session::get('role') == '1') 
                <form enctype="multipart/form-data" method="POST"
                    action="@if(isset($products)) {{ route('admin.producteditadmin') }} @else {{ route('admin.product.create') }} @endif"
                    id="create-plan">@csrf
                    <div class="row restaurant_payout_create ">

                        <div class="restaurant_payout_create-inner">

                            <fieldset>
                                <legend>Product Details</legend>
                                <div class="form-group row width-50">
                                    <label class="col-3 control-label">Product Name
                                        <span class="m-l-5 text-red">*</span>
                                    </label>
                                    
                                    @if(isset($products))
                                    <input type="hidden" form="create-plan" id="roleid" class="form-control" name="productid" placeholder="id" value="@if(isset($products)){{$products['id']}}@endif">
                                    @endif
                                    <div class="col-7">
                                        <input type="text" form="create-plan" id="name" class="form-control" name="productname" placeholder="Product Name" value="@if(isset($products)){{$products['productname']}}@endif"  required >
                                    </div>
                                </div> 
                                
                                    

                                <div class="form-group row width-50">
                                        <label class="col-3 control-label">Category Name
                                            <span class="m-l-5 text-red">*</span>
                                        </label>
                                    
                                        <div class="col-7">
                                            <select form="create-plan" name="c_id" class="form-control" required >
                                                @foreach($categorys as $categoryname)
                                                <option value="{{$categoryname->id}}"
                                                    <?php if(isset($products)){ if($products->c_id==$categoryname->id) echo 'selected="selected"';}?>>
                                                    {{$categoryname->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                
                                <div class="col-md-3 col-sm-3 col-lg-2">
                                        <label>Description
                                            <span class="m-l-5 text-red">*</span>
                                        </label>
                                    </div>

                                    <div class="col-12 form-group">
                                        <textarea style=" height: 10em;" form="create-plan" id="myTextarea"
                                            name="productdetails" id="productdetails" class="form-control"
                                            placeholder=" ">@if(isset($products)){{$products->productdetails}} @endif</textarea>
                                    </div>
                                    <?php 
                                            $generalsettings = DB::table('generalsettings')->where('packname', 'com.imart.grossary.grossryapp')->first();
                                        
                                            
                                        ?>
                                    <div class="form-group row width-50">
                                        <label class="col-3 control-label">Prices ({{$currencySymbol}})
                                            <span class="m-l-5 text-red">*</span>
                                        </label>
                                    
                                        <div class="col-7">
                                            <input type="text" form="create-plan" id="prices" class="form-control" name="prices" placeholder="Prices"
                                            value="{{ isset($products) ? $products['prices'] : '' }}"  required  pattern="[0-9,9-0]+" title="Please enter numbers only">
                                        </div>
                                    </div>
                                    
                                  
                                    <div class="form-group row width-50">
                                        <label class="col-3 control-label">Kind Of Product
                                            <span class="m-l-5 text-red">*</span>
                                        </label>
                                   
                                        <div class="col-7">
                                            <select name="producttype" form="create-plan" class="form-control"  @if (!isset($products)) required @endif>
                                                <option value="3" <?php if(isset($products)){ if($products['producttype']=="3" ){?>selected="selected"
                                                    <?php } }?>>--Non Select--</option>
                                                <option value="1" <?php if(isset($products)){ if($products['producttype']=="1" ){?>selected="selected"
                                                    <?php } }?>>Featured Products</option>
                                                <option value="2" <?php if(isset($products)){ if($products['producttype']=="2" ){?>selected="selected"
                                                    <?php } }?>>Popular Products</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row width-50 ">
                                        <label class="col-3 control-label">Total Quantity
                                            <span class="m-l-5 text-red">*</span>
                                        </label>
                            
                                        <div class="col-7">
                                            <input type="text" form="create-plan" id="total_qty" class="form-control" name="total_qty" placeholder="Total Quantity" value="@if(isset($products)){{$products['total_qty']}}@endif"  pattern="[0-9,9-0]+" title="Please enter numbers only">
                                        </div>
                                        </div>    

                                    <div class="form-group row width-50">
                                        <label class="col-3 control-label">On Handqty
                                            <span class="m-l-5 text-red">*</span>
                                        </label>
                                    
                                        <div class="col-7">
                                            <input type="text" form="create-plan" id="onhand_qty" class="form-control" name="onhand_qty" placeholder="On Handqty" value="@if(isset($products)){{$products['onhand_qty']}}@endif"  pattern="[0-9,9-0]+" title="Please enter numbers only">
                                        </div>
                                    </div>

                                    <div class="form-group row width-50">
                                        <label class="col-3 control-label">Discount Price
                                            <span class="m-l-5 text-red">*</span>
                                        </label>
                                        <div class="col-7">
                                            <div class="input-group">
                                                <input type="text" form="create-plan" id="discount_price" class="form-control" name="discount_price" placeholder="Discount Price" value="{{ isset($products) ? $products['discount_price'] : '' }}"  pattern="[0-9,9-0,%]+" title="Please enter numbers only">
                                            
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row width-50 ">
                                        <label class="col-3 control-label">Product Images
                                           @if (!isset($products)) <span class="m-l-5 text-red">*</span>@endif
                                        </label>
                                    
                                        <div class="col-7">
                                            <input type="file" form="create-plan" name="images[]" accept="image/*" class="form-control" onchange="loadPreview(this)" @if (!isset($products)) required @endif multiple />
                                            <span id="thumb-output" width="30" height="30"></span>
                                        </div>
                                    
                                        <div class="col-7 form-group mt-2 mar">
                                            @if(isset($products))
                                                <?php $usersimages = DB::table('productimage')->where('p_id', $products['id'])->get(); ?>
                                                @foreach ($usersimages as $value)
                                                    <span class="image-wrapper" id="image-{{ $value->id }}" style="padding:0 20px; position: relative;">
                                                        <i class="fa fa-trash text-danger delete"
                                                        style="cursor: pointer; position: absolute; top: -8px; right: 10px;"
                                                        data-id="{{ $value->id }}"></i>

                                                        <img src="{{ asset('public/productimages/'.$value->images) }}"
                                                            width="10%" height="60">
                                                    </span>
                                                @endforeach
                                            @endif
                                        </div>


                                    </div>
                             
                                    <div class="col-md-3 col-sm-3 col-lg-2">
                                        <label>Item Attribute
                                            <span class="m-l-5 text-red">*</span>
                                        </label>
                                    </div>
                                    
                                    <div class="col-12 form-group">
                                        <select form="create-plan" id="productitemsattr"
                                            name="productitemsattr[]" class="form-control"
                                            placeholder=" " multiple>
                                            <?php $items=App\Models\Items::select('id', 'name')->get();
                                            $selectedAttributes = isset($products['productitemsattr']) ? explode(', ', $products['productitemsattr']) : [];
                                            ?>
                                            
                                                @foreach ($items as $item)
                                                <option value="{{$item->name}}" <?php 
                                                    if (in_array($item->name, $selectedAttributes)) {
                                                        echo 'selected="selected"';
                                                    } 
                                                ?>>{{$item->name}}</option>
                                                @endforeach
                                        </select>
                                    </div>

                                    <div id="dynamicFields"></div>

                                    <div class="form-group row width-50 ">
                                        <div class="col-sm-12">
                                            <label>Status
                                                <span class="m-l-5 text-red">*</span>
                                            </label>
                                            <label class="switch" style="margin-left: 8px;">
                                                <input type="checkbox" id="status-toggle" @if(isset($products) && $products->status == 1) checked @endif>
                                                <span class="slider round" onclick="changeStatus()"></span>
                                            </label>
                                            <input type="hidden" name="status" id="status" value="{{ isset($products) ? $products->status : 2,1 }}">
                                        </div>
                                    </div>
                            
                                   <div class="col-sm-12 d-flex">
                                        <div class="add_button">
                                         @if(isset($products))
                                            <button type="submit" form="create-plan"
                                                class="btn btn-primary mr-1 mb-1">Edit</button>
                                                @else
                                                <button type="submit" form="create-plan"
                                                class="btn btn-primary mr-1 mb-1">Add</button>
                                        @endif
                                        <a href="{{ url()->previous() }}" class="btn btn-primary mr-1">Cancel</a>
                                        
                                                 <!-- <?php if (isset($products)): ?>
                                                    <?php if ($menunamelist->edit == '0' && Session::get('role') != '1'): ?>
                                                        <button type="submit" class="btn btn-primary mr-1" onclick="showPermissionAlertedit()">Edit</button>
                                                    <?php else: ?>
                                                        <button type="submit"  class="btn btn-primary mr-1" form="create-canclereason">Edit</button>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <?php if ($menunamelist->addv == '0' && Session::get('role') != '1'): ?>
                                                        <button type="submit" class="btn btn-primary mr-1" onclick="showPermissionAlertadd()">Add</button>
                                                    <?php else: ?>
                                                        <button type="submit" class="btn btn-primary mr-1" form="create-canclereason">Add</button>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <a href="{{ url()->previous() }}" class="btn btn-primary mr-1">Cancel</a> -->
                                            </div>
                                        </div> 
                                </div>
                            </fieldset>
                        </div>
                    </div>
               </form>
               @endif 
                    @endif
        @endforeach 
        @endif
            </div>
        </div>
    </div>

</div>
@endsection @section('scripts') @parent
<script>

document.getElementById('saveButton').addEventListener('click', function(event) {
event.preventDefault();
});

function showPermissionAlertadd(){
    alert("This is for demo, you are not allow to add this content.");
}

function showPermissionAlertedit(){
    alert("This is for demo, you are not allow to update this content.");
}

</script>

<script>
    $(document).ready(function() {
        function loadDynamicFields(selectedOptions) {
            // Clear the dynamic fields container
            $('#dynamicFields').empty();

            // Check if any options are selected
            if (selectedOptions && selectedOptions.length > 0) {
                selectedOptions.forEach(function(option) {
                    var inputField = '';
                    var existingValue = ''; // Placeholder for existing values

                    // Get existing values from PHP variables
                    switch (option) {
                        case 'Size':
                            existingValue = "{{ isset($products->size) ? $products->size : '' }}"; // Get existing size
                            inputField = `
                                <div class="col-12 form-group" id="sizeField">
                                    <label for="size">Size</label>
                                    <input type="text" id="size" name="size" class="form-control" placeholder="Enter size" value="${existingValue}">
                                </div>`;
                            break;
                        case 'Weight':
                            existingValue = "{{ isset($products->weight) ? $products->weight : '' }}"; // Get existing weight
                            inputField = `
                                <div class="col-12 form-group" id="weightField">
                                    <label for="weight">Weight</label>
                                    <input type="text" id="weight" name="weight" class="form-control" placeholder="Enter weight" value="${existingValue}">
                                </div>`;
                            break;
                        case 'Type':
                            existingValue = "{{ isset($products->type) ? $products->type : '' }}"; // Get existing type
                            inputField = `
                                <div class="col-12 form-group" id="typeField">
                                    <label for="type">Type</label>
                                    <input type="text" id="type" name="type" class="form-control" placeholder="Enter type" value="${existingValue}">
                                </div>`;
                            break;
                        // Add more cases for new attributes here
                    }

                    // Append the created input field to the dynamicFields container
                    if (inputField) {
                        $('#dynamicFields').append(inputField);
                    }
                });
            }
        }

        // Load dynamic fields when the dropdown value changes
        $('#productitemsattr').change(function() {
            var selectedOptions = $(this).val();
            console.log('Selected options:', selectedOptions); // Debug log
            loadDynamicFields(selectedOptions);
        });

        // Initial loading of dynamic fields based on selected options
        var initialSelectedOptions = $('#productitemsattr').val(); // Get initially selected options
        loadDynamicFields(initialSelectedOptions); // Load them
    });
</script>
<script>
    

    function changeStatus() {
        var statusToggle = document.getElementById('status-toggle');
        var statusInput = document.getElementById('status');

        if (statusToggle.checked) {
            statusToggle.parentElement.querySelector('.slider').classList.remove('slider-red');
            statusToggle.parentElement.querySelector('.slider').classList.add('slider-green');
            statusInput.value = 1;
        } else {
            statusToggle.parentElement.querySelector('.slider').classList.remove('slider-green');
            statusToggle.parentElement.querySelector('.slider').classList.add('slider-red');
            statusInput.value = 2;
        }
    }

        document.addEventListener('DOMContentLoaded', function () {
            const statusToggle = document.getElementById('status-toggle');
            const statusInput = document.getElementById('status');

            statusToggle.addEventListener('click', function () {
                statusInput.value = statusInput.value === '1' ? '2' : '1';

                if (statusInput.value === '1') {
                    statusToggle.classList.remove('btn-danger');
                    statusToggle.classList.add('btn-success');
                } else {
                    statusToggle.classList.remove('btn-success');
                    statusToggle.classList.add('btn-danger');
                }
            });
        });
</script>
<script src="//cdnjs.cloudflare.com/ajax/libs/tinymce/4.5.1/tinymce.min.js"></script>
<script type="text/javascript">
tinymce.init({
    selector: '#myTextarea',
    height: 200,
    theme: 'modern',
    plugins: [
        'advlist autolink lists link image charmap print preview hr anchor pagebreak',
        'searchreplace wordcount visualblocks visualchars code fullscreen',
        'insertdatetime media nonbreaking save table contextmenu directionality',
        'emoticons template paste textcolor colorpicker textpattern imagetools'
    ],
    toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
    toolbar2: 'print preview media | forecolor backcolor emoticons',
    image_advtab: true
});
</script>
<script>
tinymce.init({
    selector: 'textarea#editor', //Change this value according to your HTML
    auto_focus: 'element1',
    width: "300",
    height: "100"
});

$(document).ready(function() {

    $('#buttonpost').on("click", function() {
        tinyMCE.triggerSave();
        var value = $("textarea#editor").val();
        $("#display-post").html(value);
        $(".texteditor-container").hide();
        return false;
    });
});
</script>
<script>
$(document).ready(function () {
    $('.delete').on('click', function (event) {
        event.preventDefault();

        if (confirm('Are you sure you want to delete this image?')) {
            let imageId = $(this).data('id');
            let imageWrapper = $('#image-' + imageId);

            $.ajax({
                url: '{{ route("imagesdelete") }}',
                method: 'POST',
                data: {
                    imagesid: imageId,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function (data) {
                    if (data.status === 'success') {
                        imageWrapper.remove(); 
                    } else {
                        alert('Failed to delete image.');
                    }
                },
                error: function () {
                    alert('Something went wrong.');
                }
            });
        }
    });
});
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script>
function loadPreview(input) {

    var data = $(input)[0].files;

    $.each(data, function(index, file) {

        if (/(\.|\/)(gif|jpe?g|png)$/i.test(file.type)) {

            var fRead = new FileReader();

            fRead.onload = (function(file) {

                return function(e) {

                    var img = $('<img/>').addClass('thumb').attr('src', e.target
                        .result); //create image thumb element

                    $('#thumb-output').append(img);

                };

            })(file);

            fRead.readAsDataURL(file);

        }

    });

}
</script>

<style>
     .form-control {
    background-color: #f5f5f5;
    border: 1px solid #ccc;
}
.form-control {
    color: #67757c;
    min-height: 38px;
    display: initial;
}
.form-control {
    display: block;
    width: 100%;
    /* padding: .375rem .75rem; */
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #ced4da;
    border-radius: .25rem;
    transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
}

.row.restaurant_payout_create .form-group.row .col-7 .form-control {
    width: 100%;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

    .row.restaurant_payout_create {
    max-width: 70%;
    margin: 0 auto;
    display: table;
    width: 100%;
}

.restaurant_payout_create .restaurant_payout_create-inner {
    margin: 0 -10px;
}
.restaurant_payout_create-inner {
    position: relative;
}

.restaurant_payout_create-inner fieldset {
    padding: 10px;
    border: 1px solid #ccc;
    margin-bottom: 15px;
    border-radius: 5px;
    background: #fff;
    position: relative;
}

.restaurant_payout_create-inner fieldset legend {
    background: #00b761;
}
.restaurant_payout_create-inner fieldset legend {
    display: inline-block;
    width: auto;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    color: #fff;
    padding: 7px 14px;
    background: #A3CB38;
    border-radius: 5px;
}

.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.row.restaurant_payout_create label.control-label {
    color: #000;
    font-weight: 500;
    -webkit-box-flex: 0;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

.row.restaurant_payout_create .form-group.row .col-7 {
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}
.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.form-group.row.width-50 {
    width: 50%;
}

@media screen and (max-width: 991px) {
    .row.restaurant_payout_create {
        max-width: 100%;
    }
    .restaurant_payout_create-inner fieldset {
    display: grid
    }

    .form-group.row.width-50 {
    width: 100%;
}
.row.check{

margin: 15px 0px;
}
}
td.actions {
        display: flex;
        align-items: baseline;
    }

    label.none-display {
        cursor: pointer;
    }

    .switch {
        position: relative;
        display: inline-block;
        width: 44px;
        height: 21px;
       

    }

    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #f40707;
        -webkit-transition: .4s;
        transition: .4s;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 16px;
        width: 16px;
        left: 2px;
        bottom: 3px;
        background-color: white;
        -webkit-transition: .4s;
        transition: .4s;
    }

    input:checked+.slider {
        background-color: #0d5610;
    }

    input:focus+.slider {
        box-shadow: 0 0 1px #2196F3;
    }

    input:checked+.slider:before {
        -webkit-transform: translateX(26px);
        -ms-transform: translateX(26px);
        transform: translateX(26px);
    }

    /* Rounded sliders */
    .slider.round {
        border-radius: 34px;
    }

    .slider.round:before {
        border-radius: 50%;
    }
element.style {
    display: flex;
    align-items: center;
}

td.actions {
    display: flex;
    align-items: baseline;
}

label.none-display {
        cursor: pointer;
    }


.justify {
    justify-content: center !important;
}

.thumb {
    padding: 5px;
    width: 20%;
    height: 60px;
}

.pad {
    padding-left: 240px;
}

h6.h2 {
    font-size: 32px;
}

h3 {
    color: green !important;
    font-size: 18px !important;
}

.tab-content-title {
    border-bottom: solid green 2px !important;
    padding: 20px 20px 20px 20px !important;
}


.navbar-top.border-bottom.navbar-dark {
    background-color: white !important;
    border-style: doted !important;
}
.navbarflex {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
}

.navbar-expand .navbar-nav {
    margin-left: 0 !important;
}


div#planlist_info {
    color: #4F8A10;
}

th {
    color: black !important;
    font-size: 12px !important;
    font-weight: 800 !important;
}

.d-flex {
    display: flex !important;
    flex-wrap: wrap;
    justify-content: space-evenly;
}

.form-body .form-control {
    border-radius: 10px !important;
    width: 79% !important;
    padding: 8px 15px;
    height: 40px;
}

label {

    font-size: 16px;
}

.navbar .form-control {
    border-radius: 8px;
    height: 30px;
    margin: 0px 5px;
    width: 200px;
}

.card-header.border-0 {
    border-bottom: solid green 2px !important;
}

table.mt-1 {
    max-width: 100%;
    margin: 0 auto;
}

.col.s12 {
    padding: 45px 0;
}

th.col-md-2 {
    text-align: center;
    padding: 0px 50px 10px 0px;
}

.add_button .btn {
    padding: 7px 30px;
}

.add_button button.btn {
    margin: 0 30px 0 0px !important;
}



td input {
    padding: 4px 68px;
    margin: 0 35px;
}

td.col-md-2 {
    font-size: 15px;
    padding-top: 10px;
    font-family: serif
}

div#mceu_21 {
    width: 100%;
}

input[type="file"] {
    width: 100% !important;
    padding: 5px 10px !important;
}

iframe#myTextarea_ifr {
    height: 130px !important;
}

.form-group {
    margin-bottom: 40px;
}
.main-content{
    overflow-x: hidden !important;
}
.footer{
    padding-left:30px !important;
}
.new-alert.alert.alert-danger.alert-dismissible.mb-2 {
    width: 370px !important;
    margin: 0px auto 10px !important;
}
.pb-6, .py-6 {
    padding-bottom: 5.7rem !important;
}
/*tablat*/
@media (min-width:768px) and (max-width:1023px) {
    .main-content .navbar-top .collapse {
        justify-content: space-between;
        ;
    }

    .navbar-expand .navbar-nav {
        margin-left: 0 !important;
    }

    .table td {
        font-size: 16px !important;
    }

    th {
        color: black !important;
        font-size: 16px !important;
        font-weight: 800 !important;
    }

    H3 {
        font-size: 20px !important;
    }

    .btn {
        font-size: 16px !important;

    }

    .actions .delete-action .btn {
        font-size: 14px !important;
        padding: 6px 19px !important;

    }

    table.dataTable.no-footer {
        padding: 15px 0 0 0;
    }

    div#planlist_filter {
        padding: 15px 0px;
    }

    .add_button {
        padding: 5px 0 30px 0;
    }


    label {
        padding: 0 !important;
        font-size: 18px;
    }
}

/*mobile*/
@media (min-width:320px) and (max-width:767px) {
    .alert-dismissible .close {
    top: 50% !important;
    right: 0.5rem !important;
}
    .new-alert.alert.alert-danger.alert-dismissible.mb-2 {
    width: 300px !important;
    margin: auto !important;
    margin-top:10px !important;
}

.new-alert {
    padding: 10px !important;
    margin-bottom: 10px;
}
    .table td {
        font-size: 14px !important;
    }

    .form-body .form-control {
        border-radius: 10px !important;
        width: 100% !important;
    }

    div#mceu_21 {
        width: 100% !important;
    }

    th {
        color: black !important;
        font-size: 14px !important;
        font-weight: 800 !important;
    }

    H3 {
        font-size: 17px !important;
    }

    .btn {
        font-size: 14px !important;
    }

    .actions .delete-action .btn {
        font-size: 12px !important;
        padding: 6px 19px !important;

    }

    table.dataTable.no-footer {
        padding: 15px 0 0 0;
    }

    div#planlist_filter {
        padding: 15px 0px;
    }

    label {
        padding: 0;
        font-size: 14px !important;

    }

    div#mceu_21 {
        width: 100%;
    }

    .form-control {
        width: 100% !important;
    }

    .col.s12 {
        border: solid white;
        overflow: auto;
    }

    .add_button {
        padding: 0 0 0px 0;
    }


    td.col-md-2 {
        font-size: 20px !important;
    }

    .mar {
        margin: 0 !important;
    }
    .footer{
    padding-left:0px !important;
}
}
</style> @endsection