<?php
namespace App\Http\Controllers\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use App\User;
use App\job_lookings;
use App\payment;
use App\settings;
use App\canclereasons;
use App\tickitsystems;
use App\notificationdetails;
use App\Jobs;
use App\categorys;
use App\country;
use App\states;
use App\citys;

class UsersController extends Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->middleware('auth');
    }

    public function index()
    {
        if (request()->ajax()) {
            $users = User::select('id', 'name', 'email', 'contact_no', 'role', 'created_at', 'status')
                ->users()
                ->orderBy('id', 'desc')
                ->paginate(15);

            return view('admin.users.index_ajax', compact('users'));
        } else {
            return view('admin.users.index');
        }
    }
    public function useredit($id)
    {
        $users = User::where('id', $id)->first();

        return view('admin.users.add', compact('users'));
        exit();
    }
    public function agentedit($id)
    {
        $users = User::where('id', $id)->first();

        return view('admin.agent.add', compact('users'));
        exit();
    }
    public function agentview($id)
    {
        $users = User::where('id', $id)->first();
        $refer_code = User::where('refer_code', $users['refer_code'])->get();
        return view('admin.agent.view', compact('users', 'refer_code'));
        exit();
    }
    public function employeredit($id)
    {
        $joblookings = job_lookings::get();
        $users = User::where('id', $id)->first();

        return view('admin.company.add', compact('joblookings', 'users'));
        exit();
    }

    public function usereditadmin(Request $request)
    {
        $id = request()->get('userid');
        $imagepath = public_path() . '/barangaycertificate';
        if ($request->File('barangaycertificate')) {
            $img_ext = $request->File('barangaycertificate')->getClientOriginalExtension();
            $filename = 'barangaycertificate-' . time() . '.' . $img_ext;
            $path = $request->file('barangaycertificate')->move($imagepath, $filename); //image save public folder
        }
        $imagepath = public_path() . '/policeclearance';
        if ($request->File('policeclearance')) {
            $img_ext = $request->File('policeclearance')->getClientOriginalExtension();
            $file = 'policeclearance-' . time() . '.' . $img_ext;
            $path = $request->file('policeclearance')->move($imagepath, $file); //image save public folder
        }
        $imagepath = public_path() . '/biodata';
        if ($request->File('biodata')) {
            $img_ext = $request->File('biodata')->getClientOriginalExtension();
            $biodata = 'biodata-' . time() . '.' . $img_ext;
            $path = $request->file('biodata')->move($imagepath, $biodata); //image save public folder
        }
        if (!empty($filename)) {
            $updateStatus = [
                'barangaycertificate' => $filename,
            ];
            User::where('id', '=', $id)->update($updateStatus);
        }
        if (!empty($file)) {
            $updateStatus = [
                'policeclearance' => $file,
            ];
            User::where('id', '=', $id)->update($updateStatus);
        }
        if (!empty($biodata)) {
            $updateStatus = [
                'biodata' => $biodata,
            ];
            User::where('id', '=', $id)->update($updateStatus);
        }
        $updateStatus = [
            'name' => request()->get('name'),
            'email' => request()->get('email'),
            'contact_no' => request()->get('contact_no'),
            'Preferjoblocation' => request()->get('Preferjoblocation'),
            'birthdate' => request()->get('birthdate'),
            'province' => request()->get('province'),
            'city' => request()->get('city'),
            'zipcode' => request()->get('zipcode'),
            'address' => request()->get('address'),
            'gender' => request()->get('gender'),
            'jobtype' => request()->get('jobtype'),
        ];

        User::where('id', '=', $id)->update($updateStatus);

        return redirect()->route('admin.users.index');
        exit();
    }
    public function agenteditadmin(Request $request)
    {
        $id = request()->get('userid');

        if ($request->File('barangaycertificate')) {
            $imagepath = public_path() . '/barangaycertificate';
            $img_ext = $request->File('barangaycertificate')->getClientOriginalExtension();
            $filename = 'barangaycertificate-' . time() . '.' . $img_ext;
            $path = $request->file('barangaycertificate')->move($imagepath, $filename);

            $updateStatus = [
                'barangaycertificate' => $filename,
            ];
            User::where('id', '=', $id)->update($updateStatus);
        }
        if ($request->File('policeclearance')) {
            $imagepath = public_path() . '/policeclearance';
            $img_ext = $request->File('policeclearance')->getClientOriginalExtension();
            $file = 'policeclearance-' . time() . '.' . $img_ext;
            $path = $request->file('policeclearance')->move($imagepath, $file); //image save public folder

            $updateStatus = [
                'policeclearance' => $file,
            ];
            User::where('id', '=', $id)->update($updateStatus);
            return redirect()->route('admin.agentusers.index');
            exit();
        }
        $updateStatus = [
            'name' => request()->get('name'),
            'email' => request()->get('email'),
            'fullyvaccinated' => request()->get('fullyvaccinated'),
            'contact_no' => request()->get('contact_no'),
            'age' => request()->get('age'),
            'officeaddress' => request()->get('officeaddress'),
            'officeregister' => request()->get('officeregister'),
        ];
        User::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.agentusers.index');
        exit();
    }
    public function employereditadmin(Request $request)
    {
        $role = request()->get('userid');
        $userrole = User::where('id', $role)->first();
        $imagepath = public_path() . '/barangaycertificate';
        if ($request->File('barangaycertificate')) {
            $img_ext = $request->File('barangaycertificate')->getClientOriginalExtension();
            $filename = 'ba-' . time() . '.' . $img_ext;
            $path = $request->file('barangaycertificate')->move($imagepath, $filename); //image save public folder
        } else {
            $filename = '';
        }

        if ($userrole['role'] == 'individual') {
            if (!empty($filename)) {
                $updateStatus = [
                    'barangaycertificate' => $filename,
                ];
                User::where('id', '=', $role)->update($updateStatus);
            }
            $updateStatus = [
                'name' => request()->get('name'),
                'email' => request()->get('email'),
                'fullyvaccinated' => request()->get('fullyvaccinated'),
                'alternatephonenumber' => request()->get('alternatephonenumber'),
                'contact_no' => request()->get('contact_no'),
                'age' => request()->get('age'),
                'address' => request()->get('address'),
                'officeaddress' => request()->get('officeaddress'),
                'officeregister' => request()->get('officeregister'),
                'Looking' => request()->get('Looking'),
            ];
            User::where('id', '=', $role)->update($updateStatus);
            return redirect()->route('admin.companyusers.index');
            exit();
        } else {
            if (!empty($filename)) {
                $updateStatus = [
                    'barangaycertificate' => $filename,
                ];
                User::where('id', '=', $role)->update($updateStatus);
            }
            $updateStatus = [
                'name' => request()->get('name'),
                'fullyvaccinated' => request()->get('fullyvaccinated'),
                'alternatephonenumber' => request()->get('alternatephonenumber'),
                'email' => request()->get('email'),
                'contact_no' => request()->get('contact_no'),
                'age' => request()->get('age'),
                'address' => request()->get('address'),
                'tinnumber' => request()->get('tinnumber'),
                'gender' => request()->get('gender'),
                'officeaddress' => request()->get('officeaddress'),
                'officeregister' => request()->get('officeregister'),
                'Looking' => request()->get('Looking'),
            ];

            User::where('id', '=', $role)->update($updateStatus);
            return redirect()->route('admin.companyusers.index');
            exit();
        }
    }

    public function delete($id)
    {
        $users = User::select('id')->first($id);

        if (isset($users)) {
            User::where('id', $id)->delete();
            $data = [
                'msg' => 'users deleted successfully.',
                'status' => 'success',
            ];
            return $data;
            exit();
            //$this->CommonHelper->sendJsonResponse(false, [], ['users deleted successfully.'], '');
        } else {
            $data = [
                'msg' => 'Failed to delete users. Please try again.',
                'status' => 'success',
            ];
            return $data;
            exit();
            //$this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete users. Please try again.'], '', 500);
        }
    }
    public function agentindex()
    {
        if (request()->ajax()) {
            $users = User::select('id', 'name', 'email', 'contact_no', 'role', 'created_at', 'status')
                ->where('role', 'agent')
                ->orderBy('id', 'desc')
                ->paginate(15);

            return view('admin.agent.index_ajax', compact('users'));
        } else {
            return view('admin.agent.index');
        }
    }
    public function companyindex()
    {
        if (request()->ajax()) {
            $users = User::select('id', 'name', 'email', 'contact_no', 'role', 'created_at', 'status')
                ->where('role', "!=", 'agent')
                ->where('role', "!=", 'user')
                ->where('role', "!=", 'admin')
                ->orderBy('id', 'desc')
                ->paginate(15);

            return view('admin.company.index_ajax', compact('users'));
        } else {
            return view('admin.company.index');
        }
    }

    public function useractive($id)
    {
        $Providers = User::find($id);
        if (empty($Providers)) {
            return createResponse(config('httpResponse.NOT_FOUND'), 'Patients does not exist', ['error' => 'Patients does not exist']);
        }
        if ($Providers['status'] == '1') {
            $status = '2';
            $mailpath = public_path();
            $updateStatus = [
                'Status' => $status,
            ];
            $updateData = User::where('id', '=', $id)->update($updateStatus);
            $data = [
                'msg' => 'User Activated Successfully!',
                'status' => 'success',
            ];
        } else {
            $status = '1';
            $updateStatus = [
                'Status' => $status,
            ];
            $updateData = User::where('id', '=', $id)->update($updateStatus);
            // Success Flash msg
            $data = [
                'msg' => 'Provider Activated Successfully!',
                'status' => 'success',
            ];
        }

        return $data;
    }
    public function joblookingindex()
    {
        if (request()->ajax()) {
            $joblookings = job_lookings::select('id', 'name')->paginate(5);

            return view('admin.joblooking.index_ajax', compact('joblookings'));
        } else {
            return view('admin.joblooking.index');
        }
    }
    public function add()
    {
        return view('admin.joblooking.add');
    }

    public function create(Request $request)
    {
        $useraddste = '1';
        $joblookingsadd = job_lookings::create([
            'name' => $request->get('name'),

            'status' => $useraddste,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);

        return redirect()->route('admin.joblooking.index');
        exit();
    }

    public function joblookingedit($id)
    {
        $joblookings = job_lookings::where('id', $id)->first();

        return view('admin.joblooking.add', compact('joblookings'));
        exit();
    }
    public function jobdelete($id)
    {
        $joblookings = job_lookings::select('id')->findOrFail($id);

        if ($joblookings->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['joblookings deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete users. Please try again.'], '', 500);
        }
    }
    public function joblookingeditadmin(Request $request)
    {
        $useraddste = 1;
        $id = request()->get('joblookingid');

        $updateStatus = [
            'name' => request()->get('name'),
            'status' => $useraddste,
        ];
        job_lookings::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.joblooking.index');
        exit();
    }
    public function paymentindex()
    {
        if (request()->ajax()) {
            $paymentdetails = payment::select('id', 'name', 'location', 'company_name', 'address', 'payment_type', 'amount', 'status', 'who_is_pay')
                ->where('who_is_pay', '1')
                ->paginate(5);

            return view('admin.payment.index_ajax', compact('paymentdetails'));
        } else {
            return view('admin.payment.index');
        }
    }
    public function agentpaymentindex()
    {
        if (request()->ajax()) {
            $paymentdetails = payment::select('id', 'name', 'location', 'company_name', 'address', 'payment_type', 'amount', 'status', 'who_is_pay', 'agent_code')
                ->where('who_is_pay', '2')
                ->paginate(5);

            return view('admin.agentpayment.index_ajax', compact('paymentdetails'));
        } else {
            return view('admin.agentpayment.index');
        }
    }
    public function settingsindex()
    {
        if (request()->ajax()) {
            $settings = settings::select('id', 'pagename', 'description')->paginate(5);

            return view('admin.settings.index_ajax', compact('settings'));
        } else {
            return view('admin.settings.index');
        }
    }
    public function settingsedit($id)
    {
        $settings = settings::where('id', $id)->first();

        return view('admin.settings.add', compact('settings'));
        exit();
    }
    public function settingseditadmin(Request $request)
    {
        $useraddste = 1;
        $id = request()->get('settingsid');

        $updateStatus = [
            'pagename' => request()->get('pagename'),
            'description' => request()->get('description'),
        ];

        settings::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.settings.index');
        exit();
    }
    public function settingsdelete($id)
    {
        $settings = settings::select('id')->findOrFail($id);

        if ($settings->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['settings deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete users. Please try again.'], '', 500);
        }
    }
    public function canclereasonsindex()
    {
        if (request()->ajax()) {
            $canclereasonsdetails = canclereasons::select('id', 'canclereson')->paginate(5);

            return view('admin.canclereasons.index_ajax', compact('canclereasonsdetails'));
        } else {
            return view('admin.canclereasons.index');
        }
    }
    public function cancleadd()
    {
        return view('admin.canclereasons.add');
    }

    public function canclecreate(Request $request)
    {
        $canclereasonsadd = canclereasons::create([
            'canclereson' => $request->get('canclereason'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);

        return redirect()->route('admin.canclereasons.index');
        exit();
    }
    public function canclereasonsedit($id)
    {
        $canclereasonsdetails = canclereasons::where('id', $id)->first();

        return view('admin.canclereasons.add', compact('canclereasonsdetails'));
        exit();
    }

    public function canclereasonseditadmin(Request $request)
    {
        $id = request()->get('canclereasonid');

        $updateStatus = [
            'canclereson' => $request->get('canclereason'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ];

        canclereasons::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.canclereasons.index');
        exit();
    }
    public function canclereasonsdelete($id)
    {
        $canclereason = canclereasons::select('id')->findOrFail($id);

        if ($canclereason->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['canclereasons deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete users. Please try again.'], '', 500);
        }
    }
    public function tickitsystemsindex()
    {
        if (request()->ajax()) {
            $tickitsystems = tickitsystems::select('id', 'tickit_question', 'tickit_ans', 'u_id')
                ->with('User')
                ->paginate(5);

            return view('admin.tickitsystems.index_ajax', compact('tickitsystems'));
        } else {
            return view('admin.tickitsystems.index');
        }
    }
    public function tickitsystemsedit($id)
    {
        $tickitsystems = tickitsystems::where('id', $id)->first();

        return view('admin.tickitsystems.add', compact('tickitsystems'));
        exit();
    }
    public function tickitsystemseditadmin(Request $request)
    {
        $id = request()->get('tickitid');

        $updateStatus = [
            'tickit_ans' => $request->get('tickit_ans'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ];

        tickitsystems::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.tickitsystems.index');
        exit();
    }
    public function tickitsystemsdelete($id)
    {
        $tickitsystems = tickitsystems::select('id')->findOrFail($id);

        if ($tickitsystems->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['tickit deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete users. Please try again.'], '', 500);
        }
    }
    public function notificationlist()
    {
        if (request()->ajax()) {
            $notificationlist = notificationdetails::select('id', 'myid', 'body', 'name', 'type', 'jobid', 'u_id')
                ->with('User', 'Jobs')
                ->paginate(5);

            return view('admin.notificationlist.index_ajax', compact('notificationlist'));
        } else {
            return view('admin.notificationlist.index');
        }
    }
    public function jobsindex()
    {
        if (request()->ajax()) {
            $jobs = jobs::select('id', 'u_id', 'job_title', 'Job_date', 'Location', 'status')
                ->with('User')
                ->paginate(5);

            return view('admin.jobs.index_ajax', compact('jobs'));
        } else {
            return view('admin.jobs.index');
        }
    }
    public function jobsadd()
    {
        return view('admin.jobs.add');
    }
    public function jobscreate(Request $request)
    {
        $is_closed = '0';
        $imagepath = public_path() . '/Company_logo';
        if ($request->File('Company_logo')) {
            $img_ext = $request->File('Company_logo')->getClientOriginalExtension();
            $filename = 'Company_logo-' . time() . '.' . $img_ext;
            $path = $request->file('Company_logo')->move($imagepath, $filename); //image save public folder
        } else {
            $filename = '';
        }
        $jobsadd = jobs::create([
            'Company_logo' => $filename,
            'u_id' => '1',
            'company_name' => $request->get('company_name'),
            'job_title' => $request->get('job_title'),
            'description' => $request->get('description'),
            'Job_date' => $request->get('Job_date'),
            'job_type' => $request->get('job_type'),
            'Location' => $request->get('Location'),
            'Salary' => $request->get('Salary'),
            'vacancy' => $request->get('vacancy'),
            'is_closed' => $is_closed,
            'Experience' => $request->get('Experience'),
            'description_exp' => $request->get('description_exp'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);

        return redirect()->route('admin.jobs.index');
        exit();
    }
    public function jobsedit($id)
    {
        $jobs = jobs::where('id', $id)->first();

        return view('admin.jobs.add', compact('jobs'));
        exit();
    }
    public function jobseditadmin(Request $request)
    {
        $id = request()->get('jobid');
        $is_closed = '0';
        $imagepath = public_path() . '/Company_logo';
        if ($request->File('Company_logo')) {
            $img_ext = $request->File('Company_logo')->getClientOriginalExtension();
            $filename = 'Company_logo-' . time() . '.' . $img_ext;
            $path = $request->file('Company_logo')->move($imagepath, $filename); //image save public folder
        } else {
            $filename = '';
        }

        $updateStatus = [
            'Company_logo' => $filename,
            'u_id' => '1',
            'company_name' => $request->get('company_name'),
            'job_title' => $request->get('job_title'),
            'description' => $request->get('description'),
            'Job_date' => $request->get('Job_date'),
            'job_type' => $request->get('job_type'),
            'Location' => $request->get('Location'),
            'Salary' => $request->get('Salary'),
            'vacancy' => $request->get('vacancy'),
            'is_closed' => $is_closed,
            'Experience' => $request->get('Experience'),
            'description_exp' => $request->get('description_exp'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ];

        jobs::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.jobs.index');
        exit();
    }
    public function jobsdelete($id)
    {
        $jobs = jobs::select('id')->findOrFail($id);

        if ($jobs->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['jobs deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete users. Please try again.'], '', 500);
        }
    }

    public function categorysindex()
    {
        if (request()->ajax()) {
            $categorys = categorys::select('id', 'name', 'image')->paginate(5);

            return view('admin.categorys.index_ajax', compact('categorys'));
        } else {
            return view('admin.categorys.index');
        }
    }
    public function categorysadd()
    {
        return view('admin.categorys.add');
    }
    public function categoryscreate(Request $request)
    {
        $is_closed = '0';
        $imagepath = public_path() . '/image';
        if ($request->File('image')) {
            $img_ext = $request->File('image')->getClientOriginalExtension();
            $filename = 'image-' . time() . '.' . $img_ext;
            $path = $request->file('image')->move($imagepath, $filename); //image save public folder
        } else {
            $filename = '';
        }
        $jobsadd = categorys::create([
            'image' => $filename,
            'name' => $request->get('name'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);

        return redirect()->route('admin.categorys.index');
        exit();
    }

    public function categorysedit($id)
    {
        $categorys = categorys::where('id', $id)->first();

        return view('admin.categorys.add', compact('categorys'));
        exit();
    }
    public function categoryseditadmin(Request $request)
    {
        $id = request()->get('categoryid');

        $imagepath = public_path() . '/image';
        if ($request->File('image')) {
            $img_ext = $request->File('image')->getClientOriginalExtension();
            $filename = 'image-' . time() . '.' . $img_ext;
            $path = $request->file('image')->move($imagepath, $filename); //image save public folder
            $updateStatus = [
                'image' => $filename,
                'name' => $request->get('name'),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            ];
        } else {
            $updateStatus = [
                'name' => $request->get('name'),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            ];
        }

        categorys::where('id', '=', $id)->update($updateStatus);

        return redirect()->route('admin.categorys.index');
        exit();
    }
    public function categorysdelete($id)
    {
        $categorys = categorys::select('id')->findOrFail($id);

        if ($categorys->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['categorys deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete categorys. Please try again.'], '', 500);
        }
    }
    public function countryindex()
    {
        if (request()->ajax()) {
            $country = country::select('id', 'countryname', 'contry_flag', 'shortname', 'phonecode', 'status')->paginate(5);

            return view('admin.country.index_ajax', compact('country'));
        } else {
            return view('admin.country.index');
        }
    }
    public function countryadd()
    {
        return view('admin.country.add');
    }
    public function countrycreate(Request $request)
    {
        $is_closed = '0';
        $imagepath = public_path() . '/contry_flag';
        if ($request->File('contry_flag')) {
            $img_ext = $request->File('contry_flag')->getClientOriginalExtension();
            $filename = 'contry_flag-' . time() . '.' . $img_ext;
            $path = $request->file('contry_flag')->move($imagepath, $filename); //image save public folder
        } else {
            $filename = '';
        }
        $country = country::create([
            'contry_flag' => $filename,
            'countryname' => $request->get('countryname'),
            'shortname' => $request->get('shortname'),
            'phonecode' => $request->get('phonecode'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);
        return redirect()->route('admin.country.index');
        exit();
    }
    public function countryedit($id)
    {
        $country = country::where('id', $id)->first();

        return view('admin.country.add', compact('country'));
        exit();
    }
    public function countryeditadmin(Request $request)
    {
        $id = request()->get('countryid');
        $imagepath = public_path() . '/contry_flag';
        if ($request->File('contry_flag')) {
            $img_ext = $request->File('contry_flag')->getClientOriginalExtension();
            $filename = 'contry_flag-' . time() . '.' . $img_ext;
            $path = $request->file('contry_flag')->move($imagepath, $filename); //image save public folder
            $updateStatus = [
                'contry_flag' => $filename,
                'countryname' => $request->get('countryname'),
                'shortname' => $request->get('shortname'),
                'phonecode' => $request->get('phonecode'),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            ];
        } else {
            $updateStatus = [
                'countryname' => $request->get('countryname'),
                'shortname' => $request->get('shortname'),
                'phonecode' => $request->get('phonecode'),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            ];
        }
        country::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.country.index');
        exit();
    }
    public function countrydelete($id)
    {
        $country = country::select('id')->findOrFail($id);

        if ($country->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['country deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete categorys. Please try again.'], '', 500);
        }
    }
    public function countryactive($id)
    {
        $Providers = country::find($id);
        if (empty($Providers)) {
            return createResponse(config('httpResponse.NOT_FOUND'), 'Patients does not exist', ['error' => 'Patients does not exist']);
        }
        if ($Providers['status'] == '1') {
            $status = '2';
            $mailpath = public_path();
            $updateStatus = [
                'Status' => $status,
            ];
            $updateData = country::where('id', '=', $id)->update($updateStatus);
            $data = [
                'msg' => 'country Activated Successfully!',
                'status' => 'success',
            ];
        } else {
            $status = '1';
            $updateStatus = [
                'Status' => $status,
            ];
            $updateData = country::where('id', '=', $id)->update($updateStatus);
            // Success Flash msg
            $data = [
                'msg' => 'country Activated Successfully!',
                'status' => 'success',
            ];
        }

        return $data;
    }
    public function statesindex()
    {
        if (request()->ajax()) {
            $states = states::select('id', 'name', 'country_id')
                ->with('country')
                ->paginate(5);

            return view('admin.states.index_ajax', compact('states'));
        } else {
            return view('admin.states.index');
        }
    }
    public function statesadd()
    {
        $country = country::where('status', '!=', '2')->get();

        return view('admin.states.add', compact('country'));
    }
    public function statesedit($id)
    {
        $states = states::where('id', $id)->first();
        $country = country::where('status', '!=', '2')->get();

        return view('admin.states.add', compact('country', 'states'));
        exit();
    }
    public function statescreate(Request $request)
    {
        $states = states::create([
            'status' => '1',
            'name' => $request->get('name'),
            'country_id' => $request->get('country_id'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);
        return redirect()->route('admin.states.index');
        exit();
    }
    public function stateseditadmin(Request $request)
    {
        $id = request()->get('statesid');

        $updateStatus = [
            'status' => '1',
            'name' => $request->get('name'),
            'country_id' => $request->get('country_id'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ];

        states::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.states.index');
        exit();
    }
    public function statesdelete($id)
    {
        $states = states::select('id')->findOrFail($id);

        if ($states->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['states deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete categorys. Please try again.'], '', 500);
        }
    }
    public function citysindex()
    {
        if (request()->ajax()) {
            $citys = citys::select('id', 'name', 'state_id')
                ->with('states')
                ->paginate(5);

            return view('admin.citys.index_ajax', compact('citys'));
        } else {
            return view('admin.citys.index');
        }
    }
    public function citysadd()
    {
        $states = states::where('status', '!=', '2')->get();

        return view('admin.citys.add', compact('states'));
    }
    public function cityscreate(Request $request)
    {
        $states = citys::create([
            'status' => '1',
            'name' => $request->get('name'),
            'state_id' => $request->get('state_id'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);

        return redirect()->route('admin.citys.index');
        exit();
    }
    public function citysdelete($id)
    {
        $citys = citys::select('id')->findOrFail($id);

        if ($citys->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['city deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete citys. Please try again.'], '', 500);
        }
    }
    public function citysedit($id)
    {
        $citys = citys::where('id', $id)->first();
        $states = states::where('status', '!=', '2')->get();

        return view('admin.citys.add', compact('citys', 'states'));
        exit();
    }
    public function cityseditadmin(Request $request)
    {
        $id = request()->get('citysid');

        $updateStatus = [
            'status' => '1',
            'name' => $request->get('name'),
            'state_id' => $request->get('state_id'),
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ];

        citys::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.citys.index');
        exit();
    }
}
