<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\customer;
use App\Models\User;
use App\Models\users;
use App\Models\categorys;
use App\Models\addressdetails;
use App\Models\product;
use App\Models\generalsettings;
use App\Models\promocode;
use App\Models\orderlist;
use App\Models\orderdetail;
use App\Models\productimage;
use App\Models\productpricesuser;
use App\Models\settings;
use App\Models\sliders; 
use App\Models\drivers;
use App\Models\Driver;
use App\Models\Deliveryboy;
use Illuminate\Support\Facades\Crypt;
use Auth;
use JWTAuth;
use Config;
use Tymon\JWTAuth\Exceptions\JWTException;

class Apiv1Controller extends Controller
{
    public $credentials_error = 'Please enter correct credentials.';

    public $values_error = 'Please enter correct values.';
    protected $i_path;
    public function __construct()
    {
        parent::__construct();
        $this->i_path = "https://craszycamel.co/Glossary/public";
        
    }
    public function register(Request $request)
        {

	        $validEmail = User::where(['name' => $request->get('name')])->first();
	        $emailvalidation = User::where(['email' => $request->get('email')])->first();
            if (!empty($emailvalidation)) {
				$response = array('status' => '0','message' => "The email address is already used.");
				return response()->json(compact('response'),201);
			}
			else
			{
                $imagepath=public_path().'/user_image';
                if($request->File('user_image')){
                $img_ext = $request->File('user_image')->getClientOriginalExtension();
                $filename = 'user_image-' . time() . '.' . $img_ext;
                        $path = $request->file('user_image')->move($imagepath, $filename);//image save public folder
                    }else{
                        $filename='';
                    }
	           	 $user = User::create([
                'contact_no' => $request->get('contact_no'),
                'user_image' =>$filename,
               	'name'=> $request->get('name'),
                'name'=> $request->get('name'),
                'device_token' => $request->get('device_token'),
       			'status' => '1',
				'password' => Hash::make($request->get('password')),
				'email'=>$request->get('email'),
                'lastname'=>$request->get('lastname'),
               
				
            	]);

                // $credentials = $request->only('email');
                $token = JWTAuth::fromUser($user);

			     $to = $request->get('email');
                 $subject = "Welcome to Glossary";
                 $message = "Hello ".$request->get('name')." <br/>your accounts created successfully ";
                 $header = "From:mituldabhi18@gmail \r\n";
                 $header .= "Cc:mituldabhi18@gmail \r\n";
                 $header .= "MIME-Version: 1.0\r\n";
                 $header .= "Content-type: text/html\r\n";
               /*  mail ($to,$subject,$message,$header);*/
				 $response = array('status' => '201','message' => "Your Accounts Created SuccessFully.",'token'=>$token,'user'=>$user);
                // $token = JWTAuth::fromUser($user);
                return response()->json(compact('response'),201);
			}

        }
        public function driverregister(Request $request)
        {
	        $emailvalidation = User::where(['email' => $request->get('email')])->where('role','driver')->first();
            if (!empty($emailvalidation)) {
				$response = array('status' => '0','message' => "The email address is already used.");
				return response()->json(compact('response'),201);
			}
			else
			{
                $imagepath=public_path().'/user_image';
                if($request->File('user_image')){
                $img_ext = $request->File('user_image')->getClientOriginalExtension();
                $filename = 'user_image-' . time() . '.' . $img_ext;
                        $path = $request->file('user_image')->move($imagepath, $filename);//image save public folder
                    }else{
                        $filename='';
                    }
	           	 $user = User::create([
                    'contact_no' => $request->get('contact_no'),
                    'user_image' =>$filename,
                    'bod'=> $request->get('bod'),
                    'name'=> $request->get('name'),
                    'device_token' => $request->get('device_token'),
                    'status' => '1',
                    'role' => 'driver',  
                    'password' => Hash::make($request->get('password')),
                    'email'=>$request->get('email'),
                    'lastname'=>$request->get('lastname'),
                   
                    
                    ]);

                // $credentials = $request->only('email');
                $token = JWTAuth::fromUser($user);

			     $to = $request->get('email');
                 $subject = "Welcome to Glossary";
                 $message = "Hello ".$request->get('name')." <br/>your account created successfully ";
                 $header = "From:mituldabhi18@gmail \r\n";
                 $header .= "Cc:mituldabhi18@gmail \r\n";
                 $header .= "MIME-Version: 1.0\r\n";
                 $header .= "Content-type: text/html\r\n";
               /*  mail ($to,$subject,$message,$header);*/
				 $response = array('status' => '201','message' => "Your Account Created Successfully.",'token'=>$token,'driver'=>$user);
                // $token = JWTAuth::fromUser($user);
                return response()->json(compact('response'),201);
			}

        }
    public function login(Request $request)
    {
        $emailiduser=$request->get('email');
        $userstate=User::where('email',$emailiduser)->first();
        
        if(!empty($userstate))
        {
            if($userstate['status']=='1')
            {

               $credentials = $request->only('email', 'password');

               try {
                if (! $token = JWTAuth::attempt($credentials)) {
                    $response = array('status' => '400','message' => "invalid credentials.");

                    return response()->json(compact('response'),400);
                    exit();
                }
            } catch (JWTException $e) {
                $response = array('status' => '400','message' => "could not create token.");
                
                return response()->json(compact('response'), 400);
                exit();
            }
            // $user = User::where('email', request('email'))
            // ->first();
            $updatedevice = array(
             'device_token' => $request->get('device_token')
             );
             User::where('email','=',$emailiduser)->update($updatedevice);

              $getimagepath = $this->i_path;
                $dirpath = $getimagepath . '/user_image/';
               $userstateprofile= User::where('email',$emailiduser)->get();
                
                $profilelist = [];
                foreach ($userstateprofile as $prolist) {
                   
                    if(!empty($prolist['user_image']))
                    {
                        $userimages=$dirpath.$prolist['user_image'];
                    }else{
                       $userimages='';
                   }
                   $prolist['user_image']= $userimages;
                   $profilelist = $prolist;
               }
            $response = array('status' => '201','message' => "login success.",'token'=>$token,'user'=>$profilelist );
            return response()->json(compact('response'),201);
            exit(); 
            
        }
        else
        {
            $response = array('status' => '400','message' => "Your account is deactivated, Please contact admin.");

            return response()->json(compact('response'),400);
            exit();

        }
    }
    else
    {
       $response = array('status' => '400','message' => "User details not found.");
       return response()->json(compact('response'),400);
       exit();
   }    
   
}
public function driverlogin(Request $request)
    {
        $emailiduser=$request->get('email');
       
        $driverstatus=User::where('email',$emailiduser)->first();
        
        if(!empty($driverstatus))
        { 
            
            if($driverstatus['status']=='1')
            {
                
               $credentials = $request->only('email', 'password');
               
            //    try {
                if (! $token = JWTAuth::attempt($credentials)) {
                    $response = array('status' => '400','message' => "invalid credentials.");

                    return response()->json(compact('response'),400);
                    exit();
                    }
                // } catch (JWTException $e) {
                //     $response = array('status' => '400','message' => "could not create token.");
                    
                //     return response()->json(compact('response'), 400);
                //     exit();
                // }
            
                $updatedevice = array(
                    'device_token' => $request->get('device_token')
                    );
                    User::where('email','=',$emailiduser)->update($updatedevice);
       
                     $getimagepath = $this->i_path;
                       $dirpath = $getimagepath . '/user_image/';
                      $userstateprofile= User::where('email',$emailiduser)->get();
                       
                       $profilelist = [];
                       foreach ($userstateprofile as $prolist) {
                          
                           if(!empty($prolist['user_image']))
                           {
                               $userimages=$dirpath.$prolist['user_image'];
                           }else{
                              $userimages='';
                          }
                          $prolist['user_image']= $userimages;
                          $profilelist = $prolist;
                      }
            $response = array('status' => '201','message' => "login success.",'token'=>$token,'driverprofile'=>$profilelist );
            return response()->json(compact('response'),201);
            exit(); 
            
        }
        else
        {
            $response = array('status' => '400','message' => "Your account is deactivated, Please contact admin.");

            return response()->json(compact('response'),400);
            exit();

        }
    }
    else
    {
       $response = array('status' => '400','message' => "User details not found.");
       return response()->json(compact('response'),400);
       exit();
   }    
   
}
public function allproduct(Request $request)
{
    $getimagepath = $this->i_path;
    $image = $getimagepath . '/productimages/';

     $productlist= product::with('categorys')->where('status', '!=', '2')->orderBy('id', 'desc')->get();

    $productdetail = [];
    foreach ($productlist as $product) {

        $productima=productimage::where('p_id',$product['id'])->get();
        
        $productlistimg=[];
        foreach ($productima as $key => $value) {

            if(!empty($value['images']))
            {
                $product_img=$image.$value['images'];
                
            }else{
                $product_img='';
            }

            $value['images']= $product_img;
            $productlistimg[]=$value;
        }
        if(!empty($product['images']))
        {
            $images=$image.$product['images'];
            
        }else{
            $images='';
        }
        $product['images']= $images;
        $product['imagesmore']= $productlistimg;
        $productdetail[] = $product;
    }

    $response = ['status' => '201', 'message' => "Product details.",'Productlist'=>$productdetail];
    return response()->json(compact('response'), 201);
    exit();
}

public function similarproduct(Request $request)
{
    $getimagepath = $this->i_path;
    $image = $getimagepath . '/productimages/';
    
    $product = product::with('categorys')->where('id', $request->get('p_id'))
        ->first();

     $productlist= product::with('categorys')->where('status', '!=', '2')->where('c_id',$request->get('c_id'))
    ->orderBy('id', 'desc')
    ->get();

    $productdetail = [];
    foreach ($productlist as $product) {

        $productima=productimage::where('p_id',$product['id'])->get();
        
        $productlistimg=[];
        foreach ($productima as $key => $value) {

            if(!empty($value['images']))
            {
                $product_img=$image.$value['images'];
                
            }else{
                $product_img='';
            }

            $value['images']= $product_img;
            $productlistimg[]=$value;
        }
        if(!empty($product['images']))
        {
            $images=$image.$product['images'];
            
        }else{
            $images='';
        }
        $product['images']= $images;
        $product['imagesmore']= $productlistimg;
        $productdetail[] = $product;
    }

    
    $response = ['status' => '201', 'message' => "Product similar details.",'Productlist'=>$productdetail];
    return response()->json(compact('response'), 201);
    exit();
}
public function categorywiseproduct(Request $request)
{
    $getimagepath = $this->i_path;
    $image = $getimagepath . '/productimages/';

     $productlist= product::with('categorys')->where('status', '!=', '2')->where('c_id',$request->get('c_id'))
    ->orderBy('id', 'desc')
    ->get();

    $productdetail = [];
    foreach ($productlist as $product) {

        $productima=productimage::where('p_id',$product['id'])->get();
        
        $productlistimg=[];
        foreach ($productima as $key => $value) {

            if(!empty($value['images']))
            {
                $product_img=$image.$value['images'];
                
            }else{
                $product_img='';
            }

            $value['images']= $product_img;
            $productlistimg[]=$value;
        }

        
        

        if(!empty($product['images']))
        {
            $images=$image.$product['images'];
            
        }else{
            $images='';
        }
        $product['images']= $images;
        $product['multiimages']=$productlistimg;
        $productdetail[] = $product;
    }

    
    $response = ['status' => '201', 'message' => " Category wise Product details.",' Category wise Productlist'=>$productdetail];
    return response()->json(compact('response'), 201);
    exit();
}
public function productlist(Request $request)
{

    $jsonReqUrl = "php://input";
    $reqjson = file_get_contents($jsonReqUrl);
    $reqjsonDecode = json_decode($reqjson, true);

    $tokenall = request()->bearerToken();

    if(!empty($tokenall ))
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];
    }

    $sliderslist= sliders::where('status', '!=', '2')
    ->orderBy('id', 'desc')
    ->get();

    $categorylist= categorys::where('status', '!=', '2')
    ->orderBy('id', 'desc')
    ->get();
   
    $productfes= product::with('categorys')->select('id','productname','productdetails','producttype','status','prices','c_id')->where('status', '!=', '2')
    ->where('producttype','1')
    ->orderBy('id', 'desc')
    ->get();

    $productother= product::with('categorys')->select('id','productname','productdetails','producttype','status','prices','c_id')->where('status', '!=', '2')
    ->where('producttype','2')
    ->orderBy('id', 'desc')
    ->get();

    $getimagepath = $this->i_path;
    $dirpath = $getimagepath . '/productimages/';
    $slider_image = $getimagepath . '/slider_image/';
    $image = $getimagepath . '/image/';
    $productlistfe = [];


foreach ($productfes as $profes) {

        $productima=productimage::where('p_id',$profes->id)->get();
        
        $productlistimg=[];
        foreach ($productima as $key => $value) {

            if(!empty($value['images']))
            {
                $product_img=$dirpath.$value['images'];
                
            }else{
                $product_img='';
            }

            $value['images']= $product_img;
            $productlistimg[]=$value;
        }

        
        $profes['images']=$productlistimg;
        if(!empty($tokenall ))
        {
            //$productid=productpricesuser::where('productid',$profes['id'])->where('userid',$userId)->first();
            //$profes['prices']=$productid['productprices'];

              $productid = productpricesuser::where('productid', $profes['id'])->where('userid', $userId)->first();
              $profes['prices'] = !empty($productid) ? $productid['productprices'] : $profes['prices'];

        }else{
            
            $profes['prices']=$profes['prices'];
        }    
        
        $productlistfe[] = $profes;
    }
    
    $productlistother = [];
    foreach ($productother as $proothr) {


        $productima=productimage::where('p_id',$proothr['id'])->get();
        
        $productlistimg=[];
        foreach ($productima as $key => $value) {

            if(!empty($value['images']))
            {
                $product_img=$dirpath.$value['images'];
                
            }else{
                $product_img='';
            }
            $value['images']= $product_img;
            $productlistimg[]=$value;
        }
        

        
        if(!empty($tokenall ))
        {
            //$productid=productpricesuser::where('productid',$proothr['id'])->where('userid',$userId)->first();
            //$proothr['prices']=$productid['productprices'];

            $productid = productpricesuser::where('productid', $proothr['id'])->where('userid', $userId)->first();
            $proothr['prices'] = !empty($productid) ? $productid['productprices'] : $proothr['prices'];
        }else{
            
            $proothr['prices']=$proothr['prices'];
        } 
        
        $proothr['images']=$productlistimg;
        $productlistother[] = $proothr;
    }

    $sliderlistother = [];
    foreach ($sliderslist as $slider) {
        if(!empty($slider['slider_image']))
        {
            $sliderimage=$slider_image.$slider['slider_image'];
            
        }else{
            $sliderimage='';
        }
        $slider['slider_image']= $sliderimage;
        $sliderlistother[] = $slider;
    }
    $categorylisttt = [];
    foreach ($categorylist as $category) {
        if(!empty($category['image']))
        {
            $categoryimg=$image.$category['image'];
            
        }else{
            $categoryimg='';
        }
        $category['image']= $categoryimg;
        $categorylisttt[] = $category;
    }

    $response = ['status' => '201', 'message' => "Product details.", 'futureproduct' => $productlistfe,'otherproduct'=>$productlistother,'sliderlist'=>$sliderlistother,'categorylist'=>$categorylisttt];
    return response()->json(compact('response'), 201);
    exit();
    
}

    

public function getallcategory(Request $request)
{
    $getimagepath = $this->i_path;
    $image = $getimagepath . '/image/';

     $categorylist= categorys::where('status', '!=', '2')
    ->orderBy('id', 'desc')
    ->get();

    $categorylisttt = [];
    foreach ($categorylist as $category) {
        if(!empty($category['image']))
        {
            $categoryimg=$image.$category['image'];
            
        }else{
            $categoryimg='';
        }
        $category['image']= $categoryimg;
        $categorylisttt[] = $category;
    }

    
    $response = ['status' => '201', 'message' => "category details.",'categorylist'=>$categorylisttt];
    return response()->json(compact('response'), 201);
    exit();
}
public function productlistfuture(Request $request)
{
    $jsonReqUrl = "php://input";
    $reqjson = file_get_contents($jsonReqUrl);
    $reqjsonDecode = json_decode($reqjson, true);

    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];

    $productfes= product::with('categorys')->select('id','productname','productdetails','producttype','prices','status','c_id')->where('status', '!=', '2')
    ->where('producttype','1')
    ->orderBy('id', 'desc')
    ->get();

    $getimagepath = $this->i_path;
    $dirpath = $getimagepath . '/productimages/';
    $productlistfe = [];
    foreach ($productfes as $profes) {

        $productima=productimage::where('p_id',$profes['id'])->get();
        
        $productlistimg=[];
        foreach ($productima as $key => $value) {

            if(!empty($value['images']))
            {
                $product_img=$dirpath.$value['images'];
                
            }else{
                $product_img='';
            }
            $value['images']= $product_img;
            $productlistimg[]=$value;
        }
        $profes['images']=$productlistimg;
        //$productid=productpricesuser::where('productid',$profes['id'])->where('userid',$userId)->first();
       // $profes['prices']=$productid['productprices'];    
        $productlistfe[] = $profes;
    }
    
    
    $response = ['status' => '201', 'message' => "Future Product details.", 'futureproduct' => $productlistfe];
    return response()->json(compact('response'), 201);
    exit();
    
}
public function productlistother(Request $request)
{
    $jsonReqUrl = "php://input";
    $reqjson = file_get_contents($jsonReqUrl);
    $reqjsonDecode = json_decode($reqjson, true);

    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];
    
    $productother= product::with('categorys')->select('id','productname','productdetails','prices','producttype','status','c_id')->where('status', '!=', '2')
    ->where('producttype','2')
    ->orderBy('id', 'desc')
    ->get();
    $getimagepath = $this->i_path;
    $dirpath = $getimagepath . '/productimages/';
    
    $productlistother = [];
    foreach ($productother as $proothr) {
       
        
        $productima=productimage::where('p_id',$proothr['id'])->get();
        
        $productlistimg=[];
        foreach ($productima as $key => $value) {

            if(!empty($value['images']))
            {
                $product_img=$dirpath.$value['images'];
                
            }else{
                $product_img='';
            }
            $value['images']= $product_img;
            $productlistimg[]=$value;
        }

        $proothr['images']=$productlistimg;
        $productid=productpricesuser::where('productid',$proothr['id'])->where('userid',$userId)->first();
       if(isset($productid['productprices']))
       {
        $proothr['prices']=$productid['productprices']; 
       }
       
        $productlistother[] = $proothr;
    }
    $response = ['status' => '201', 'message' => "Other Product details.",'otherproduct'=>$productlistother];
    return response()->json(compact('response'), 201);
    exit();
    
}
public function settings(Request $request)
{
    $jsonReqUrl = "php://input";
    $reqjson = file_get_contents($jsonReqUrl);
    $reqjsonDecode = json_decode($reqjson, true);

    $select = settings::where('pagename', $request->get('pagename'))
    ->orderBy('id', 'DESC')
    ->first();

    if (!empty($select)) {
        $response = ['status' => '201', 'message' => "trems and privecy  .", 'pagedata' => $select];
        return response()->json(compact('response'), 201);
    } else {
        $response = ['status' => '400', 'message' => "Page not found."];
        return response()->json(compact('response'), 201);
    }
}
public function getprofile(Request $request)
{

   $token = JWTAuth::getToken();
   $apy = JWTAuth::getPayload($token)->toArray();
   $userId = $apy['sub'];
   
   
   $profile = User::select('id', 'name','lastname', 'email', 'contact_no','user_image')
   ->orderBy('id', 'DESC')->where('id', $userId)->get();

   if (count($profile) > 0) {
    $getimagepath = $this->i_path;
    $dirpath = $getimagepath . '/user_image/';

    
    $profilelist = [];
    foreach ($profile as $prolist) {
       
        if(!empty($prolist['user_image']))
        {
            $userimages=$dirpath.$prolist['user_image'];
        }else{
           $userimages='';
       }
       $prolist['user_image']= $userimages;
       $profilelist = $prolist;
   }
   $response = ['status' => '201', 'message' => "profile  details.", 'profilelist' => $profilelist];
   return response()->json(compact('response'), 201);
   exit();
}
else {
    $response['status'] = '400';
    $response['message'] = 'profile details not exist';
    return response()->json(compact('response'), 400);
    exit();
}
}
public function getdriverprofile(Request $request)
{

   $token = JWTAuth::getToken();
   $apy = JWTAuth::getPayload($token)->toArray();
   $userId = $apy['sub'];
   
   
   $profile = User::select('id', 'name','lastname', 'email','bod', 'contact_no','user_image')
   ->orderBy('id', 'DESC')->where('id', $userId)->get();

   if (count($profile) > 0) {
    $getimagepath = $this->i_path;
    $dirpath = $getimagepath . '/user_image/';

    
    $profilelist = [];
    foreach ($profile as $prolist) {
       
        if(!empty($prolist['user_image']))
        {
            $userimages=$dirpath.$prolist['user_image'];
        }else{
           $userimages='';
       }
       $prolist['user_image']= $userimages;
       $profilelist = $prolist;
   }
   $response = ['status' => '201', 'message' => "profile  details.", 'profilelist' => $profilelist];
   return response()->json(compact('response'), 201);
   exit();
}
else {
    $response['status'] = '400';
    $response['message'] = 'profile details not exist';
    return response()->json(compact('response'), 400);
    exit();
}
}
public function editprofile(Request $request)
{
    
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];
    
    $userExist = User::where('id', $userId)->first();

    if (!empty($userExist)) {
     
        if ($request->hasFile('image')) {
            $imagepath = public_path() . '/user_image';
        }
        if ($request->File('image'))
        {
            $img_ext = $request->File('image')->getClientOriginalExtension();
            $filename = 'product-' . time() . '.' . $img_ext;
                $path = $request->file('image')->move($imagepath, $filename); //image save public folder
                $updatedPersonalData = [
                    'name' => $request->input('name'),
                    'user_image'=>$filename,
                    'lastname' => $request->input('lastname'),
                    'contact_no' => $request->input('contact_no'),
                    'updated_at' => date("Y-m-d H:i:s"),
                ];

                $userExist->where('id', '=', $userId)->update($updatedPersonalData);

            }else{

                $updatedPersonalData = [
                    'name' => $request->input('name'),
                    'lastname' => $request->input('lastname'),
                    'contact_no' => $request->input('contact_no'),
                    'updated_at' => date("Y-m-d H:i:s"),
                ];

                $userExist->where('id', '=', $userId)->update($updatedPersonalData);
            }
            $userget = User::select('name')
            ->where('id',$userId)
            ->orderBy('id', 'DESC')
            ->get();

            $response = ['status' => '201', 'message' => "User profile updated successfully."];

            return response()->json(compact('response'), 201);
            exit();
        } else {
            $response = ['status' => '400', 'message' => "User does not exist."];

            return response()->json(compact('response'), 400);
            exit();
        }
    }
    public function editdriverprofile(Request $request)
{
    
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];
    
    $userExist = User::where('id', $userId)->first();

    if (!empty($userExist)) {
     
        if ($request->hasFile('user_image')) {
            $imagepath = public_path() . '/user_image';
        }
        if ($request->File('user_image'))
        {
            $img_ext = $request->File('user_image')->getClientOriginalExtension();
            $filename = 'user_image-' . time() . '.' . $img_ext;
                $path = $request->file('user_image')->move($imagepath, $filename); //image save public folder
                $updatedPersonalData = [
                    'name' => $request->input('name'),
                    'user_image'=>$filename,
                    'lastname' => $request->input('lastname'),
                    'contact_no' => $request->input('contact_no'), 
                    'bod' => $request->input('bod'),
                    'updated_at' => date("Y-m-d H:i:s"),
                ];

                $userExist->where('id', '=', $userId)->update($updatedPersonalData);

            }else{

                $updatedPersonalData = [
                    'name' => $request->input('name'),
                    'bod' => $request->input('bod'),
                    'lastname' => $request->input('lastname'),
                    'contact_no' => $request->input('contact_no'),
                    'updated_at' => date("Y-m-d H:i:s"),
                ];

                $userExist->where('id', '=', $userId)->update($updatedPersonalData);
            }
            $userget = User::select('name')
            ->where('id',$userId)
            ->orderBy('id', 'DESC')
            ->get();

            $response = ['status' => '201', 'message' => "User profile updated successfully."];

            return response()->json(compact('response'), 201);
            exit();
        } else {
            $response = ['status' => '400', 'message' => "User does not exist."];

            return response()->json(compact('response'), 400);
            exit();
        }
    
}
    public function logout(Request $request)
    {
       $token = JWTAuth::getToken();
       $apy = JWTAuth::getPayload($token)->toArray();
       $userId = $apy['sub'];
       $userExist = User::where(['id' => $userId])->first();

       if (!$userExist) {
           $response = ['status' => '400', 'message' => "Token mismatch or expired, please try again."];
           return response()->json(compact('response'), 400);
           exit();
       } else {
           $userUpdate = [
               'updated_at' => date("Y-m-d H:i:s"),
           ];
           User::where('id', $userId)->update($userUpdate);

           $response = ['status' => '201', 'message' => "Logout   successfully.."];
           return response()->json(compact('response'), 201);
           exit();
       }
   } 
   public function placeOrder(Request $request)
   {
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub']; 
    $ordernumber=rand();

    $orderadd = orderlist::create([
        'orderid' => $ordernumber,
        'status' => '1',
        'c_id'=>$userId,
        'address_id'=>$request->input('address_id'),
        'totalamount'=>$request->input('totalamount'),
        'ordertax'=>$request->input('ordertax'),
        'payment_method'=>$request->input('payment_method'),
        'price_before_tax'=>$request->input('price_before_tax'),
        'discount'=>$request->input('discount'),
        
        'orderdate'=>date("Y-m-d"),
        'created_at' => date("Y-m-d H:i:s"),
        'updated_at' => date("Y-m-d H:i:s"),
    ]);

    $orderidd=$orderadd->id;   

    $myArray = json_decode($request->input('line_items'), true); 
    
    foreach ($myArray as $key => $value)
    {
       $user = orderdetail::create([
           'quantity' => $value['quantity'],
           'p_id' => $value['product_id'],
           'orderprices' => $value['product_price'],
           'or_id' =>$orderidd,
       ]);
   }
   $response = ['status' => '201', 'message' => "Place order successfully.."];
   return response()->json(compact('response'), 201);
   exit();  

}
 public function userdetaillist(Request $request)
   {
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];

     $addaddress = addressdetails::create([
        
        'u_id'=>$userId,
        'address1'=>$request->get('address1'),
        'address2'=>$request->get('address2'),
        'status'=> '1',
        'city'=>$request->get('city'),
        'created_at' => date("Y-m-d H:i:s"),
        'updated_at' => date("Y-m-d H:i:s"),
    ]);
 
    
   $response = ['status' => '201', 'message' => "Address add successfully.."];
   return response()->json(compact('response'), 201);
   exit();  

}

/* public function addaddress(Request $request)
   {
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];

     $addaddress = addressdetails::create([
        
        'u_id'=>$userId,
        'address1'=>$request->get('address1'),
        'address2'=>$request->get('address2'),
        'status'=> '1',
        'city'=>$request->get('city'),
        'latitude'=>$request->get('latitude'),
        'longitude'=>$request->get('longitude'),
        'created_at' => date("Y-m-d H:i:s"),
        'updated_at' => date("Y-m-d H:i:s"),
    ]);
 
    
   $response = ['status' => '201', 'message' => "Address add successfully.."];
   return response()->json(compact('response'), 201);
   exit();  

} */

public function addaddress(Request $request)
{
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];

    $addaddress = addressdetails::create([
        'u_id' => $userId,
        'address1' => $request->get('address1'),
        'address2' => $request->get('address2'),
        'status' => '1',
        'city' => $request->get('city'),
        'latitude' => $request->get('latitude'), 
        'longitude' => $request->get('longitude'), 
        'created_at' => now(), 
        'updated_at' => now(), 
    ]);

    $response = ['status' => '201', 'message' => "Address added successfully."];
    return response()->json(compact('response'), 201);
}
public function alladdress(Request $request)
{
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];
    $alladdress=addressdetails::where('u_id',$userId)->get();
    $response = ['status' => '201', 'message' => "All Address successfully.",'Alladdress'=>$alladdress];
   return response()->json(compact('response'), 201);
   exit();  
}

public function deleteaddress(Request $request)
{
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];
    $id=$request->get('addressid');
    addressdetails::where('id',$id)->delete();
    $response = ['status' => '201', 'message' => "Delete Address successfully."];
   return response()->json(compact('response'), 201);
   exit();  
}


/* public function editaddress(Request $request)
{
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];
    $id=$request->get('addressid');
    $updateaddress = array(
            'address1'=>$request->get('address1'),
            'address2'=>$request->get('address2'),
            'city'=>$request->get('city'),
            'latitude'=>$request->get('latitude'),
            'longitude'=>$request->get('longitude'),
            'updated_at' => date("Y-m-d H:i:s")
        );
        $updateData= addressdetails::where('id','=',$id)->update($updateaddress);

    $response = ['status' => '201', 'message' => "Address Update successfully.."];
   return response()->json(compact('response'), 201);
   exit();  
} */

public function editaddress(Request $request)
{
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub'];
    $id = $request->get('addressid');
    
    $updateaddress = [
        'address1' => $request->get('address1'),
        'address2' => $request->get('address2'),
        'city' => $request->get('city'),
        'latitude' => $request->get('latitude'),
        'longitude' => $request->get('longitude'),
        'updated_at' => now() 
    ];

    $updateData = addressdetails::where('id', $id)->update($updateaddress);

    $response = ['status' => '201', 'message' => "Address updated successfully."];
    return response()->json(compact('response'), 201);
}


public function getOrder(Request $request)
{
    $token = JWTAuth::getToken();
    $apy = JWTAuth::getPayload($token)->toArray();
    $userId = $apy['sub']; 
    
    $getorder=orderlist::where('c_id',$userId)->get()->count();
    if($getorder>0)
    {
        $getorders=orderlist::with('addresslist')->where('c_id',$userId)->get();
        $orderdetailslist=[];
        $orderdeproduct=[];
        
        $getimagepath = $this->i_path;
        $dirpath = $getimagepath . '/productimages/';

        foreach ($getorders as $key => $value) {
            $search = $value['id'];
                /*$data123 = \DB::table("orderdetails")
                        ->select("orderdetails.*")
                        ->whereRaw("find_in_set('" . $search . "',orderdetails.or_id)")
                        ->get();*/
                        $data123 = orderdetail::leftJoin('product', 'product.id', '=', 'orderdetails.p_id')->where('or_id',$search)->get();
                        $productdel=[]; 
                        foreach ($data123 as $key => $productdetails) {
                           
                           $productima=productimage::where('p_id',$productdetails->p_id)->get();
                           
                           $productlistimg=[];
                           foreach ($productima as $key => $valueimages) {

                            if(!empty($valueimages['images']))
                            {
                                $product_img=$dirpath.$valueimages['images'];
                                
                            }else{
                                $product_img='';
                            }

                            $valueimages['images']= $product_img;
                            $productlistimg[]=$valueimages;
                        }
                        $productdetails->images=$productlistimg;
                        $categorydetails=categorys::where('id',$productdetails->c_id)->get();
                      /*if(!empty($productdetails->images))
                        {
                            $userimages=$dirpath.$productdetails->images;
                        }else
                        {
                            $userimages=$dirpath.'noimages.jfif';
                        }*/
                        $productdetails->categorydetails= $categorydetails;
                        $productdel[]=$productdetails;

                    }
                    if($value['status']=='1')
                    {
                        $statusde='Ordered'; 
                    }elseif($value['status']=='2'){
                        $statusde='Confirmed';
                    }elseif($value['status']=='3'){
                        $statusde='Packed';
                    }elseif($value['status']=='4'){
                        $statusde='Driver Assigned';
                    }elseif($value['status']=='5'){
                        $statusde='Driver Accepted';
                    }
                    elseif($value['status']=='6'){
                        $statusde='Driver Rejected';
                    }
                    elseif($value['status']=='7'){
                        $statusde='Out for Delivery';
                    }elseif($value['status']=='8'){
                        $statusde='Delivered';
                    }elseif($value['status']=='9'){
                        $statusde='Cancel ';
                    }
                    $value['productdetails'] = $productdel;
                    $value['status'] = $statusde;
                    $orderdetailslist[] = $value;      

                }
                
                $response = ['status' => '201', 'message' => "Get order details.",'orderdetails'=>$orderdetailslist];
                return response()->json(compact('response'), 201);
                exit();
            }else{
             $response = ['status' => '400', 'message' => "Order details not found.",'orderdetails'=>[]];
             return response()->json(compact('response'), 400);
             exit(); 
         }

     }
     public function userdeleterequest(Request $request)
     {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub']; 

        $id=$userId;
        $User = User::find($id);
        
        if(empty($User)) {
            return createResponse(config('httpResponse.NOT_FOUND'), 
                'user does not exist',
                ['error' => 'User does not exist' ]);
        }
        $updateStatus = array(
            'status' => '2',
            'updated_at' => date("Y-m-d H:i:s")
        );
        $updateData= $User->where('id','=',$id)->update($updateStatus);

        $username=$User['name'].' '.$User['lastname'];
        $to = $User['email'];
        $subject = "Silsa App : Delete Account request  ";
        $message = "Hello ".$username." <br/><br/>Thanks for being part of the Silsa App. As requested, your account has been successfully deactivated for 9 days and it will be deleted in 10 days.  
        .<br/><br/> Did you expect something different, or was it missing something you needed? Your feedback helps us improve, so it would be great to hear from you! <br/><br/>Thank you, <br/><br/>
        The Silsa team ";
        $header = "From:info@iappstack.com \r\n";
        $header .= "Cc:info@iappstack.com \r\n";
        $header .= "MIME-Version: 1.0\r\n";
        $header .= "Content-type: text/html\r\n";
        mail ($to,$subject,$message,$header);
        
        $response = ['status' => '201', 'message' => "Your account will be delete after 3 hours from now!."];
        return response()->json(compact('response'), 201);
        exit();   
    }

    /*public function Generalsettings(Request $request)
    {
        $packname=$request->get('packname');
        $Generalsettings=generalsettings::where('packname',$packname)->first();
        $response = ['status' => '201', 'message' => "General settings list","Generalsetting"=>$Generalsettings];
        return response()->json(compact('response'), 201);
        exit();
        
    } */

   public function Generalsettings(Request $request)
{
    $packname = $request->get('packname');
    $Generalsettings = generalsettings::where('packname', $packname)->first();
    
    if ($Generalsettings && $Generalsettings->tax === null) {
        $Generalsettings->tax = "0";
    }
    
    $response = [
        'status' => '201',
        'message' => "General settings list",
        'Generalsetting' => $Generalsettings
    ];
    
    return response()->json(compact('response'), 201);
}



    public function promocodediscount(Request $request)
    { 
        //print_r($bill_ammount);
        //exit();
        $promocode=$request->get('promocode');
        $bill_ammount=$request->get('bill_ammount');
        $p_id=$request->get('p_id');
        $Promocodeget=promocode::where('promocode',$promocode)->get();

        if(count($Promocodeget)>0)
        {
               //$productdetails=product::where('id',$p_id)->first();
               $productdiscount=(int)$bill_ammount*(int)$Promocodeget[0]['promocodediscount']/100;
               $response = ['status' => '201', 'message' => "promocode discount","promocode"=>$productdiscount];
               return response()->json(compact('response'), 201);
               exit();
               
        }else{
            $response = ['status' => '400', 'message' => "This promocode not used "];
            return response()->json(compact('response'), 201);
            exit();

        }

    }

    public function orderstatus(Request $request)
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub']; 
        $orderid=$request->get('orderid');
        $getorder=orderlist::where('orderid',$orderid)->first();
         
       $statusde = '';

    if (isset($getorder) && $getorder->status == '1') {
        $statusde = 'Ordered'; 
    } elseif ($getorder && $getorder->status == '2') {
        $statusde = 'Confirmed';
    } elseif ($getorder && $getorder->status == '3') {
        $statusde = 'Packed';
    } elseif ($getorder && $getorder->status == '4') {
        $statusde = 'Driver Assigned';
    } elseif ($getorder && $getorder->status == '5') {
        $statusde = 'Driver Accepted';
    }
    elseif ($getorder && $getorder->status == '6') {
        $statusde = 'Driver Rejected';
    }
    elseif ($getorder && $getorder->status == '7') {
        $statusde = 'Out for Delivery';
    }
    elseif ($getorder && $getorder->status == '8') {
        $statusde = 'Delivered';
    }elseif ($getorder && $getorder->status == '9') {
        $statusde = 'Cancel';
    }

        $response = ['status' => '201', 'message' => "order status details","status"=>$statusde];
        return response()->json(compact('response'), 201);
        exit();

    }
    public function checkemail(Request $request)
    {


        $emailiduser=$request->get('email');
        $userstate=users::where('email',$emailiduser)->first();
        
        if(!empty($userstate))
        {
                $user = users::where('email', request('email'))
                ->first();

                $updatedevice = array(
                 'device_token' => $request->get('device_token')
                 );
                 User::where('email','=',request('email'))->update($updatedevice);

                 $userstateprofile = users::where('email', request('email'))
                ->GET();
                $getimagepath = $this->i_path;
                $dirpath = $getimagepath . '/user_image/';
                 $profilelist = [];
                foreach ($userstateprofile as $prolist) {
                   
                    if(!empty($prolist['user_image']))
                    {
                        $userimages=$dirpath.$prolist['user_image'];
                    }else{
                       $userimages='';
                   }
                   $prolist['user_image']= $userimages;
                   $profilelist = $prolist;
               }
                $token = JWTAuth::fromUser($user);
                $response = array('status' => '201','message' => "login success.",'token'=>$token,'user'=>$profilelist);
                return response()->json(compact('response'),201);
                exit(); 
            
        }else{
                 $response = array('status' => '400','message' => "Email id not found.");
                 return response()->json(compact('response'),201);
                exit();
            }
            
    }
    public function registerdriver(Request $request)
    {
        try {
            // Extract JSON data from the request body
            $jsonData = json_decode($request->getContent(), true);

            // Validate incoming request data
            $validatedData = Validator::make($request->all(), [
                'email' => 'required|email|unique:deliveryboys,email',
                'phone' => 'unique:deliveryboys,phone',
            ])->validate();
            
            // Create a new user
            $user = Deliveryboy::create([
                'name' => $request->input('name'),
                'email' => $validatedData['email'],
                'password' => Hash::make($request->input('password')),
                'phone' => $request->input('phone'),
                'dob' => $request->input('dob'),
                'complete_order' => $request->input('completeorder'),
                'status' => 1,
            ]);
            // Generate JWT token for authentication
            $token = JWTAuth::fromUser($user);

            $datauser = [
                "driver_id" => $user->id,
                "email" => $user->email,
                "name" => $user->name,
                "phone" => $user->phone,
                "dob" => $user->dob,
                "completeOrder" => $user->complete_order,
                "status" => $user->status,
                "auth_token" => $token,
            ];

            // Return success response
            $result = ['rstatus' => 1, 'messages' => 'ok', 'errorcode' => ''];
            $response = ['result' => $result, 'data' => $datauser];
            return $response;

         } catch (\Illuminate\Validation\ValidationException $e) {
            // Validation failed, get the specific error messages for "email" and "mobile_number" fields
            $emailErrorMessage = $e->errors()['email'][0] ?? '';
            $mobileNumberErrorMessage = $e->errors()['number'][0] ?? '';

            // Combine the error messages for email and mobile number into one message
            if (!empty($emailErrorMessage) && !empty($mobileNumberErrorMessage)) {
                // Both email and mobile number are already used
                $combinedErrorMessage = 'Email and phone number are already in use.';
            } elseif (!empty($emailErrorMessage)) {
                // Only email is already used
                $combinedErrorMessage = 'Email is already in use.';
            } else {
                // Only mobile number is already used
                $combinedErrorMessage = 'Phone number is already in use.';
            }

            // Prepare error response with combined error message
            $result1 = [
                'rstatus' => 0,
                'messages' => $combinedErrorMessage,
                'errorcode' => 422
            ];

            $response = ['result' => $result1, 'data' => null];
            return $response;
        } catch (\Exception $e) {
            // Other exceptions, return registration failed message
            $result1 = ['rstatus' => 0, 'messages' => 'Registration failed', 'errorcode' => 500];
            $response = ['result' => $result1, 'data' => []];
            return $response;

        } catch (\Exception $e) {
            // Other exceptions, return registration failed message
            $result1 = ['rstatus' => 0, 'messages' => 'Registration failed', 'errorcode' => 500];
            $response = ['result' => $result1, 'data' => []];
            return $response;
        }
    }
    public function logindriver(Request $request)
    {
        try {
            $jsonData = json_decode($request->getContent(), true);

            // Retrieve the user by email
            $user = Deliveryboy::where('email', $request->input('email'))->first();

        if($user->status != 2)
        {

            if ($user && Hash::check($request->input('password'), $user->password)) {
                // Password matches
                // Generate JWT token for authentication
                $token = JWTAuth::fromUser($user);

                $datauser = [
                    "driver_id" => $user->id,
                    "email" => $user->email,
                    "name" => $user->name,
                    "phone" => $user->phone,
                    "dob" => $user->dob,
                    "status" => $user->status,
                    "completeOrder" => $user->complete_order,
                    "auth_token" => $token,
                ];


                $result = ['rstatus' => 1, 'messages' => 'login success', 'errorcode' => ''];
                $response = ['result' => $result, 'data' => $datauser];
                return $response;
            } else {
                // Password does not match or user not found
                $result = ['rstatus' => 0, 'messages' => 'Invalid credentials', 'errorcode' => ''];
                $response = ['result' => $result];
                return $response;
            }
            } else {

            $result = ['status' => false, 'messages' => 'your driver is inactive, you have to active first!'];
            $result1 = ['rstatus' => 0, 'messages' => 'ok', 'errorcode' => 401];
            $response = ['result' => $result1, 'data' => $result];
            return $response;
        }
        } catch (\Exception $e) {
            // Handle other exceptions
            $result = ['rstatus' => 0, 'messages' => 'Authentication failed', 'errorcode' => 500];
            $response = ['result' => $result];
            return $response;
        }
    }
    public function getdriver(Request $request)
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];

        $user = Deliveryboy::where('id',$userId)->first();
        
        if(!empty($user))
        {
            $result1 = ['rstatus' => 1, 'message' => 'ok', 'errorcode' => ''];
            
            $response1= [
                    'driver_id'=> $user->id,
                    'Name' => $user->name,
                    'Phone' => $user->phone,
                    'Email' => $user->email,
                    'is_online' => $user->is_online,
                    'Address' => $user->address,
                    'AadharNumber' => $user->aadharnumber,
                    'VehicleType' => $user->vehicle_type,
                    'Vehicle_No' => $user->vehicle_no,
                    'Licence' => $user->licence,
                    "Status" =>  $user->status,
                    "Dob" => $user->dob,
                ];
            $response = ['result' => $result1, 'data' => $response1];
            return $response;
        } else {
            $result = ['status' => false, 'messages' => 'Driver Not Found'];
            $result1 = ['rstatus' => 0, 'messages' => 'ok', 'errorcode' => 401];
            $response = ['result' => $result1, 'data' => $result];
            return $response;
        }
        
    }
    public function editdriver(Request $request)
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];

        $user = Deliveryboy::where('id',$userId)->first();

        if(!empty($user))
        {   
            $user->name = $request->input('name');
            $user->email = $request->input('email');
            $user->phone = $request->input('phone');
            $user->dob = $request->input('dob');
            $user->is_online = $request->get('is_online');
            $user->address = $request->get('address');
            $user->aadharnumber = $request->get('aadharnumber');
            $user->vehicle_type = $request->get('vehicle_type');
            $user->vehicle_no = $request->get('vehicle_no');
            $user->licence = $request->get('licence');
            
            $user->save();
            $response1 = [
                    "driver_id"=>$user->id,
                    'name' => $user->name,
                    'email' => $user->email,
                    'phone' => $user->phone,
                    "status" =>  $user->status,
                    'dob'=> $user->dob,
                    'is_online' => $user->is_online,
                    'address' => $user->address,
                    'aadharnumber' => $user->aadharnumber,
                    'vehicle_type' => $user->vehicle_type,
                    'vehicle_no' => $user->vehicle_no,
                    'licence' => $user->licence,
                ];

            $result1 = ['rstatus' => 1, 'message' => 'Driver profile updated successfully', 'errorcode' => ''];
            $response = ['result' => $result1, 'data' => $response1];

            return $response;
        } else {
            $result = ['status' => false, 'messages' => 'Driver not found'];
            $result1 = ['rstatus' => 0, 'messages' => 'ok', 'errorcode' => 401];
            $response = ['result' => $result1, 'data' => $result];
            return $response;
        }
    }
    public function logoutdriver(Request $request)
	{
	    $token = JWTAuth::getToken();
	    $apy = JWTAuth::getPayload($token)->toArray();
	    $userId = $apy['sub'];

	    $userExist = Deliveryboy::where(['id' => $userId])->first();

	    if(!$userExist)
	    {
            $result = ['status' => false, 'messages' => 'Token mismatch or expired, please try again.'];
            $result1 = ['rstatus' => 0, 'messages' => 'ok', 'errorcode' => 401];
            $response = ['result' => $result1, 'data' => $result];
            return $response;
	    
        } else {
	        $token = JWTAuth::refresh($token);
            $userUpdate = array(
			'updated_at' => date("Y-m-d H:i:s"));

            Deliveryboy::where('id', $userId)->update($userUpdate);

            $result1 = ['message' => 'ok', 'rstatus' => 1, 'errorcode' => ''];
            $response = ['result' => $result1, 'messages' => 'Logout Successfully!'];
            return $response;    
	    } 
    }
    public function forgotPassword(Request $request)
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];
        
        $email = $request->input('email');
        $users = Deliveryboy::where('email', $email)->first();

        if (!empty($users)) {
            $resetCode = sprintf('%04d', mt_rand(0, 9999));

        $users->code = $resetCode;
        $users->save();
        $to = $request->get('email');
    
        $subject = 'Verification Code';

        $message = "Your verification code is: $resetCode";

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        $headers .= 'From: <webmaster@example.com>' . "\r\n";
        $headers .= 'Cc: myboss@example.com' . "\r\n";
        $sendmail = mail($to,$subject,$message,$headers);
        
        $result = ['rstatus' => 1, 'message' => 'Forgot Password Code sent successfully.', 'errorcode' => ''];
        $response = ['result' => $result];

        return $response;
    } else {
        $result = ['status' => false, 'message' => 'Invalid email or user not found'];
        $result1 = ['rstatus' => 0, 'message' => 'ok', 'errorcode' => 404];
        $response = ['result' => $result1, 'data' => $result];

        return $response;
    }

    } 
    public function verify_account(Request $request)
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];

        $email = $request->input('email');
        $code = $request->input('code');

        $user = Deliveryboy::where('id', $userId)->where('email', $email)->where('code', $code)->first();

        if (!empty($user)) {

            $result = ['rstatus' => 1, 'message' => 'Account verification successful.', 'errorcode' => ''];
            $response = ['result' => $result];

            return $response;
        } else {
            $result = ['status' => false, 'message' => 'Invalid verification code or email', 'errorcode' => 404];
            $result1 = ['rstatus' => 0, 'message' => 'ok', 'errorcode' => 404];
            $response = ['result' => $result];

            return $response;
        }
    }   
    public function changePassword(Request $request)
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];

        $oldPassword = $request->input('old_password');
        $newPassword = $request->input('new_password');
        $confirmPassword = $request->input('confirm_password');

        // Check if new password matches the confirm password
        if ($newPassword != $confirmPassword) {
            $response = ['rstatus' => '0', 'message' => "New password and confirm password do not match.", 'errorcode' => "400"];
            return response()->json(compact('response'), 400);
        }

        $userExist = Deliveryboy::find($userId);
        
        if (!$userExist) {	
            $response = ['rstatus' => '0', 'message' => "Driver does not exist.", 'errorcode' => "400"];
            return response()->json(compact('response'), 400);
        }

        if (!\Hash::check($oldPassword, $userExist->password)) {
            $response = ['rstatus' => '0', 'message' => "The old password you have entered is incorrect.", 'errorcode' => "400"];
            return response()->json(compact('response'), 400);
        }

        $updateData = ['password' => \Hash::make($newPassword)];
        $userExist->update($updateData);

        $response = ['rstatus' => '1', 'message' => "Password updated successfully. Please verify with Re-login.", 'errorcode' => ""];
        return response()->json(compact('response'), 201);
    } 

      public function getOrderdriver(Request $request)
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];

        $orderlist = orderlist::where('assignorder',$userId)->get();
        $order = orderlist::where('id', $id)->get();
        $response_data = [];
            foreach ($orderlist as $orderlists) {
        // $addressdetails= addressdetails::where('id',$orderlists->address_id)->first();
        // $user = User::where('id',$addressdetails->u_id)->first();
                $response_data[] = [
                    'id' => $orderlists->id,
                    'c_id' => $orderlists->c_id,
                    'orderid' => $orderlists->orderid,
                    'orderdate' => $orderlists->orderdate,
                    'totalamount' => $orderlists->totalamount,
                    'delivereddate' => $orderlists->delivereddate,
                    'ordertax' => $orderlists->ordertax,
                    'payment_method' => $orderlists->payment_method,
                    'price_before_tax' => $orderlists->price_before_tax,
                    'discount' => $orderlists->discount,
                    // "Address" => $addressdetails->address1 . $addressdetails->address2 . $addressdetails->city,
                
                ];
            }

        if (!empty($orderlist)) {

            $result = ['rstatus' => 1, 'message' => 'ok', 'errorcode' => ''];
            $response = ['result' => $result, 'data' => $response_data];

            return $response;
        } else {
            $result = ['status' => false, 'message' => 'order not found!'];
            $result1 = ['rstatus' => 0, 'message' => 'ok', 'errorcode' => 404];
            $response = ['result' => $result1];

            return $response;
        }
    } 

    public function orderstatusChange(Request $request)
    { 
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];

        $status = $request->get('status');

        if($status == 'Ordered'){
            $statusde='1'; 
        }elseif($status=='Confirmed'){
            $statusde='2';
        }elseif($status=='Packed'){
            $statusde='3';
        }elseif($status=='Driver Assigned'){
            $statusde='4';
        }elseif($status=='Driver Accepted'){
            $statusde='5';
        }elseif($status=='Driver Rejected'){
            $statusde='6';
        }elseif($status=='Out for Delivery'){
            $statusde='7';
        }elseif($status=='Delivered'){
            $statusde='8';
        }elseif($status=='Cancel'){
            $statusde='9';
        }

        $orderlist = orderlist::where('assignorder',$userId)->first();

        if (!empty($orderlist)){

            $orderlist->status = $statusde;
            $orderlist->save();

            $result = ['rstatus' => 1, 'message' => 'status changed successfully', 'errorcode' => ''];
            $response = ['result' => $result];

            return $response;
        } else {
            $result = ['status' => false, 'message' => 'order not found'];
            $result1 = ['rstatus' => 0, 'message' => 'ok', 'errorcode' => 404];
            $response = ['result' => $result1];

            return $response;
        }
    }
    // public function orderhistory(Request $request)
    // { 
    //     $token = JWTAuth::getToken();
    //     $apy = JWTAuth::getPayload($token)->toArray();
    //     $userId = $apy['sub'];

    //     $orderlist = orderlist::where('assignorder',$userId)->get();
                                                        
    //     $response_data = [];
    //     foreach ($orderlist as $orderlists) {
    //     $addressdetails= addressdetails::where('id',$orderlists->address_id)->first();
    //     $orderdetail = orderdetail::where('or_id',$orderlists->id)->first();
    //     $product = product::where('id',$orderdetail->p_id)->first();
    //     $productimage = productimage::where('id',$orderdetail->p_id)->first();

    //     if($orderlists->status == '1'){
    //         $statusde='Ordered'; 
    //     }elseif($orderlists->status=='2'){
    //         $statusde='Confirmed';
    //     }elseif($orderlists->status=='3'){
    //         $statusde='Packed';
    //     }elseif($orderlists->status=='4'){
    //         $statusde='Driver Assigned';
    //     }elseif($orderlists->status=='5'){
    //         $statusde='Driver Accepted';
    //     }elseif($orderlists->status=='6'){
    //         $statusde='Driver Rejected';
    //     }elseif($orderlists->status=='7'){
    //         $statusde='Out for Delivery';
    //     }elseif($orderlists->status=='8'){
    //         $statusde='Delivered';
    //     }elseif($orderlists->status=='9'){
    //         $statusde='Cancel';
    //     }
        
    //         $response_data[] = [
    //             'id' => $orderlists->id,
    //             'orderid' => $orderlists->orderid,
    //             'orderdate' => $orderlists->orderdate,
    //             'price' => $orderlists->totalamount,
    //             'product' => optional($product)->productname,
    //             'images' => $this->i_path .'/productimages/'. optional($productimage)->images,
    //             'totalproduct' => optional($orderdetail)->quantity,
    //             'totalprice' => $orderdetail->orderprices,
    //             'status' => $statusde,
    //         ];
    //     }

    //     if (!empty($orderlist)) {

    //         $result = ['rstatus' => 1, 'message' => 'ok', 'errorcode' => ''];
    //         $response = ['result' => $result, 'data' => $response_data];

    //         return $response;
    //     } else {
    //         $result = ['status' => false, 'message' => 'order not found'];
    //         $result1 = ['rstatus' => 0, 'message' => 'ok', 'errorcode' => 404];
    //         $response = ['result' => $result1];

    //         return $response;
    //     }    
    // }
    
    public function orderlist(Request $request)
    { 
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];

        $orderlist = orderlist::where('assignorder',$userId)->get();

        if (!empty($orderlist)) {

            $result = ['rstatus' => 1, 'message' => 'ok', 'errorcode' => ''];
            $response = ['result' => $result, 'data' => $orderlist];

            return $response;
        } else {
            $result = ['status' => false, 'message' => 'order not found'];
            $result1 = ['rstatus' => 0, 'message' => 'ok', 'errorcode' => 404];
            $response = ['result' => $result1];

            return $response;
        }    
            
    }
    public function driver_status(Request $request)
    { 
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];

        $orderlist = orderlist::where('assignorder',$userId)->where('id',$request->input('id'))->first();
        
        if (!empty($orderlist)) {

        if ($request->input('status') == "Accepted") {
            $status = 1;
        } elseif ($request->input('status') == "Rejected") {
            $status = 2;
        } else {
            $status = 0;
        }

        $orderlist->driver_status = $status;
        $orderlist->save();

        if ($orderlist->driver_status == 1) {
            $statusmsg = "Your order is Accepted";
        } elseif ($orderlist->driver_status == 2) {
            $statusmsg = "Your order is Rejected";
        } else {
            $statusmsg = "Accept/Reject Driver";
        }


            $result = ['rstatus' => 1, 'message' => 'ok', 'errorcode' => ''];
            $response = ['result' => $result, 'data' => $statusmsg];

            return $response;
        } else {
            $result = ['status' => false, 'message' => 'order not found'];
            $result1 = ['rstatus' => 0, 'message' => 'ok', 'errorcode' => 404];
            $response = ['result' => $result1];

            return $response;
        }    
    }
    public function orderhistory(Request $request)
    { 

        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];

        $orderlist = orderlist::where('assignorder',$userId)->where('driver_status',1)->first();

        if (!empty($orderlist)) {

        $result = ['rstatus' => 1, 'message' => 'ok', 'errorcode' => ''];
        $response = ['result' => $result, 'data' => $orderlist];

        return $response;
        } else {
            $result = ['status' => false, 'message' => 'order not found'];
            $result1 = ['rstatus' => 0, 'message' => 'ok', 'errorcode' => 404];
            $response = ['result' => $result1];

            return $response;
        }    
    }
}
