<?php
namespace App\Http\Controllers\Admin;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\File;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Models\Role;
use App\Models\product;
use App\Models\store;
use App\Models\StoreWorkingHour;
use App\Models\Maincategorys;
use App\Models\vendor;
use App\Models\categorys;
use App\Models\Emailtamplete;
use App\Models\promocode;
use App\Models\generalsettings;
use App\Models\settings;
use App\Models\User;
use App\Models\customer;
use App\Models\Deliveryboy;
use App\Models\orderlist;
use App\Models\orderdetail;
use App\Models\sliders;
use App\Models\Receive;
use App\Models\Wallethistory;
use App\Models\productimage;
use App\Models\Notification;
use App\Models\googlemaps;
use App\Models\Items;
use App\Models\Driverspayouts;
use App\Models\Report;
use DB;
use JWTAuth;
use Firebase\JWT\JWT;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Session;

use Barryvdh\DomPDF\Facade\Pdf;
use Razorpay\Api\Api;

use App\Models\productpricesuser;
use Validator;
use Illuminate\Support\Facades\Hash;

class RoleController extends Controller
{
    public function __construct()
    {
        parent::__construct();
        //$this->middleware('auth')->except('privacypolicy');
    }


 public function adminlogin(Request $request)
{
  $email = $request->email;
    $password = md5($request->password);

    $admin = DB::table('admins')
        ->where('username', $email)
        ->where('password', $password)
        ->first();

    if ($admin) {
        // Login success
        Session::put('admin_id', $admin->id);
        Session::put('admin_email', $admin->username);

        return redirect()->route('admin.dashboard')
            ->with('success', 'Login successful');
    } else {
        // Login failed
        return redirect()->back()
            ->with('error', 'Invalid email or password');
    }
}
    public function slideractive($id)
{
    $slider = sliders::find($id);

    if (empty($slider)) {
        return response()->json(['error' => 'Sliders does not exist'], 404);
    }

    $newStatus = $slider->status == '1' ? '2' : '1';

    $slider->update(['status' => $newStatus]);

    return response()->json(['status' => 'success'], 200);
}

    public function deliveryboyactive($id)
{
    $deliveryboy = Deliveryboy::find($id);

    if (empty($deliveryboy)) {
        return createResponse(config('httpResponse.NOT_FOUND'), 'Deliveryboy does not exist', ['error' => 'Deliveryboy does not exist']);
    }

    $status = $deliveryboy->status == '1' ? '2' : '1';

    $updateStatus = [
        'status' => $status,
    ];

    Deliveryboy::where('id', $id)->update($updateStatus);

    $msg = $status == '2' ? 'Deliveryboy deactivated successfully!' : 'Deliveryboy activated successfully!';

    return [
        'msg' => $msg,
        'status' => 'success',
    ];
}


   public function productsactive($id)
{
    $product = product::find($id);

    if (empty($product)) {
        return response()->json(['error' => 'Product does not exist'], 404);
    }

    $newStatus = $product->status == '1' ? '2' : '1';

    $product->update(['status' => $newStatus]);

    return response()->json(['status' => 'success'], 200);
}

    public function promocodesactive($id)
{
    $promocode = Promocode::find($id);

    if (empty($promocode)) {
        return createResponse(config('httpResponse.NOT_FOUND'), 'Promocode does not exist', ['error' => 'Promocode does not exist']);
    }

    $status = $promocode->status == '1' ? '2' : '1';

    $updateStatus = [
        'status' => $status,
    ];

    Promocode::where('id', $id)->update($updateStatus);

    $msg = $status == '2' ? 'Promocode deactivated successfully!' : 'Promocode activated successfully!';

    return [
        'msg' => $msg,
        'status' => 'success',
    ];
}

    public function customeractive($id)
{
    $customer = User::find($id);

    if (empty($customer)) {
        return createResponse(config('httpResponse.NOT_FOUND'), 'Patient does not exist', ['error' => 'Patient does not exist']);
    }

    $status = $customer->status == '1' ? '2' : '1';

    $updateStatus = [
        'status' => $status,
    ];

    User::where('id', $id)->update($updateStatus);

    $msg = $status == '2' ? 'Patient deactivated successfully!' : 'Patient activated successfully!';

    return [
        'msg' => $msg,
        'status' => 'success',
    ];
}

    public function index()
    {
        if (request()->ajax()) {
            $roles = Role::select('id', 'rolename', 'status', 'created_at', 'updated_at')->get();

            return view('admin.role.index_ajax', compact('roles'));
        } else {
            return view('admin.role.index');
        }
    }

    public function add()
    {
        return view('admin.role.add');
    }

    public function roleedit($id)
    {
        $roles = Role::select('id', 'rolename', 'status', 'created_at', 'updated_at')
            ->where('id', $id)

            ->first();

        return view('admin.role.add', compact('roles'));
        exit();
    }
    public function roleeditadmin()
    {
        $id = request()->get('roleid');
        $updateStatus = [
            'rolename' => request()->get('rolename'),
        ];
        role::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.role.index')->with('alert-success', 'Role Updated Successfully.');
        exit();
    }
    public function create(Request $request)
{
    $validator = Validator::make($request->all(), [
        'rolename' => '',
    ]);

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    $useraddste = '1';
    $role = Role::create([
        'rolename' => $request->get('rolename'),
        'status' => $useraddste,
        'created_at' => now(),
        'updated_at' => now(),
    ]);
    if ($role) {
        return redirect()->route('admin.role.index')->with('alert-success', 'Role created successfully.');
    } else {
        return redirect()->back()->with('alert-danger', 'Failed to create role. Please try again.');
    }
}


    public function delete($id)
    {
        $role = role::select('id')->where($id);
        if (isset($role)) {
            role::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['Role successfully deleted.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['The plan could not be deleted. Try again.'], '', 500);
        }
    }
    public function vendorlist()
    {
        if (request()->ajax()) {
            $vendor = vendor::select('id', 'first_name', 'last_name', 'email','password','image','subscription_plan', 'status', 'created_at','updated_at')->get();

            return view('admin.vendor.index_ajax', compact('vendor'));
        } else {
            return view('admin.vendor.index');
        }
    }
    public function vendoradd()
    {


        return view('admin.vendor.add');
    }
    public function vendorcreate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'first_name' => 'required',
            'last_name' => 'required',
        ], [
            'first_name.required' => 'first name field is required',
            'last_name.required' => 'last name field is required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $imagepath = public_path('/image');
        $filename = '';

        if ($request->hasFile('image')) {
            $img_ext = $request->file('image')->getClientOriginalExtension();
            $filename = 'image-' . time() . '.' . $img_ext;
            $request->file('image')->move($imagepath, $filename);
        }



        $jobsadd = vendor::create([
            'image' => $filename,
            'first_name' => $request->get('first_name'),
            'last_name' => $request->get('last_name'),
            'email' => $request->get('email'),
            'password' => $request->get('password'),
            'mobile' => $request->get('mobile'),
            'status' => $request->get('status'),
            'subscription_plan' => $request->get('subscription_plan'),

            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return redirect()->route('admin.vendor.index')
            ->with('alert-success', 'vendor created successfully.');
    }
    public function vendoredit($id)
    {

        $vendor = vendor::select('id', 'first_name', 'last_name', 'email','password','image','subscription_plan', 'status', 'created_at','updated_at')->where('id', $id)->first();

        return view('admin.vendor.add', compact('vendor'));
        exit();
    }
    public function vendoreditadmin(Request $request)
    {
        $id = $request->get('vendorid');
        $imagePath = public_path('image');

        if ($request->hasFile('image')) {
            $img_ext = $request->file('image')->getClientOriginalExtension();
            $filename = 'image-' . time() . '.' . $img_ext;
            $path = $request->file('image')->move($imagePath, $filename);

            $updateStatus = [

               'image' => $filename,
            'first_name' => $request->get('first_name'),
            'last_name' => $request->get('last_name'),
            'email' => $request->get('email'),
            'password' => $request->get('password'),
            'mobile' => $request->get('mobile'),
            'status' => $request->get('status'),
            'subscription_plan' => $request->get('subscription_plan'),
                'updated_at' => now(),
            ];
        } else {
            $updateStatus = [

            'first_name' => $request->get('first_name'),
            'last_name' => $request->get('last_name'),
            'email' => $request->get('email'),
            'password' => $request->get('password'),
            'mobile' => $request->get('mobile'),
            'status' => $request->get('status'),
            'subscription_plan' => $request->get('subscription_plan'),
            'updated_at' => now(),
            ];
        }

        vendor::where('id', $id)->update($updateStatus);

        return redirect()->route('admin.vendor.index')->with('alert-success', 'store updated successfully.');
    }
    public function vendordelete($id)
    {
       $vendor = vendor::select('id')->first($id);

        if (isset($vendor)) {

            store::where('id', $id)->delete();



            $this->CommonHelper->sendJsonResponse(false, [], ['vendor deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete vendor. Please try again.'], '', 500);
        }
   }
    public function storelist()
    {
        if (request()->ajax()) {
            $stores = store::select('id', 'name', 'image', 'vendor','category','mobile','address', 'zone_management', 'latitude', 'longitude', 'description', 'deliverychargeperkm', 'services', 'status', 'enable_self_delivery', 'minimum_delivery_charges','minimum_delivery_charge_within_km','created_at','updated_at')->get();

            return view('admin.store.index_ajax', compact('stores'));
        } else {
            return view('admin.store.index');
        }
    }
    public function storeadd()
    {
        $categorys = categorys::where('status', '!=', '2')->get();

        return view('admin.store.add', compact('categorys'));
    }
    public function storecreate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'mobile' => 'required',
        ], [
            'name.required' => 'name field is required',
            'mobile.required' => 'mobile field is required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $imagepath = public_path('/image');
        $filename = '';

        if ($request->hasFile('image')) {
            $img_ext = $request->file('image')->getClientOriginalExtension();
            $filename = 'image-' . time() . '.' . $img_ext;
            $request->file('image')->move($imagepath, $filename);
        }

        // Fix: Convert services array to string (comma-separated)
        $services = $request->has('services') ? implode(',', $request->get('services')) : '';
        $category = $request->has('category') ? implode(',', $request->get('category')) : '';

        $jobsadd = store::create([
            'image' => $filename,
            'name' => $request->get('name'),
            'status' => $request->get('status'),
            'category' => $category,
            'vendor' => $request->get('vendor'),
            'mobile' => $request->get('mobile'),
            'address' => $request->get('address'),
            'zone_management' => $request->get('zone_management'),
            'latitude' => $request->get('latitude'),
            'longitude' => $request->get('longitude'),
            'description' => $request->get('description'),
            'services' => $services, // Storing as string
            'deliverychargeperkm' => $request->get('deliverychargeperkm'),
            'minimum_delivery_charges' => $request->get('minimum_delivery_charges'),
            'minimum_delivery_charge_within_km' => $request->get('minimum_delivery_charge_within_km'),
            'enable_self_delivery' => $request->get('enable_self_delivery'),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return redirect()->route('admin.store.index')
            ->with('alert-success', 'Store created successfully.');
    }
    public function storeedit($id)
    {
        $maincategorys = Maincategorys::where('status', '!=', '2')->get();
        $categorys = categorys::where('status', '!=', '2')->get();
        $workingHours = StoreWorkingHour::where('store_id', $id)
        ->get(['day', 'from_time', 'to_time'])
        ->toArray();
        $stores = store::select('id', 'name', 'mainc_id', 'image', 'vendor','category','mobile','address', 'zone_management', 'latitude', 'longitude', 'description', 'deliverychargeperkm', 'services', 'status', 'enable_self_delivery', 'minimum_delivery_charges','minimum_delivery_charge_within_km','created_at','updated_at','adminprocessfee','commissiontype','commissionamount','gstno','order_amount')->where('id', $id)->first();

        return view('admin.store.add', compact('stores', 'categorys','workingHours','maincategorys'));
        exit();
    }
    public function storeeditadmin(Request $request)
{
    //dd($request->all());
    $id = $request->get('storeid');

    $category = $request->has('category') ? implode(',', $request->get('category')) : '';
    $maincategory = $request->has('mainc_id') ? implode(',', $request->get('mainc_id')) : '';

    if ($request->hasFile('image')) {

    foreach ($request->file('image') as $img) {

        $imagePath = public_path('storesimage');

        if (!file_exists($imagePath)) {
            mkdir($imagePath, 0777, true);
        }

        $img_ext = $img->getClientOriginalExtension();
        $filename = 'image-' . time() . rand(1000,9999) . '.' . $img_ext;

        $img->move($imagePath, $filename);

        DB::table('storeimage')->insert([
            'store_id' => $id,
            'images'   => $filename,
            'created_at' => now(),
        ]);
    }

        $updateStatus = [
            'image' => $filename,
            'name' => $request->get('name'),
            'status' => $request->get('status'),
            'gstno' => $request->get('gstno'),
            'order_amount' => $request->get('order_amount'),
            'category' => $category,
            'mainc_id' => $maincategory,
            'mobile' => $request->get('mobile'),
            'address' => $request->get('address'),
            'zone_management' => $request->get('zone_management'),
            'latitude' => $request->get('latitude'),
            'longitude' => $request->get('longitude'),
            'description' => $request->get('description'),
            'deliverychargeperkm' => $request->get('deliverychargeperkm'),
            'minimum_delivery_charges' => $request->get('minimum_delivery_charges'),
            'minimum_delivery_charge_within_km' => $request->get('minimum_delivery_charge_within_km'),
            'enable_self_delivery' => $request->get('enable_self_delivery'),
            'adminprocessfee' => $request->get('adminprocessfee') ?? '',
            'commissiontype' => $request->get('commissiontype') ?? '',
            'commissionamount' => $request->get('commissionamount') ?? '',
            'updated_at' => now(),
        ];

    } else {

        $updateStatus = [
            'name' => $request->get('name'),
            'status' => $request->get('status'),
            'gstno' => $request->get('gstno'),
            'order_amount' => $request->get('order_amount'),
            'category' => $category,
            'mainc_id' => $maincategory,
            'mobile' => $request->get('mobile'),
            'address' => $request->get('address'),
            'zone_management' => $request->get('zone_management'),
            'latitude' => $request->get('latitude'),
            'longitude' => $request->get('longitude'),
            'description' => $request->get('description'),
            'deliverychargeperkm' => $request->get('deliverychargeperkm'),
            'minimum_delivery_charges' => $request->get('minimum_delivery_charges'),
            'minimum_delivery_charge_within_km' => $request->get('minimum_delivery_charge_within_km'),
            'enable_self_delivery' => $request->get('enable_self_delivery'),
            'adminprocessfee' => $request->get('adminprocessfee') ?? '',
            'commissiontype' => $request->get('commissiontype') ?? '',
            'commissionamount' => $request->get('commissionamount') ?? '',
            'updated_at' => now(),
        ];
    }

    store::where('id', $id)->update($updateStatus);

    $days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
           StoreWorkingHour::where('store_id', $id)->delete();

        foreach ($days as $day) {
            $fromTimes = $request->input('from_' . strtolower($day), []);
            $toTimes = $request->input('to_' . strtolower($day), []);

            foreach ($fromTimes as $key => $from) {
                $to = $toTimes[$key] ?? null;

                if (!empty($from) && !empty($to)) {
                    $fromFormatted = date('h:i A', strtotime($from));
                    $toFormatted = date('h:i A', strtotime($to));

                    StoreWorkingHour::create([
                        'store_id'  => $id,
                        'day'       => $day,
                        'from_time' => $fromFormatted,
                        'to_time'   => $toFormatted,
                    ]);
                }
            }
        }

    return redirect()->back()->with('alert-success', 'store updated successfully.');
}

    public function storedelete($id)
    {
       $store = store::select('id')->first($id);

        if (isset($store)) {

            store::where('id', $id)->delete();



            $this->CommonHelper->sendJsonResponse(false, [], ['store deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete store. Please try again.'], '', 500);
        }
   }
   public function getproductCategory(Request $request)
{
    $mainc_id = $request->mainc_id;

        $categories = categorys::where('mainc_id', $mainc_id)
            ->get();

        return response()->json($categories);


}
    public function productlist()
    {
        if (request()->ajax()) {
            $products = product::select('id', 'c_id', 'producttype','mainc_id', 'productname','onhand_qty','total_qty','discount_price', 'prices', 'productdetails', 'images', 'status', 'productitemsattr', 'type', 'weight', 'size', 'created_at', 'updated_at')->get();

            return view('admin.product.index_ajax', compact('products'));
        } else {
            return view('admin.product.index');
        }
    }

    public function productadd()
    {
        $Maincategorys = Maincategorys::where('status', '!=', '2')->get();
        $categorys = categorys::where('status', '!=', '2')->get();

        return view('admin.product.add', compact('categorys','Maincategorys'));
    }



    public function productedit($id)
    {
        $categorys = categorys::where('status', '!=', '2')->get();
         $Maincategorys = Maincategorys::where('status', '!=', '2')->get();
        $products = product::select('id', 'productname', 'productdetails','mainc_id','producttype','c_id','food_type','discount_percentage', 'prices','discount_price','total_qty','onhand_qty', 'images', 'status', 'productitemsattr', 'type', 'weight', 'size', 'created_at', 'updated_at')->where('id', $id)->first();

        return view('admin.product.add', compact('products', 'categorys','Maincategorys'));
        exit();
    }
    public function producteditadmin(Request $request)
    {

        $id = request()->get('productid');
        $imagepath = public_path() . '/productimages';
        if(!empty($request->get('productitemsattr')))
        {
            $productItemsAttr = implode(', ', $request->get('productitemsattr'));
        }else{
            $productItemsAttr ='';
        }

        if (!empty($request->File('images'))) {
            //productimage::where('p_id',$id)->delete();
            if ($file = $request->File('images')) {
                foreach ($file as $file) {
                    $image_name = rand(1000, 10000);
                    $img_ext = $file->getClientOriginalExtension();
                    $filename = 'product-' . $image_name . '.' . $img_ext;
                    $path = $file->move($imagepath, $filename); //image save public folder
                    $product = productimage::create([
                        'images' => $filename,
                        'p_id' => $id,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    ]);
                }
            }

            $updateStatus = [
                'productname' => $request->get('productname'),
                'productdetails' => $request->get('productdetails'),
                'producttype' => $request->get('producttype'),
                'c_id' => $request->get('c_id'),
                'mainc_id' => $request->get('mainc_id'),
                'total_qty' => $request->get('total_qty'),
                'onhand_qty' => $request->get('onhand_qty'),
                'discount_price' => $request->get('discount_price'),
                 'discount_percentage' => $request->get('discount_percentage'),
                'type' => $request->get('type'),
                'store_id' =>'1',
                'size' => $request->get('size'),
                'weight' => $request->get('weight'),
                'productitemsattr' => $productItemsAttr ,
                'prices' => $request->get('prices'),
                'food_type' => $request->get('food_type'),
                'status' => $request->get('status'),
            ];

        } else {
            $updateStatus = [
                'productname' => $request->get('productname'),
                'productdetails' => $request->get('productdetails'),
                'c_id' => $request->get('c_id'),
                'mainc_id' => $request->get('mainc_id'),
                'total_qty' => $request->get('total_qty'),
                'food_type' => $request->get('food_type'),
                'onhand_qty' => $request->get('onhand_qty'),
                'discount_price' => $request->get('discount_price'),
                 'discount_percentage' => $request->get('discount_percentage'),
                'type' => $request->get('type'),
                'size' => $request->get('size'),
                'store_id' =>'1',
                'weight' => $request->get('weight'),
                'productitemsattr' => $productItemsAttr ,
                'producttype' => $request->get('producttype'),
                'prices' => $request->get('prices'),
                'status' => $request->get('status'),
            ];
        }
        product::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.product.index');
        exit();
    }
  /*  public function productcreate(Request $request)
    {

         $validator = Validator::make(request()->all(), [

            'productname' => '',
            'price' => '',
            'categoryname' => '',
            'kind of product' => '',
            'description' => '',
            'imagesproducts' => '',
            'status' => 'in:1,2',

        ],[
            'productname.required' => 'productname field is required',
            'price.required' => 'price field is required',
            'categoryname.required' => 'categoryname field is required',
            'kind of product.required' => 'kind of product field is required',
            'description.required' => 'description field is required',
            'imagesproducts.required' => 'imagesproducts field is required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $product = product::where('productname', $request->get('productname'))->get()->count();
        if ($product > 0) {
            return redirect()
                ->back()

                ->with('alert-danger', 'This  product name  is already use');
        } else {

            $imagepath = public_path() . '/productimages';

            $productItemsAttr = implode(', ', $request->get('productitemsattr'));

            $product = product::create([

                'productname' => $request->get('productname'),
                'productdetails' => $request->get('productdetails'),
                'prices' => $request->get('prices'),
                'producttype' => $request->get('producttype'),
                'c_id' => $request->get('c_id'),
                'status' => $request->get('status'),
                'total_qty' => $request->get('total_qty'),
                'onhand_qty' => $request->get('onhand_qty'),
                'type' => $request->get('type'),
                'size' => $request->get('size'),
                'weight' => $request->get('weight'),
                'productitemsattr' => $productItemsAttr ,
                'discount_price' => $request->get('discount_price'),
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);

            $firebaseToken = User::whereNotNull('device_token')->pluck('device_token')->all();
            $SERVER_API_KEY = 'AAAAlmQQrQk:APA91bHw-uejuf6B4Pjx6s17KD10uvqH0SynUzWGpxBDMJ5QMGQBuUn4Cj0p6orikSRRFFbGwysMRpoYacr7lIqz70S1ImvF-2raKVmhraV5yV8PUTQ_vRZMXkXNOVAPRvYejrKGDnVz';
            $data = [
                'registration_ids' => $firebaseToken,
                'notification' => [
                    'Productname' => $request->get('productname'),
                    'prices' => $request->get('prices'),
                    'body' => 'New product add in store',
                    'title' => 'Add new product in store',
                    'Type' => '1',
                ],
                'data' => [
                    'id' => '-1',
                    'Productname' => $request->get('productname'),
                    'prices' => $request->get('prices'),
                    'body' => 'New product add in store',
                    'title' => 'Add new product in store',
                    'Type' => '1',
                ],
            ];
            $dataString = json_encode($data);
            $headers = ['Authorization: key=' . $SERVER_API_KEY, 'Content-Type: application/json'];
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

            $response = curl_exec($ch);

            $productid = $product->id;
            if ($product->id) {
                if ($file = $request->File('images')) {
                    foreach ($file as $file) {
                        $image_name = rand(1000, 10000);
                        $img_ext = $file->getClientOriginalExtension();
                        $filename = 'product-' . $image_name . '.' . $img_ext;
                        $path = $file->move($imagepath, $filename); //image save public folder
                        $product = productimage::create([
                            'images' => $filename,
                            'p_id' => $productid,
                            'created_at' => date('Y-m-d H:i:s'),
                            'updated_at' => date('Y-m-d H:i:s'),
                        ]);
                    }
                }
                return redirect()->route('admin.product.index')->with('alert-success', 'Product created successfully.');
            } else {
                return redirect()->back()->with('alert-danger', 'No se pudo crear el plan. Inténtalo de nuevo.');
            }
        }
    }*/


        public function productcreate(Request $request)
    {
        $validator = Validator::make(request()->all(), [
            'productname' => '',
            'price' => '',
            'categoryname' => '',
            'kind of product' => '',
            'description' => '',
            'imagesproducts' => '',
            'status' => 'in:1,2',
        ], [
            'productname.required' => 'productname field is required',
            'price.required' => 'price field is required',
            'categoryname.required' => 'categoryname field is required',
            'kind of product.required' => 'kind of product field is required',
            'description.required' => 'description field is required',
            'imagesproducts.required' => 'imagesproducts field is required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $product = product::where('productname', $request->get('productname'))->get()->count();
        if ($product > 0) {
            return redirect()->back()->with('alert-danger', 'This product name is already used');
        } else {
            $imagepath = public_path() . '/productimages';
            $productItemsAttr = is_array($request->get('productitemsattr'))
            ? implode(', ', $request->get('productitemsattr'))
            : '';

            $product = product::create([
                'productname' => $request->get('productname'),
                'productdetails' => $request->get('productdetails'),
                'prices' => $request->get('prices'),
                'producttype' => $request->get('producttype'),
                'c_id' => $request->get('c_id'),
                'mainc_id' => $request->get('mainc_id'),
                'status' => $request->get('status'),
                'total_qty' => $request->get('total_qty'),
                'onhand_qty' => $request->get('onhand_qty'),
                'type' => $request->get('type'),
                'store_id' =>'1',
                'discount_percentage' => $request->get('discount_percentage'),
                'food_type' => $request->get('food_type'),
                'size' => $request->get('size'),
                'weight' => $request->get('weight'),
                'productitemsattr' => $productItemsAttr,
                'discount_price' => $request->get('discount_price'),
                'created_at' => now(),
                'updated_at' => now(),
            ]);


            // Assuming images are uploaded, handle them here
            if ($file = $request->file('images')) {
                foreach ($file as $file) {
                    $image_name = rand(1000, 10000);
                    $img_ext = $file->getClientOriginalExtension();
                    $filename = 'product-' . $image_name . '.' . $img_ext;
                    $file->move($imagepath, $filename);
                    productimage::create([
                        'images' => $filename,
                        'p_id' => $product->id,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }

        $title="New Product Added";
        $body='A new product has been added to the store: ' . $request->get('productname');
        $imagep= $imagepath . '/' . $filename;

            // Send push notification after product creation
           /* $firebaseToken = User::whereNotNull('device_token')->pluck('device_token')->all();
            foreach ($firebaseToken as $token) {
                $this->sendFCMNotificationp($title, $body, $imagep, $token);
            }*/

            return redirect()->route('admin.product.index')->with('alert-success', 'Product created successfully.');
        }
    }


        private function sendFCMNotificationp($title, $body, $imagep, $token)
    {
        $url = 'https://fcm.googleapis.com/v1/projects/nearbasket-463c0/messages:send';
        $accessToken = $this->getAccessTokenp();

        $data = [
            'message' => [
                'token' => $token,
                'notification' => [
                    'title' => $title,
                    'body' => $body,
                    'image' => $imagep,

                ],
                'data' => [
                    'title' => $title,
                    'body' => $body,
                    'image' => $imagep
                ],
                'android' => [
                    'notification' => [
                        'sound' => 'default'
                    ]
                ],
                'apns' => [
                    'payload' => [
                        'aps' => [
                            'sound' => 'default'
                        ]
                    ]
                ]
            ]
        ];

        $headers = [
            'Authorization: Bearer ' . $accessToken,
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $result = curl_exec($ch);
        curl_close($ch);

        return $result;
    }

    private function getAccessTokenp()
    {
        $serviceAccount = json_decode(file_get_contents('https://iappstack.com/NearBasket/nearbasket-463c0-firebase-adminsdk-fbsvc-d2ef2cfb9d.json'), true);
        $now = time();
        $token = [
            "iss" => $serviceAccount['client_email'],
            "scope" => "https://www.googleapis.com/auth/firebase.messaging",
            "aud" => "https://oauth2.googleapis.com/token",
            "iat" => $now,
            "exp" => $now + 3600
        ];

        $jwt = JWT::encode($token, $serviceAccount['private_key'], 'RS256');

        $client = new Client();
        $response = $client->post('https://oauth2.googleapis.com/token', [
            'form_params' => [
                'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
                'assertion' => $jwt
            ]
        ]);

        $json = json_decode((string) $response->getBody(), true);
        return $json['access_token'];
    }


    public function productdelete($id)
    {
        $product = product::select('id')->where('id', $id)->first();

        if ($product->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['Product  deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete Product. Please try again.'], '', 500);
        }
    }

    public function customerlist()
    {

        if (request()->ajax()) {
            $customers = User::where('role', 'appuser','user_image')->get();


            return view('admin.customer.index_ajax', compact('customers'));
        } else {
            return view('admin.customer.index');
        }
    }

    public function customeradd()
    {
        $productlist = product::get();
        return view('admin.customer.add', compact('productlist'));
    }

    public function customeredit($id)
    {
        $customers = User::with('productpricesuserwise')->where('id', $id)->first();
        $productlist = product::get();
        return view('admin.customer.add', compact('customers', 'productlist'));
        exit();
    }
    public function customereditadmin(Request $request)
    {

        $id = request()->get('customerid');

        productpricesuser::where('userid', $id)->delete();
        if (!empty($request->get('password'))) {
            $passworda = Hash::make($request->get('password'));
            $customerupdate = [
                'name' => $request->get('firstname'),
                'lastname' => $request->get('lastname'),
                'email' => $request->get('email'),
                'password' => $passworda,
                'contact_no' => $request->get('mobile'),
                'updated_at' => date('Y-m-d H:i:s'),
            ];
        } else {
            $customerupdate = [
                'name' => $request->get('firstname'),
                'lastname' => $request->get('lastname'),
                'email' => $request->get('email'),
                'contact_no' => $request->get('mobile'),
                'updated_at' => date('Y-m-d H:i:s'),
            ];
        }

        User::where('id', '=', $id)->update($customerupdate);

        foreach ($request->get('product') as $key => $value) {
            productpricesuser::create([
                'productid' => $key,
                'productprices' => $value,
                'userid' => $id,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);
        }

        return redirect()->route('admin.customer.index');
        exit();
    }
    public function customercreate(Request $request)
    {
        //print_r($request->all());
        //exit();
        $validator = Validator::make(request()->all(), [
            'firstname' => '',
            'lastname' => '',
            'email' => '',
            'password' => '',
        ]);
        if ($validator->fails()) {
            return redirect()
                ->back()

                ->with('alert-danger', 'Please fill required all fields');
        }
        $userExist = User::where('email', $request->get('email'))->get()->count();
        if ($userExist > 0) {
            return redirect()
                ->back()

                ->with('alert-danger', 'This email id is already registered');
        } else {
            $passworda = Hash::make($request->get('password'));
            $useraddste = '1';
            $customer = User::create([
                'name' => $request->get('firstname'),
                'lastname' => $request->get('lastname'),
                'email' => $request->get('email'),
                'password' => $passworda,
                'contact_no' => $request->get('mobile'),
                'role' => 'appuser',
                'status' => $useraddste,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);


                return redirect()->route('admin.customer.index')->with('alert-success', 'customer created successfully.');

        }
    }
    public function customerdelete($id)
    {
        $users = User::select('id')->first($id);

        if (isset($users)) {

            User::where('id', $id)->delete();

            orderlist::where('c_id', $id)->delete();

            $this->CommonHelper->sendJsonResponse(false, [], ['users deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete users. Please try again.'], '', 500);
        }
    }

    public function orderlist()
{
    $status = request()->query('status');

    $query = OrderList::with('productname', 'username');

    if ($status) {
        $query->where('status', $status);
    }

    $orderlist = $query->get();

    if (request()->ajax()) {
        return view('admin.orderlist.index_ajax', compact('orderlist'));
    }

    // Handle non-AJAX requests
    return view('admin.orderlist.index', compact('orderlist'));
}


    public function orderlistedit($id)
    {
        $orderlist = orderlist::where('id', $id)
        ->first();

        return view('admin.orderlist.add', compact('orderlist'));
        exit();
    }

    public function orderdetails(Request $request, $id)
    {
        $order = orderlist::where('id', $id)->get();

        $orders = orderlist::where('id', $id)->first();
        $orderlist = orderdetail::with('productname')->where('or_id', $id)->get();

        return view('admin.orderlist.orderdetails', compact('orderlist','order','orders'));
        exit();
    }

   /* public function ordereditadmin(Request $request)
    {
        $statusNames = [
            '1' => 'Ordered',
            '2' => 'Confirmed',
            '3' => 'Packed',
            '4' => 'Driver Assigned',
            '5' => 'Driver Accepted',
            '6' => 'Driver Rejected',
            '7' => 'Out for Delivery',
            '8' => 'Delivered',
            '9' => 'Cancel',
        ];
        $id = request()->get('orderid');
        $status = $request->get('status');
        $statusName = $statusNames[$status];

        $customerupdate = [
            'status' => $request->get('status'),
            'assignorder' => $request->get('assignorder'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        orderlist::where('id', '=', $id)->update($customerupdate);

        $firebaseToken = User::whereNotNull('device_token')->pluck('device_token')->all();
        $SERVER_API_KEY = 'AAAAlmQQrQk:APA91bHw-uejuf6B4Pjx6s17KD10uvqH0SynUzWGpxBDMJ5QMGQBuUn4Cj0p6orikSRRFFbGwysMRpoYacr7lIqz70S1ImvF-2raKVmhraV5yV8PUTQ_vRZMXkXNOVAPRvYejrKGDnVz';
        $data = [
            'registration_ids' => $firebaseToken,
            'notification' => [
                'body' => "Order has been updated to $statusName",
                'title' => 'Order Status Update',
            ],
            'data' => [
                'id' => $id,
                'status' => $status,
                'body' => "Order has been updated to $statusName",
                'title' => 'Order Status Update',
            ],
        ];
        $dataString = json_encode($data);
        $headers = ['Authorization: key=' . $SERVER_API_KEY, 'Content-Type: application/json'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

        $response = curl_exec($ch);

        return redirect()->route('admin.orderlist.index')->with('alert-success', 'Order Updated Successfully.');
        exit();
    }*/


   // Send Order Status Notification
// Send Order Status Notification to the user who placed the order
/*public function ordereditadmin(Request $request)
{
    // Validate input
    $validator = Validator::make($request->all(), [
        'status' => 'required',
        'assignorder' => 'nullable',
    ]);

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    $statusNames = [
        '1' => 'Ordered',
        '2' => 'Confirmed',
        '3' => 'Packed',
        '4' => 'Driver Assigned',
        '5' => 'Driver Accepted',
        '6' => 'Driver Rejected',
        '7' => 'Out for Delivery',
        '8' => 'Delivered',
        '9' => 'Cancel',
    ];

    // Retrieve order ID and status
    $id = request()->get('orderid');
    $status = $request->get('status');
    $statusName = $statusNames[$status];

    // Update order status
    $customerupdate = [
        'status' => $status,
        'assignorder' => $request->get('assignorder'),
        'updated_at' => now(),
    ];

    orderlist::where('id', '=', $id)->update($customerupdate);

    // Find the user who placed the order (Assuming there's a user_id field in the order table)
    $order = orderlist::find($id);

    $user = User::find($order->c_id);

    // Check if the user exists and has a device token
    if ($user && $user->device_token) {
        // Create notification data
        $notification = Notification::create([
            'title' => 'Your Order is ' . $statusName,
            'body' => "Order id:-" . $order->orderid,
            'created_at' => now(),
            'updated_at' => now(),
        ]);


        $sendSuccess = $this->sendFCMNotificationorder($notification->title, $notification->body, $user->device_token);

        $responseData = json_decode($sendSuccess, true);
        if (isset($responseData['error']['details'][0]['errorCode']) && $responseData['error']['details'][0]['errorCode'] == 'UNREGISTERED') {
            // If token is unregistered, remove it from the database
            $user->update(['device_token' => null]);
        }

        // Provide feedback based on success or failure
        if ($sendSuccess) {
            return redirect()->route('admin.orderlist.index')->with('alert-success', 'Order updated and notification sent to the user.');
        } else {
            return redirect()->back()->with('alert-danger', 'Failed to send the notification to the user.');
        }
    } else {
        // No device token found for the user
        return redirect()->back()->with('alert-warning', 'No device token found for the user, notification not sent.');
    }
}*/



    public function ordereditadmin(Request $request)
    {
        // Validate input
        $validator = Validator::make($request->all(), [
            'status' => 'required',
            //'assignorder' => 'nullable',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $statusNames = [
            '1' => 'Ordered',
            '2' => 'Confirmed',
            '3' => 'Packed',
            '4' => 'Driver Assigned',
            '5' => 'Driver Accepted',
            '6' => 'Driver Rejected',
            '7' => 'Out for Delivery',
            '8' => 'Delivered',
            '9' => 'Cancel',
        ];

        // Retrieve order ID and status
        $id = $request->get('orderid');
        $status = $request->get('status');
        $statusName = $statusNames[$status];

        // Update order status


        $customerupdate = [
            'status' => $status,
            'assignorder' => $request->get('assignorder'),
            'updated_at' => now(),
        ];

        orderlist::where('id', '=', $id)->update($customerupdate);

        // Find the order and user who placed it
        $order = orderlist::find($id);
        $user = User::where('id',$order->c_id)->first();

        // Check if the user exists and has a device token
        if ($user && $user->device_token) {
            if($status=='2')
            {
                $title='Your Order is Confirmed';
                $orderid="#".$order->orderid." Cheers! Your Order is Confirmed!";
                $order_id=$order->id;
            }elseif ($status=='3') {
                $title='Your Order is Packed';
                $orderid="We have packed your order, it will reach you shortly! #".$order->orderid.".";
                $order_id=$order->id;
            }elseif ($status=='4') {
                $title='Assigned a driver to your order';
                $orderid="We have assigned a driver to your order! #".$order->orderid.".";
                $order_id=$order->id;
            }elseif ($status=='5') {
                $title='Your Order is on the Way';
                $orderid="#".$order->orderid." has been picked up and is on the way.";
                $order_id=$order->id;
            }
            elseif ($status=='7') {
                $title='Your Order Has Been Collected';
                $orderid="#".$order->orderid." has been picked up by the driver. Expect delivery soon!";
                $order_id=$order->id;
            } elseif ($status=='8') {
                $title='Your Order is Delivered!';
                $orderid="#".$order->orderid." has been successfully delivered. Thank you for shopping with us!";
                $order_id=$order->id;
            }else{
                $title='You have a new order!';
                $orderid="You have a new delivery! Order ID: ".$order->orderid." Please review and accept.";
                $order_id=$order->id;
            }
            // Create notification data for the user
            $notification = Notification::create([
                'title' =>$title,
                'body' =>$orderid,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $sendSuccess = $this->sendFCMNotificationorder($notification->title, $notification->body, $user->device_token,$status,$order_id);
            $responseData = json_decode($sendSuccess, true);
            if (isset($responseData['error']['details'][0]['errorCode']) && $responseData['error']['details'][0]['errorCode'] == 'UNREGISTERED') {
                // Remove unregistered device token
                $user->update(['device_token' => null]);
            }
        }

        // Additional logic for Driver Assigned (status 4)
        if ($status == '4') {
            // Retrieve driver details
            $driverId = $request->get('assignorder');
            $driver = Deliveryboy::find($driverId);
            $order_id='';

            if ($driver && $driver->device_token) {
                // Create notification data for the driver
                $driverNotification = Notification::create([
                    'title' => 'You have a new order!',
                    'body' => "You have a new delivery! Order ID #". $order->orderid. ' Please review and accept.',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                $driverSendSuccess = $this->sendFCMNotificationorder(
                    $driverNotification->title,
                    $driverNotification->body,
                    $driver->device_token,
                    $status,
                    $order_id
                );

                $driverResponseData = json_decode($driverSendSuccess, true);
                if (isset($driverResponseData['error']['details'][0]['errorCode']) && $driverResponseData['error']['details'][0]['errorCode'] == 'UNREGISTERED') {
                    // Remove unregistered device token for the driver
                    $driver->update(['device_token' => null]);
                }
            }
        }

        // Provide feedback to admin
        return redirect()->route('admin.orderlist.index')->with('alert-success', 'Order updated and notifications sent.');
    }


private function sendFCMNotificationorder($title, $body, $token,$status,$order_id)
{
    $url = 'https://fcm.googleapis.com/v1/projects/nearbasket-463c0/messages:send';
    $accessToken = $this->getAccessTokenorder();

    $data = [
        'message' => [
            'token' => $token,
            'notification' => [
                'title' => $title,
                'body' => $body,

            ],
            'data' => [
                'title' => $title,
                'body' => $body,
                'status'=>$status,
                'order_id'=>(string)$order_id,

            ],
            'android' => [
                'notification' => [
                    'sound' => 'default'
                ]
            ],
            'apns' => [
                'payload' => [
                    'aps' => [
                        'sound' => 'default'
                    ]
                ]
            ]
        ]
    ];
    // print_r($data);
    // exit();

    $headers = [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    $result = curl_exec($ch);

    curl_close($ch);


    return $result;
}

private function getAccessTokenorder()
{
    $serviceAccount = json_decode(file_get_contents('https://iappstack.com/NearBasket/nearbasket-463c0-firebase-adminsdk-fbsvc-d2ef2cfb9d.json'), true);
    $now = time();
    $token = [
        "iss" => $serviceAccount['client_email'],
        "scope" => "https://www.googleapis.com/auth/firebase.messaging",
        "aud" => "https://oauth2.googleapis.com/token",
        "iat" => $now,
        "exp" => $now + 3600
    ];

    $jwt = JWT::encode($token, $serviceAccount['private_key'], 'RS256');

    $client = new \GuzzleHttp\Client();
    $response = $client->post('https://oauth2.googleapis.com/token', [
        'form_params' => [
            'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
            'assertion' => $jwt
        ]
    ]);

    $json = json_decode((string) $response->getBody(), true);
    return $json['access_token'];
}

    public function orderdelete($id)
    {
        $orderlist = orderlist::select('id')->first($id);

         if (isset($orderlist)) {
            orderlist::where('id',$id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['Order deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['No se pudo eliminar el plan. Inténtalo de nuevo.'], '', 500);
        }
    }
    public function sliderslist()
    {
        if (request()->ajax()) {
            $sliderslist = sliders::select('id', 'slider_image','status')->get();

            return view('admin.sliders.index_ajax', compact('sliderslist'));
        } else {
            return view('admin.sliders.index');
        }
    }
    public function slidersadd()
    {
        return view('admin.sliders.add');
    }
    public function sliderscreate(Request $request)
    {

          $validator = Validator::make($request->all(), [

            'slider_image' => '',

        ], [
            'Slider Image.required' => 'Slider Image field is required',

        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $imagepath = public_path() . '/slider_image';
        if (!empty($request->File('slider_image'))) {
            $img_ext = $request->File('slider_image')->getClientOriginalExtension();
            $filename = 'slider_image-' . time() . '.' . $img_ext;
            $path = $request->file('slider_image')->move($imagepath, $filename);
        } else {
            $filename = '';
        }
        $useraddste = '1';
        $product = sliders::create([
            'slider_image' => $filename,
            'status' => $useraddste,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);

        if ($product->id) {
            return redirect()->route('admin.sliders.index')->with('alert-success', 'slider created successfully.');
        } else {
            return redirect()->back()->with('alert-danger', 'No se pudo crear el plan. Inténtalo de nuevo.');
        }
    }
    public function slidersedit($id)
    {
        $sliderslist = sliders::select('id', 'slider_image', 'status', 'created_at', 'updated_at')
            ->where('id', $id)

            ->first();

        return view('admin.sliders.add', compact('sliderslist'));
        exit();
    }
    public function sliderseditadmin(Request $request)
    {
        $id = request()->get('sliderid');
        $imagepath = public_path() . '/slider_image';
        if (!empty($request->File('slider_image'))) {
            $img_ext = $request->File('slider_image')->getClientOriginalExtension();
            $filename = 'slider_image-' . time() . '.' . $img_ext;
            $path = $request->file('slider_image')->move($imagepath, $filename); //image save public folder
            $updateStatus = [
                'slider_image' => $filename,
            ];
        } else {
            $updateStatus = [];
        }
        sliders::where('id', '=', $id)->update($updateStatus);
        return redirect()->route('admin.sliders.index');
        exit();
    }
    public function slidersdelete($id)
    {
        $role = sliders::select('id')->where('id', $id)->first();

        if ($role->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['sliders eliminado con exito.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['No se pudo eliminar el plan. Inténtalo de nuevo.'], '', 500);
        }
    }

    public function exportcsv(Request $request)
    {
        $timelineData = orderlist::with('productname', 'username')->get();
        $csv_data = [];
        foreach ($timelineData as $key => $data) {
            $data_temp = [];
            $search = $data['id'];
            $data123 = orderdetail::leftJoin('product', 'product.id', '=', 'orderdetails.p_id')->where('or_id', $search)->get();
            $productde = [];
            $quantityde = [];
            $prices = [];
            foreach ($data123 as $key => $productdetails) {
                $productde[] = $productdetails['productname'];
                $quantityde[] = $productdetails['quantity'];
                $prices[] = $productdetails['orderprices'];
            }

            if (count($productde) > 0) {
                $List = implode(', ', $productde);
            } else {
                $List = '';
            }
            if (count($quantityde) > 0) {
                $qualist = implode(', ', $quantityde);
            } else {
                $qualist = '';
            }
            if (count($prices) > 0) {
                $prices = implode(', ', $prices);
            } else {
                $prices = '';
            }
            $data_temp['Identificación'] = $data['id'];
            $data_temp['Order ID'] = $data['orderid'];
            if (isset($data['username'][0]['name'])) {
                $data_temp['Customer Name'] = $data['username'][0]['name'] . $data['username'][0]['lastname'];
            } else {
                $data_temp['Name'] = '';
            }
            $data_temp['Product Name'] = $data['orderdate'];
            $data_temp['Product Name'] = $List;
            $data_temp['PRICES'] = $prices;
            $data_temp['Quantity'] = $qualist;
            $data_temp['Total'] = $data['totalamount'];

            $csv_data[] = $data_temp;
        }

        $headers = ['Content-Type: application/vnd.ms-excel; charset=UTF-16LE'];
        if (isset($request->usereport) && $request->usereport == 'dashboard') {
            $file_name = __('messages.userreport') . '_' . date('Y-m-d') . '.csv';
        } else {
            $file_name = 'Ordercsv' . '_' . date('Y-m-d') . '.csv';
        }

        $file_path = public_path($file_name);
        $fp = fopen($file_path, 'w+');
        fputs($fp, "\xEF\xBB\xBF");
        fputcsv($fp, array_keys($csv_data[0]));
        foreach ($csv_data as $line) {
            fputcsv($fp, $line);
        }
        fclose($fp);
        return response()->download($file_path, $file_name, $headers)->deleteFileAfterSend(true);

        exit();
    }

    public function getCategory(Request $request)
{
    $mainc_id = $request->mainc_id;
    $categories = categorys::whereIn('mainc_id', $mainc_id)->get();

    return response()->json($categories);
}

public function imagesdelete(Request $request)
{
    $image = DB::table('storeimage')->where('id', $request->imagesid)->first();

    if ($image) {

        $filePath = public_path('storesimage/'.$image->images);
        if (file_exists($filePath)) {
            unlink($filePath);
        }

        DB::table('storeimage')->where('id', $request->imagesid)->delete();

        return response()->json([
            'msg' => 'Image deleted successfully.',
            'status' => 'success',
        ]);
    }

    return response()->json(['status' => 'error']);
}


    public function promocodesindex()
    {
        if (request()->ajax()) {
            $promocodes = promocode::select('id', 'promocode', 'promocodediscount', 'total_used', 'status','Discount_Type')->get();

            return view('admin.promocodes.index_ajax', compact('promocodes'));
        } else {
            return view('admin.promocodes.index');
        }
    }

    public function promocodesadd()
    {
        return view('admin.promocodes.add');
    }

    public function promocodescreate(Request $request)
    {
      $validator = Validator::make($request->all(), [
            'promocode' => '',
            'promocodediscount' => '',
            'total_used' => '',

        ], [
            'Promocode.required' => 'Promocode field is required',
            'Promocodediscount.required' => 'Promocodediscount field is required',
            'Total used.required' => 'Total used field is required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $promocodeExists = Promocode::where('promocode', $request->get('promocode'))->exists();
        if ($promocodeExists) {
            return redirect()->back()->with('alert-danger', 'This promocode name is already in use');
        } else {
            $userAddStatus = '1';
            $promocode = Promocode::create([
                'promocode' => $request->input('promocode'),
                'promocodediscount' => $request->input('promocodediscount'),
                'total_used' => $request->input('total_used'),
                'Discount_Type'=> $request->input('Discount_Type'),
                'status' => $userAddStatus,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            return redirect()->route('admin.promocodes.index')->with('alert-success', 'Promocode Created Successfully.');
        }
    }

    public function promocodesedit($id)
    {
        $promocodes = promocode::where('id', $id)->first();

        return view('admin.promocodes.add', compact('promocodes'));
        exit();
    }
    public function promocodeseditadmin(Request $request)
    {
        $id = request()->get('promocodesid');

        $promocodes = [
            'promocode' => $request->get('promocode'),
            'promocodediscount' => $request->get('promocodediscount'),
            'total_used' => $request->get('total_used'),
            'Discount_Type'=> $request->input('Discount_Type'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        promocode::where('id', '=', $id)->update($promocodes);

        return redirect()->route('admin.promocodes.index')->with('alert-success', 'Promo Codes updated Successfully.');
        exit();
    }
    public function promocodesdelete($id)
    {
        $promocodes = promocode::select('id')->first($id);

        if (isset($promocodes)) {
            promocode::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['promocode deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete promocode. Please try again.'], '', 500);
        }
    }
    public function generalsettingsindex()
    {
        if (request()->ajax()) {
            $generalsettings = generalsettings::select('id', 'packname','symbol', 'currency', 'tax', 'gst','admin_commission','radius_configuration','delivery_charge')->get();

            return view('admin.generalsettings.index_ajax', compact('generalsettings'));
        } else {
            return view('admin.generalsettings.index');
        }
    }
    public function generalsettingsadd()
    {
        return view('admin.generalsettings.add');
    }

public function generalsettingscreate(Request $request)
{
    $imagePath = public_path('theme_image');

    if ($request->hasFile('admin_logo')) {
        $adminLogo = $request->file('admin_logo');
        $adminLogoName = 'admin_logo-' . time() . '.' . $adminLogo->getClientOriginalExtension();
        $adminLogo->move($imagePath, $adminLogoName);
    } else {
        $adminLogoName = '';
    }

    if ($request->hasFile('default_image')) {
        $defaultImage = $request->file('default_image');
        $defaultImageName = 'default_image-' . time() . '.' . $defaultImage->getClientOriginalExtension();
        $defaultImage->move($imagePath, $defaultImageName);
    } else {
        $defaultImageName = '';
    }

    if ($request->hasFile('favicon_icon')) {
        $faviconIcon = $request->file('favicon_icon');
        $faviconIconName = 'favicon_icon-' . time() . '.' . $faviconIcon->getClientOriginalExtension();
        $faviconIcon->move($imagePath, $faviconIconName);
    } else {
        $faviconIconName = '';
    }

    $generalSettings = generalsettings::create([
        'packname' => $request->get('packname'),
        'symbol' => $request->get('symbol'),
        'currency' => $request->get('currency'),
        'tax' => $request->get('tax'),
        'gst' => $request->get('gst'),
        'admin_commission' => $request->get('admin_commission'),
        'radius_configuration' => $request->get('radius_configuration'),
        'delivery_charge' => $request->get('delivery_charge'),
        'admin_logo' => $adminLogoName,
        'default_image' => $defaultImageName,
        'favicon_icon' => $faviconIconName,
        'app_color' => $request->get('app_color'),
        'admin_color' => $request->get('admin_color'),
        'store_color' => $request->get('store_color'),
        'status' => '1',
        'created_at' => now(),
        'updated_at' => now(),
    ]);

    return redirect()->route('admin.generalsettings.index')->with('alert-success', 'General settings created successfully.');
}


    public function generalsettingsedit($id)
    {
        $generalsettings = generalsettings::where('id', $id)->first();

        return view('admin.generalsettings.add', compact('generalsettings'));
        exit();
    }

    public function generalsettingseditadmin(Request $request)
    {
        $id = request()->get('generalsettingsid');

         $generalsettings = [
        'packname' => $request->get('packname'),
        'symbol' => $request->get('symbol'),
        'currency' => $request->get('currency'),
        'tax' => $request->get('tax'),
        'gst' => $request->get('gst'),
        'admin_commission' => $request->get('admin_commission'),
        'radius_configuration' => $request->get('radius_configuration'),
        'delivery_charge' => $request->get('delivery_charge'),
        'app_color' => $request->get('app_color'),
        'admin_color' => $request->get('admin_color'),
        'store_color' => $request->get('store_color'),
        'updated_at' => now(),
    ];

    $imagePath = public_path('theme_image');

    if ($request->hasFile('admin_logo')) {
        $adminLogo = $request->file('admin_logo');
        $adminLogoName = 'admin_logo-' . time() . '.' . $adminLogo->getClientOriginalExtension();
        $adminLogo->move($imagePath, $adminLogoName);
        $generalsettings['admin_logo'] = $adminLogoName;
    }

    if ($request->hasFile('default_image')) {
        $defaultImage = $request->file('default_image');
        $defaultImageName = 'default_image-' . time() . '.' . $defaultImage->getClientOriginalExtension();
        $defaultImage->move($imagePath, $defaultImageName);
        $generalsettings['default_image'] = $defaultImageName;
    }

    if ($request->hasFile('favicon_icon')) {
        $faviconIcon = $request->file('favicon_icon');
        $faviconIconName = 'favicon_icon-' . time() . '.' . $faviconIcon->getClientOriginalExtension();
        $faviconIcon->move($imagePath, $faviconIconName);
        $generalsettings['favicon_icon'] = $faviconIconName;
    }

    generalsettings::where('id', $id)->update($generalsettings);

    return redirect()->route('admin.generalsettings.index')->with('alert-success', 'settings updated successfully.');
}

   public function generalsettingstheme($id)
    {
         $generalsettings = generalsettings::where('id', $id)->first();

        return view('admin.generalsettings.theme', compact('generalsettings'));
        exit();

        }

    public function generalsettingsdelete($id)
    {
        $generalsettings = generalsettings::select('id')->first($id);

        if (isset($generalsettings)) {
            generalsettings::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['generalsetting  deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete generalsetting. Please try again.'], '', 500);
        }
    }

    public function generalsettingslogo(Request $request){
   return view ('admin.generalsettings.theme');

    }

    public function deliveryboyindex()
    {
        if (request()->ajax()) {
            $generalsettings = Deliveryboy::select('id', 'name','rc_status','license_status','adhar_status', 'email', 'phone', 'dob','complete_order', 'status','licence_image', 'rc_book','adhar_image','driving_license')->orderBy('created_at', 'desc')
            ->get();
            //dd($generalsettings);
            return view('admin.deliveryboy.index_ajax', compact('generalsettings'));
        } else {
            return view('admin.deliveryboy.index');
        }
    }

    public function approvedDrivers()
    {
        if (request()->ajax()) {

            $approvedDrivers = Deliveryboy::where('driver_approved', 1)->orderBy('created_at', 'desc')->get();
        return view('admin.approveddriver.index_ajax', compact('approvedDrivers'));
        } else {
            return view('admin.approveddriver.index');
        }
    }

    public function pendingDrivers()
    {
        if (request()->ajax()) {
            $pendingDrivers = Deliveryboy::where('driver_approved', 0)->orderBy('created_at', 'desc')->get();
        return view('admin.pandingdriver.index_ajax', compact('pendingDrivers'));
        } else {
            return view('admin.pandingdriver.index');
        }
    }

    public function deliveryboyadd()
    {
        return view('admin.deliveryboy.add');
    }


public function rcapprove(Request $request, $id)
{
    $driver = Deliveryboy::find($id);

    if (!$driver) {
        return response()->json(['success' => false, 'message' => 'Driver not found.']);
    }

    $driver->rc_status = 1;

    if ($driver->rc_status == 1 && $driver->license_status == 1 && $driver->adhar_status == 1) {
        $driver->driver_approved = 1;
    }

    $driver->save();

    return response()->json(['success' => true, 'message' => 'Driver approved successfully.']);
}

public function rcreject($id)
{
    $driver = Deliveryboy::find($id);

    if (!$driver) {
        return response()->json(['success' => false, 'message' => 'Driver not found.']);
    }

    $driver->rc_status = 0;

    $driver->driver_approved = 0;

    $driver->save();

    return response()->json(['success' => true, 'message' => 'Driver rejected successfully.']);
}

public function rcapproves(Request $request, $id)
{
    $driver = Deliveryboy::find($id);

    if (!$driver) {
        return response()->json(['success' => false, 'message' => 'Driver not found.']);
    }

    $driver->license_status = 1;

    if ($driver->rc_status == 1 && $driver->license_status == 1 && $driver->adhar_status == 1) {
        $driver->driver_approved = 1;
    }

    $driver->save();

    return response()->json(['success' => true, 'message' => 'Driver approved successfully.']);
}

public function rcrejects($id)
{
    $driver = Deliveryboy::find($id);

    if (!$driver) {
        return response()->json(['success' => false, 'message' => 'Driver not found.']);
    }

    $driver->license_status = 0;

    $driver->driver_approved = 0;

    $driver->save();

    return response()->json(['success' => true, 'message' => 'Driver rejected successfully.']);
}

public function adharapprove(Request $request, $id)
{
    $driver = Deliveryboy::find($id);

    if (!$driver) {
        return response()->json(['success' => false, 'message' => 'Driver not found.']);
    }

    $driver->adhar_status = 1;

    if ($driver->rc_status == 1 && $driver->license_status == 1 && $driver->adhar_status == 1) {
        $driver->driver_approved = 1;
    }

    $driver->save();

    return response()->json(['success' => true, 'message' => 'Driver approved successfully.']);
}

public function adharreject($id)
{
    $driver = Deliveryboy::find($id);

    if (!$driver) {
        return response()->json(['success' => false, 'message' => 'Driver not found.']);
    }

    $driver->adhar_status = 0;

    $driver->driver_approved = 0;

    $driver->save();

    return response()->json(['success' => true, 'message' => 'Driver rejected successfully.']);
}


public function driverapprove($id)
{
    $driver = Deliveryboy::find($id);

    if (!$driver) {
        return response()->json(['success' => false, 'message' => 'Driver not found.']);
    }

    $driver->join_date = date('Y-m-d');
    $driver->driver_approved = 1;
    $driver->save();

    return response()->json(['success' => true, 'message' => 'Driver approved successfully.']);
}

    public function deliveryboycreate(Request $request)
    {
 /*        print_r($request->all());
        exit(); */
        $validator = Validator::make($request->all(), [
            'name' => '',
            'email' => '',
            'phone' => '',
            'dob' => '',
            'complete_order' => '',
            'address' => '',
            'aadharnumber' => '',
            'vehicle_type' => '',
            'vehicle_no' => '',
            'licence' => '',
           'is_online' => '',

        ], [
            'Name.required' => 'Name field is required',
            'Email.required' => 'Email field is required',
            'Phone.required' => 'Phone field is required',
            'Dob.required' => 'Dob field is required',
            'Complete Order.required' => 'Complete Order field is required',
            'Address.required' => 'Address field is required',
            'Aadhar Number.required' => 'Aadhar Number field is required',
            'Vehicle Type.required' => 'Vehicle Type field is required',
            'Vehicle No.required' => 'Vehicle No field is required',
            'Licence.required' => 'Licence field is required',
            'Is Online.required' => 'Is Online field is required',

        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $generalSettingsExist = Deliveryboy::where('name', $request->get('name'))->exists();
        if ($generalSettingsExist) {
            return redirect()->back()->with('alert-danger', 'This name is already in use');
        }


        $imagePath = public_path('drivers');

        // Check if the 'drivers' folder exists, if not, create it
        if (!file_exists($imagePath)) {
            mkdir($imagePath, 0777, true); // Create directory if it doesn't exist
        }

        // Logic for uploading 'driving_license'
        if ($request->hasFile('driving_license')) {
            $drivingLicense = $request->file('driving_license');
            $drivingLicenseName = 'driving_license-' . time() . '.' . $drivingLicense->getClientOriginalExtension();
            $drivingLicense->move($imagePath, $drivingLicenseName);
        } else {
            $drivingLicenseName = '';
        }

        // Logic for uploading 'rc_book'
        if ($request->hasFile('rc_book')) {
            $rcBook = $request->file('rc_book');
            $rcBookName = 'rc_book-' . time() . '.' . $rcBook->getClientOriginalExtension();
            $rcBook->move($imagePath, $rcBookName);
        } else {
            $rcBookName = '';
        }

         // Logic for uploading 'rc_book'
         if ($request->hasFile('adhar_image')) {
            $adharcard = $request->file('adhar_image');
            $adharcardName = 'adhar_image-' . time() . '.' . $adharcard->getClientOriginalExtension();
            $adharcard->move($imagePath, $adharcardName);
        } else {
            $adharcardName = '';
        }

        $generalSettings = Deliveryboy::create([
            'name' => $request->get('name'),
            'email' => $request->get('email'),
            'phone' => $request->get('phone'),
            'dob' => $request->get('dob'),
            'complete_order' =>$request->get('complete_order'),
            'is_online' => $request->get('is_online'),
            'address' => $request->get('address'),
            'aadharnumber' => $request->get('aadharnumber'),
            'vehicle_type' => $request->get('vehicle_type'),
            'vehicle_no' => $request->get('vehicle_no'),
            'licence' => $request->get('licence'),
            'driving_license' =>  $drivingLicenseName,
            'rc_book' => $rcBookName,
            'adhar_image' => $adharcardName,
            'rc_status' => 2,
            'adhar_status' => 2,
            'license_status' => 2,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        return redirect()->route('admin.deliveryboy.index')->with('alert-success', 'Delivery boy created successfully.');
    }

    public function deliveryboyedit($id)
    {
        $generalsettings = Deliveryboy::where('id', $id)->first();
        return view('admin.deliveryboy.add', compact('generalsettings'));
        exit();
    }

    public function deliveryboyeditadmin(Request $request)
    {
        $id = request()->get('generalsettingsid');

        $generalsettings = [
            'name' => $request->get('name'),
            'email' => $request->get('email'),
            'phone' => $request->get('phone'),
            'dob' => $request->get('dob'),
            'complete_order' =>$request->get('complete_order'),
            'is_online' => $request->get('is_online'),
            'address' => $request->get('address'),
            'aadharnumber' => $request->get('aadharnumber'),
            'vehicle_type' => $request->get('vehicle_type'),
            'vehicle_no' => $request->get('vehicle_no'),
            'licence' => $request->get('licence'),
           /*  'driving_license' => $request->get('driving_license'),
            'rc_book' => $request->get('rc_book'),
            'adhar_image' => $request->get('adhar_image'), */
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        $imagePath = public_path('drivers');

        if ($request->hasFile('driving_license')) {
            $drivingLicense = $request->file('driving_license');
            $drivingLicenseName = 'driving_license-' . time() . '.' . $drivingLicense->getClientOriginalExtension();
            $drivingLicense->move($imagePath, $drivingLicenseName);
            $generalsettings['driving_license'] = $drivingLicenseName;
        }

        if ($request->hasFile('rc_book')) {
            $rcBook = $request->file('rc_book');
            $rcBookName = 'rc_book-' . time() . '.' . $rcBook->getClientOriginalExtension();
            $rcBook->move($imagePath, $rcBookName);
            $generalsettings['rc_book'] = $rcBookName;
        }

        if ($request->hasFile('adhar_image')) {
            $adharImage = $request->file('adhar_image');
            $adharCardName = 'adhar_image-' . time() . '.' . $adharImage->getClientOriginalExtension();
            $adharImage->move($imagePath, $adharCardName);
            $generalsettings['adhar_image'] = $adharCardName;
        }




        Deliveryboy::where('id', '=', $id)->update($generalsettings);

        return redirect()->route('admin.deliveryboy.index')->with('alert-success', 'Delivery boy Updated Successfully.');

        exit();
    }

     public function deliveryboydetails(Request $request, $id)
{
    $generalsettings = Deliveryboy::findOrFail($id);
    $orders = orderlist::where('assignorder', $id)->get();
    return view('admin.deliveryboy.deliveryboydetails', compact('orders','generalsettings'));
}


    public function deliveryboydelete($id)
    {
        $generalsettings = Deliveryboy::select('id')->first($id);

        if (isset($generalsettings)) {
            Deliveryboy::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['Delivery boy  deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete delivery boy. Please try again.'], '', 500);
        }
    }

    public function settingsindex()
    {
        if (request()->ajax()) {
            $generalsettings = settings::select('id', 'pagename', 'description', 'Packname', 'currency', 'tax', 'gst','mobile_no')->get();

            return view('admin.settings.index_ajax', compact('generalsettings'));
        } else {
            return view('admin.settings.index');
        }
    }

    public function settingsadd()
    {
        return view('admin.settings.add');
    }

    public function settingscreate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'pagename' => 'required',
            'description' => 'required',
            'Packname' => 'required',
            'currency' => 'required',
            'tax' => 'required',
            'gst' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput()->with('alert-danger', 'Please fill all required fields');
        }

        $generalSettingsExist = settings::where('pagename', $request->get('pagename'))->exists();
        if ($generalSettingsExist) {
            return redirect()->back()->with('alert-danger', 'This page name is already in use');
        }
        $generalSettings = settings::create([
            'pagename' => $request->get('pagename'),
            'description' => $request->get('description'),
            'status' => '1', // Assuming status is always set to '1'
            'Packname' => $request->get('Packname'),
            'currency' => $request->get('currency'),
            'tax' => $request->get('tax'),
            'gst' => $request->get('gst'),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return redirect()->route('admin.settings.index')->with('alert-success', 'General settings created successfully.');
    }

   /* public function settingsedit($id)
    {
        $generalsettings = Settings::find($id);
        if ($id == 1) {
            return view('admin.settings.applications', compact('generalsettings'));
        } else {
            return view('admin.settings.add', compact('generalsettings'));
        }
    }
*/

     public function settingsedit($id)
    {
        $generalsettings = Settings::where('id', $id)->first();

        return view('admin.settings.add', compact('generalsettings'));
        exit();
    }

    public function settingseditadmin(Request $request)
{
    $id = $request->get('generalsettingsid');
    $generalsettings = [
        'pagename' => $request->get('pagename'),
        'mobile_no' => $request->get('mobile_no'),
        'description' => $request->get('description'),
        'status' => '1',
        'created_at' => now(),
        'updated_at' => now(),
    ];

    settings::where('id', '=', $id)->update($generalsettings);
    return redirect()->route('admin.settings.index')->with('alert-success', 'General settings updated Successfully.');
}


    public function settingsdelete($id)
    {
        $generalsettings = settings::select('id')->first($id);

        if (isset($generalsettings)) {
            settings::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['setting  deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete setting. Please try again.'], '', 500);
        }
    }
public function tampleteindex()
    {
        if (request()->ajax()) {
            $tamplete = Emailtamplete::select('id', 'email','subject', 'details')->get();

            return view('admin.emailtamplete.index_ajax', compact('tamplete'));
        } else {
            return view('admin.emailtamplete.index');
        }
    }
    public function tampleteadd()
    {
        return view('admin.emailtamplete.add');
    }

   public function tampletecreate(Request $request)
{
    $validator = Validator::make($request->all(), [
        'email' => '',
        'subject' => '',
        'details' => '',
    ], [
        'email.required' => 'Email field is required',
        'details.required' => 'Details field is required',
    ]);

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    $templateExists = Emailtamplete::where('email', $request->get('email'))->exists();
    if ($templateExists) {
        return redirect()->back()->with('alert-danger', 'This email template is already in use');
    }

    $template = Emailtamplete::create([
        'email' => $request->get('email'),
        'subject' => $request->get('subject'),
        'details' => $request->get('details')
    ]);

    return redirect()->route('admin.emailtamplete.index')->with('alert-success', 'Email template created successfully.');
}



    public function tampleteedit($id)
    {
        $tamplete = Emailtamplete::where('id', $id)->first();

        return view('admin.emailtamplete.add', compact('tamplete'));
        exit();
    }
    public function tampleteeditadmin(Request $request)
    {
        $id = request()->get('tampleteid');

        $tamplete = [
            'email' => $request->get('email'),
            'subject' => $request->get('subject'),
            'details' => $request->get('details'),

                   ];

        Emailtamplete::where('id', '=', $id)->update($tamplete);

        return redirect()->route('admin.emailtamplete.index')->with('alert-success', 'Email Tamplete Updated Successfully.');
        exit();
    }
    public function tampletedelete($id)
    {
        $tamplete = Emailtamplete::select('id')->first($id);

        if (isset($tamplete)) {
            Emailtamplete::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['Email tamplete  deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete email tamplete. Please try again.'], '', 500);
        }
    }

    public function itemsindex()
    {
        if (request()->ajax()) {
            $tamplete = Items::select('id', 'name')->get();

            return view('admin.Items.index_ajax', compact('tamplete'));
        } else {
            return view('admin.Items.index');
        }
    }
    public function itemsadd()
    {
        return view('admin.Items.add');
    }

   public function itemscreate(Request $request)
{
    $validator = Validator::make($request->all(), [
        'name' => '',
    ], [
        'name.required' => 'Name field is required',
    ]);

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    $templateExists = Items::where('name', $request->get('name'))->exists();
    if ($templateExists) {
        return redirect()->back()->with('alert-danger', 'This name is already in use');
    }

    $template = Items::create([
        'name' => $request->get('name'),
    ]);

    return redirect()->route('admin.items.index')->with('alert-success', 'Item Attribute created successfully.');
}



    public function itemsedit($id)
    {
        $tamplete = Items::where('id', $id)->first();

        return view('admin.Items.add', compact('tamplete'));
        exit();
    }
    public function itemseditadmin(Request $request)
    {
        $id = request()->get('itemid');

        $tamplete = [
            'name' => $request->get('name'),
                   ];

        Items::where('id', '=', $id)->update($tamplete);

        return redirect()->route('admin.items.index')->with('alert-success', 'Item Attribute Updated Successfully.');
        exit();
    }
    public function itemsdelete($id)
    {
        $tamplete = Items::select('id')->first($id);

        if (isset($tamplete)) {
            Items::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['Item Attribute  deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete Item Attribute. Please try again.'], '', 500);
        }
    }

    public function driversPayoutsindex()
    {
        if (request()->ajax()) {
            $tamplete = Wallethistory::select('id', 'deliveryboyid','orderid','credit','debit','balance')->get();

            return view('admin.Payouts.index_ajax', compact('tamplete'));
        } else {
            return view('admin.Payouts.index');
        }
    }

    public function driversPayoutindex($id)
    {
        $tamplete = Wallethistory::select('id', 'deliveryboyid','orderid','credit','debit','balance','debit')->where('deliveryboyid', $id)->get();

        $driver = DB::table('deliveryboys')->where('id', $id)->first();

        // Check if a payout exists for the driver
        $payoutExists = DB::table('drivers_payouts')->where('name', $id)->exists();

        // If the request is an AJAX request, return the ajax view
        if (request()->ajax()) {
            return view('admin.Payouts.index_ajax', compact('tamplete', 'driver', 'payoutExists'));
        } else {
            // Return the standard view
            return view('admin.Payouts.index', compact('tamplete', 'driver', 'payoutExists'));
        }
    }
    public function driversPayoutsadd($id)
    {
        $drivers = DB::table('deliveryboys')->where('id',$id)->get();
        return view('admin.Payouts.add',compact('drivers'));
    }

   public function driversPayoutscreate(Request $request)
{
    $validator = Validator::make($request->all(), [
        'name' => '',
        'amount' => '',
        'notes' => '',
    ], [
        'name.required' => 'Name field is required',
        'amount.required' => 'amount field is required',
        'notes.required' => 'notes field is required',
    ]);

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    /* $templateExists = Driverspayouts::where('name', $request->get('name'))->exists();
    if ($templateExists) {
        return redirect()->back()->with('alert-danger', 'This name is already in use');
    } */
   $drive =  $request->get('name');
    $template = Driverspayouts::create([
        'name' => $request->get('name'),
        'amount' => $request->get('amount'),
        'notes' => $request->get('notes'),
    ]);

    return redirect('admin/driversPayout/'.$drive)->with('alert-success', 'Driver Payouts created successfully.');
}

    public function driversPayoutsedit($id)
    {
        $tamplete = Driverspayouts::where('id', $id)->first();
        $drivers = Deliveryboy::select('id', 'name', 'email', 'phone', 'dob', 'complete_order', 'status')->get();

        return view('admin.Payouts.add', compact('tamplete','drivers'));
        exit();
    }
    public function driversPayoutseditadmin(Request $request)
    {
        $id = request()->get('itemid');

        $tamplete = [
            'name' => $request->get('name'),
            'amount' => $request->get('amount'),
            'notes' => $request->get('notes'),
                   ];

        Driverspayouts::where('id', '=', $id)->update($tamplete);

        $drive =  $request->get('name');

        return redirect('admin/driversPayout/'.$drive)->with('alert-success', 'Driver Payouts Updated successfully.');

       // return redirect()->route('admin.driversPayout.index', ['id' =>$id])->with('alert-success', 'Driver Payouts Updated Successfully.');
        exit();
    }
    public function driversPayoutsdelete($id)
    {
        $tamplete = Wallethistory::select('id')->first($id);

        if (isset($tamplete)) {
            Wallethistory::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['Wallet history  deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete Driver Payouts. Please try again.'], '', 500);
        }
    }

    public function deliveryboypayouts(Request $request, $id)
    {
        $generalsettings = Deliveryboy::findOrFail($id);
        $orders = Driverspayouts::where('name', $id)->get();
        return view('admin.driversPayouts.index', compact('orders','generalsettings'));
    }

    public function bulkDelete(Request $request)
{
    $ids = $request->input('delete_ids', []);
    if (!empty($ids)) {
        Promocode::whereIn('id', $ids)->delete();
    }
    return redirect()->back()->with('success', 'Selected promocodes deleted successfully.');
}

   /* public function salesadd()
    {
        $drivers = Deliveryboy::select('id', 'name', 'email', 'phone', 'dob','complete_order', 'status')->get();
        $customers = User::where('role', 'appuser')->get();
        $categorys = categorys::where('status', '!=', '2')->get();
        return view('admin.sales.index',compact('drivers','customers','categorys'));
    }*/



public function salesadd(Request $request)
{
    $drivers = Deliveryboy::select('id', 'name', 'email', 'phone', 'dob', 'complete_order', 'status')->get();
    $customers = User::where('role', 'appuser')->get();
    $categorys = categorys::where('status', '!=', '2')->get();

    // If request is for report download
    if ($request->isMethod('post')) {
        $format = $request->input('fileformate');  // Check selected format (CSV/PDF)

        // Fetch sales data based on filters (add your filter logic here if needed)
        $salesData = DB::table('sales')
            ->join('deliveryboys', 'sales.driver_id', '=', 'deliveryboys.id')
            ->join('users', 'sales.user_id', '=', 'users.id')
            ->join('categories', 'sales.category_id', '=', 'categories.id')
            ->select('sales.*', 'deliveryboys.name as driver_name', 'users.name as user_name', 'categories.name as category_name')
            ->get();

        if ($format == 'CSV') {
            return $this->generateCSV($salesData);
        }

        if ($format == 'PDF') {
            return $this->generatePDF($salesData);
        }
    }

    return view('admin.sales.index', compact('drivers', 'customers', 'categorys'));
}
public function salesaddnew(Request $request)
{
    // Get dropdown data for initial page load
    $drivers = Deliveryboy::select('id', 'name', 'email', 'phone', 'dob', 'complete_order', 'status')->get();
    $customers = User::where('role', 'appuser')->get();
    $categorys = categorys::where('status', '!=', '2')->get();

    // If POST request (form submitted)
    if ($request->isMethod('post')) {
        $format = $request->input('fileformate');

        // Fetch sales data based on filters
       /* $salesData = DB::table('orderlist')
            ->join('deliveryboys', 'orderlist.assignorder', '=', 'deliveryboys.id')
            ->join('users', 'orderlist.u_id', '=', 'users.id')
            ->join('categorys', 'orderlist.c_id', '=', 'categorys.id')
            ->select(
                'orderlist.id',
                'orderlist.orderid',
                'orderlist.totalamount',
                'deliveryboys.name as driver_name',
                'users.name as user_name',
                'categorys.name as category_name',
                'orderlist.created_at'
            )
            ->get();*/
      $query = DB::table('orderlist')
    ->leftJoin('orderdetails', 'orderlist.id', '=', 'orderdetails.or_id')
    ->leftJoin('product', 'orderdetails.p_id', '=', 'product.id')
    ->leftJoin('categorys', 'product.c_id', '=', 'categorys.id')
    ->leftjoin('deliveryboys', 'orderlist.assignorder', '=', 'deliveryboys.id')
    ->leftjoin('users', 'orderlist.c_id', '=', 'users.id')
    ->leftjoin('store', 'orderlist.store_id', '=', 'store.id')
    ->select(
        'orderlist.id',
        'orderlist.orderid',
        'orderlist.totalamount',
        'orderlist.payment_method',
        'deliveryboys.name as driver_name',
        'deliveryboys.email as driver_email',
        'deliveryboys.phone as driver_phone',
        'users.name as user_name',
        'users.email as user_email',
        'users.contact_no as user_phone',
        'categorys.name as category_name', // 👈 category name here
        'store.name as storename',
        'orderlist.created_at'
    );

if ($request->filled('salesstore')) {
    $query->where('orderlist.store_id', $request->salesstore);
}

if ($request->filled('selectdriver')) {
    $query->where('deliveryboys.name', $request->selectdriver);
}

if ($request->filled('selectuser')) {
    $query->where('users.name', $request->selectuser);
}


if ($request->filled('selectdate')) {
    $dates = explode(' to ', $request->selectdate); // or ' to ', depending on your picker

    if (count($dates) > 1) {
        $startDate = date('Y-m-d 00:00:00', strtotime(trim($dates[0])));
        $endDate   = date('Y-m-d 23:59:59', strtotime(trim($dates[1])));
        $query->whereBetween('orderlist.created_at', [$startDate, $endDate]);
    } else {
        $date = date('Y-m-d', strtotime(trim($dates[0])));
        $query->whereDate('orderlist.created_at', $date);
    }
}

$salesData = $query->get();


        // Check format and export
        if ($format == 'CSV') {
            return $this->generateCSV($salesData);
        } elseif ($format == 'PDF') {
            return $this->generatePDF($salesData);
        } else {
            return back()->with('error', 'Invalid file format selected');
        }
    }

    // Default: show the page
    return view('admin.sales.index', compact('drivers', 'customers', 'categorys'));
}
// Generate CSV Report
protected function generateCSV($data)
{

    $filename = 'sales_report_' . date('Y-m-d_His') . '.csv';
    $headers = [
        'Content-Type' => 'text/csv',
        'Content-Disposition' => "attachment; filename=\"$filename\"",
    ];

    $columns = ['Order No','Store Name','Driver Name','Driver Email','Driver Phone','User Name','User Email','User Phone','Date','Category','Payment Method','Amount','Admin Commission'];

    $callback = function () use ($data, $columns) {
        $file = fopen('php://output', 'w');
        fputcsv($file, $columns);

        foreach ($data as $row) {
            fputcsv($file, [
                $row->orderid ?? '',
                $row->storename ?? '',
                $row->driver_name ?? '',
                $row->driver_email ?? '',
                $row->driver_phone ?? '',
                $row->user_name ?? '',
                $row->user_email ?? '',
                $row->user_phone ?? '',
                $row->created_at ?? '',
                $row->category_name ?? '',
                $row->payment_method ?? '',
                $row->totalamount ?? '',
                $row->admin_commission ?? '',
            ]);
        }
        fclose($file);
    };

    return Response::stream($callback, 200, $headers);
}
     public function googlemapsadd()
    {
        return view('admin.googlemaps.add');
    }
    public function googlemapscreate(Request $request)
    {


        $googlemaps = googlemaps::create([
            'name' => $request->get('name'),
            'key' => $request->get('key'),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return redirect()->route('admin.googlemaps.add')->with('alert-success', 'General settings created successfully.');
    }
     public function googlemapsedit($id)
    {
        $googlemaps = googlemaps::where('id', $id)->first();

        return view('admin.googlemaps.add', compact('googlemaps'));
        exit();
    }
    public function googlemapseditadmin(Request $request)
        {
            $id = request()->get('googlemapsid');

            $googlemaps = [
            'name' => $request->get('name'),
            'key' => $request->get('key'),

            'updated_at' => now(),
        ];



        googlemaps::where('id', $id)->update($googlemaps);

       return redirect()->back()->with('alert-success', 'Google maps updated successfully.');
    }
    public function razorpaypayedit(Request $request)
        {
            $id = request()->get('razorpayid');

            $razorpaydeta = [
            'key_id' => $request->get('keyid'),
            'key_secret' => $request->get('keySecret'),
        ];
        DB::table('razorpay')->where('id', $id)->update($razorpaydeta);

       return redirect()->back()->with('alert-success', 'Google maps updated successfully.');
    }

protected function generatePDF($salesData)
{
    $pdf = PDF::loadView('admin.sales.report_pdf', ['sales' => $salesData]);
    return $pdf->download('sales_report_' . date('Y-m-d_His') . '.pdf');
}


    public function deliveryDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            Deliveryboy::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Drivers deleted successfully.');
    }
    public function orderlistDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            orderlist::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Drivers deleted successfully.');
    }
    public function productlistDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            product::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Drivers deleted successfully.');
    }
    public function itemslistDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            Items::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Drivers deleted successfully.');
    }
    public function categoryDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            categorys::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Drivers deleted successfully.');
    }
    public function customersDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            User::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Drivers deleted successfully.');
    }
    public function sliderDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            sliders::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Drivers deleted successfully.');
    }

    public function usersDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            User::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Drivers deleted successfully.');
    }

    public function paymentsDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            Receive::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Drivers deleted successfully.');
    }

    //notification

    public function noti_index()
    {
        if (request()->ajax()) {
            $notifications = Notification::select('id', 'title', 'body', 'image_url', 'created_at', 'updated_at')->get();
            return view('admin.notification.index_ajax', compact('notifications'));
        } else {
            return view('admin.notification.index');
        }
    }

    // Show the add notification form
    public function noti_add()
    {
        return view('admin.notification.add');
    }

    // Store new notification in the database and send FCM notification
   /* public function noti_create(Request $request)
    {
        // Validate input
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'body' => 'required',
            'image_url' => 'nullable'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        // Create notification
        $notification = Notification::create([
            'title' => $request->get('title'),
            'body' => $request->get('body'),
            'image_url' => $request->get('image_url'),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Retrieve all device tokens
        $firebaseTokens = User::whereNotNull('device_token')->pluck('device_token')->all();

        // Send notification to each token
        $sendSuccess = true; // Track if notifications were sent successfully
        foreach ($firebaseTokens as $token) {
            if (!empty($token)) {
                $response = $this->sendFCMNotification($notification->title, $notification->body, $notification->image_url, $token);
                // Optional: Log the response for debugging
                // Log::info($response);
                if (!$response) {
                    $sendSuccess = false; // Set to false if any notification fails
                }
            }
        }

        // Check if creation and sending was successful
        if ($sendSuccess) {
            return redirect()->route('admin.notification.index')->with('alert-success', 'Notification created and sent successfully.');
        } else {
            return redirect()->back()->with('alert-danger', 'Failed to send some notifications. Please try again.');
        }
    }
*/
    // Delete notification by ID
    public function noti_delete($id)
    {
        $notification = Notification::find($id);
        if ($notification) {
            Notification::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['Notification successfully deleted.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['The notification could not be deleted. Try again.'], '', 500);
        }
    }

    // Send FCM Notification
    public function noti_create(Request $request)
{
    // Validate input
    $validator = Validator::make($request->all(), [
        'title' => 'required',
        'body' => 'required',
        'image_url' => 'nullable'
    ]);

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    // Create notification
    $notification = Notification::create([
        'title' => $request->get('title'),
        'body' => $request->get('body'),
        'image_url' => $request->get('image_url'),
        'created_at' => now(),
        'updated_at' => now(),
    ]);

    // Retrieve all device tokens
    $firebaseTokens = User::whereNotNull('device_token')->pluck('device_token')->all();

    // Send notification to each token
    $sendSuccess = true;
    foreach ($firebaseTokens as $token) {
        if (!empty($token)) {
            $response = $this->sendFCMNotification($notification->title, $notification->body, $notification->image_url, $token);
            $responseData = json_decode($response, true);

            // Check if token is unregistered and remove it if necessary
            if (isset($responseData['error']['details'][0]['errorCode']) && $responseData['error']['details'][0]['errorCode'] == 'UNREGISTERED') {
                User::where('device_token', $token)->update(['device_token' => null]);
            } elseif (!$response) {
                $sendSuccess = false;
            }
        }
    }

    if ($sendSuccess) {
        return redirect()->route('admin.notification.index')->with('alert-success', 'Notification created and sent successfully.');
    } else {
        return redirect()->back()->with('alert-danger', 'Failed to send some notifications. Please try again.');
    }
}

private function sendFCMNotification($title, $body, $image, $token)
{
    $url = 'https://fcm.googleapis.com/v1/projects/nearbasket-463c0/messages:send';
    $accessToken = $this->getAccessToken();

    $data = [
        'message' => [
            'token' => $token,
            'notification' => [
                'title' => $title,
                'body' => $body,
                'image' => $image,

            ],
            'data' => [
                'title' => $title,
                'body' => $body,
                'image' => $image
            ],
            'android' => [
                'notification' => [
                    'sound' => 'default'
                ]
            ],
            'apns' => [
                'payload' => [
                    'aps' => [
                        'sound' => 'default'
                    ]
                ]
            ]
        ]
    ];

    $headers = [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    $result = curl_exec($ch);
    curl_close($ch);

    return $result;
}
 //notification
      public function notificationlistDelete(Request $request)
    {
        $ids = $request->input('delete_ids', []);
        if (!empty($ids)) {
            Notification::whereIn('id', $ids)->delete();
        }
        return redirect()->back()->with('success', 'Selected Notification deleted successfully.');
    }
private function getAccessToken()
{
    $serviceAccount = json_decode(file_get_contents('https://iappstack.com/NearBasket/nearbasket-463c0-firebase-adminsdk-fbsvc-d2ef2cfb9d.json'), true);
    $now = time();
    $token = [
        "iss" => $serviceAccount['client_email'],
        "scope" => "https://www.googleapis.com/auth/firebase.messaging",
        "aud" => "https://oauth2.googleapis.com/token",
        "iat" => $now,
        "exp" => $now + 3600
    ];

    $jwt = JWT::encode($token, $serviceAccount['private_key'], 'RS256');

    $client = new Client();
    $response = $client->post('https://oauth2.googleapis.com/token', [
        'form_params' => [
            'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
            'assertion' => $jwt
        ]
    ]);

    $json = json_decode((string) $response->getBody(), true);
    return $json['access_token'];
}

public function getNotificationCount()
{
    $notificationCount = DB::table('orderlist')->where('status', '=', 1)->count();
    return response()->json(['count' => $notificationCount]);
}

// public function markAsViewed(Request $request)
// {
//     $orderId = $request->order_id;
//     DB::table('orderlist')
//         ->where('id', $orderId)
//         ->where('status', 1)
//         ->update(['status' => 2]);

//     $newNotificationCount = DB::table('orderlist')->where('status', 1)->count();

//     return response()->json(['newCount' => $newNotificationCount]);
// }

public function markAsViewed(Request $request)
{
    $orderIds = $request->order_ids;

    DB::table('orderlist')
        ->whereIn('id', $orderIds)
        ->where('status', 1)
        ->update(['status' => 2]);

    $newNotificationCount = DB::table('orderlist')
        ->where('status', 1)
        ->count();

    return response()->json([
        'success' => true,
        'newCount' => $newNotificationCount
    ]);
}


/*public function getOrders()
    {
       // $orders = DB::table('orderlist')->where('status', 1)->get();

       $orders = DB::table('orderlist as o')
        ->leftJoin('addressdetails as a', 'a.id', '=', 'o.address_id')
        ->leftJoin('orderdetails as od', 'od.or_id', '=', 'o.id')
        ->where('o.status', 1)
        ->get();

        return response()->json(['orders' => $orders]);
    }*/
    public function getOrders()
{
    // 1️⃣ Orders + Address (ONLY order fields)
    $orders = DB::table('orderlist as o')
        ->leftJoin('addressdetails as a', 'a.id', '=', 'o.address_id')
        ->where('o.status', 1)
        ->select(
            'o.id as order_id',
            'o.orderid',
            'o.c_id',
            'o.u_id',
            'o.orderdate',
            'o.totalamount',
            'o.delivereddate',
            'o.ordertax',
            'o.payment_method',
            'o.price_before_tax',
            'o.discount',
            'o.status',
            'o.assignorder',
            'o.driver_status',
            'o.orderotp',
            'o.latitude',
            'o.longitude',
            'o.promocode_id',
            'a.address1',
            'a.address2',
            'a.lat',
            'a.long',
            'a.floor',
            'a.landmart',
            'a.location_tag',
        )
        ->get();

    if ($orders->isEmpty()) {
        return response()->json(['status' => true, 'orders' => []]);
    }

    // 2️⃣ Collect ORDER IDs
    $orderIds = $orders->pluck('order_id')->toArray();

    // 3️⃣ Get products (ALIAS EVERYTHING)
    $orderProducts = DB::table('orderdetails as od')
        ->leftJoin('product as p', 'p.id', '=', 'od.p_id')
        ->whereIn('od.or_id', $orderIds)
        ->select(
            'od.or_id as order_id',
            'od.id as order_detail_id',
            'od.quantity',
            'od.p_id',
            'od.instruction',
            'od.orderprices',
            'p.id as product_id',
            'p.producttype',
            'p.productname',
            'p.productdetails',
            'p.prices',
            'p.total_qty',
            'p.discount_price',
            'p.status'
        )
        ->get()
        ->groupBy('order_id');

    // 4️⃣ Attach products (SAFE)
    foreach ($orders as $order) {
        $order->products = $orderProducts->get($order->order_id, []);
    }

    return response()->json([
        'status' => true,
        'orders' => $orders
    ]);
}





    public function markAsVieweds(Request $request)
{
    $orderIds = $request->order_ids;

    if (!empty($orderIds)) {
        DB::table('orderlist')
            ->whereIn('id', $orderIds)
            ->where('status', 1) // Only update if still "new"
            ->update(['status' => 2]);
    }

    $newNotificationCount = DB::table('orderlist')->where('status', 1)->count();

    return response()->json(['newCount' => $newNotificationCount]);
}

    public function totoalorders()
    {
        $orderss = DB::table('orderlist')->where('status', 1)->get();
        return response()->json(['orders' => $orderss]);
    }

    public function orderreject()
    {
        $orderreject = DB::table('orderlist')->where('status', 6)->get();
        return response()->json(['orders' => $orderreject]);
    }

    public function markAsViewedss(Request $request)
{
    $orderIds = $request->order_id;

    if (!empty($orderIds)) {
        DB::table('orderlist')
            ->where('id', $orderIds)
            ->where('status', 6)
            ->update(['status' => 4, 'assignorder' => '']);
    }

    return response()->json(['status' => 'success']);
}

    public function paymentlist()
    {
        if (request()->ajax()) {
            $sliderslist = Receive::select('id', 'driver','amount','note','created_at')->orderByRaw('STR_TO_DATE(created_at, "%Y-%m-%d %H:%i:%s") DESC')->get();

            return view('admin.receive.index_ajax', compact('sliderslist'));
        } else {
            return view('admin.receive.index');
        }
    }

    public function paymentadd()
    {
        $drivers = DB::table('deliveryboys')->get();
        return view('admin.receive.add', compact('drivers'));
    }

    public function getDriverAmount(Request $request)
{
    $serviceId = $request->id;

    $orderlist = Wallethistory::where('deliveryboyid', $serviceId)->orderby('created_at','desc')->get();

    $totalBalance = 0;

    foreach ($orderlist as $order) {
        $adjustedBalance = $order->credit - $order->debit;
        $totalBalance += $adjustedBalance;
    }

        return response()->json([
            'totalamount' => (int) $totalBalance
        ]);
}

    public function paymentcreate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'driver' => '', // Ensure driver exists in deliveryboys table
            'amount' => '', // Amount should be a positive number
            'note' => '', // Note is optional
        ], [
            'driver.required' => 'The driver field is required.',
            'amount.required' => 'The amount field is required.',
            'amount.numeric' => 'The amount must be a valid number.',
            'amount.min' => 'The amount must be greater than zero.',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $balance = $request->credit - $request->amount;
        // Insert into database
        $product = Receive::create([
            'driver' => $request->driver,
            'amount' => $request->amount,
            'note' => $request->note,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $products = Wallethistory::create([
            'deliveryboyid' => $request->driver,
            'orderid' => 'Imart super market',
            'credit' => 0,
            'debit' => $request->amount,
            'balance' => $balance,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Redirect based on the result
        if ($product && $products) {
            return redirect()->route('admin.payment.index')->with('alert-success', 'Payment created successfully.');
        } else {
            return redirect()->back()->with('alert-danger', 'Payment could not be created. Please try again.');
        }
    }


  public function paymentdelete($id)
    {
        $role = Receive::select('id')->where('id', $id)->first();

        if ($role->delete()) {
            $this->CommonHelper->sendJsonResponse(false, [], ['Payment receive deleted successfully.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['No se pudo eliminar el plan. Inténtalo de nuevo.'], '', 500);
        }
    }
    public function privacypolicy()
    {
        return view('privcy' );
    }
    public function updateDeliveryBoy(Request $request)
{
    //dd($request->all());
    $deliveryBoy = Deliveryboy::findOrFail($request->id);

    // Validate inputs if needed
    $request->validate([
        'driving_license' => 'nullable',
        'rc_book' => 'nullable',
        'adhar_image' => 'nullable',
    ]);

    // Path to store images
    $imagePath = public_path('drivers');

    // Update Driving License
    if ($request->hasFile('driving_license')) {
        // Delete old file if exists
        if ($deliveryBoy->driving_license && file_exists($imagePath.'/'.$deliveryBoy->driving_license)) {
            unlink($imagePath.'/'.$deliveryBoy->driving_license);
        }

        $drivingLicense = $request->file('driving_license');
        $drivingLicenseName = 'driving_license-' . time() . '.' . $drivingLicense->getClientOriginalExtension();
        $drivingLicense->move($imagePath, $drivingLicenseName);
        $deliveryBoy->driving_license = $drivingLicenseName;
    }

    // Update RC Book
    if ($request->hasFile('rc_book')) {
        // Delete old file if exists
        if ($deliveryBoy->rc_book && file_exists($imagePath.'/'.$deliveryBoy->rc_book)) {
            unlink($imagePath.'/'.$deliveryBoy->rc_book);
        }

        $rcBook = $request->file('rc_book');
        $rcBookName = 'rc_book-' . time() . '.' . $rcBook->getClientOriginalExtension();
        $rcBook->move($imagePath, $rcBookName);
        $deliveryBoy->rc_book = $rcBookName;
    }

    // Update Aadhar Card
    if ($request->hasFile('adhar_image')) {
        // Delete old file if exists
        if ($deliveryBoy->adhar_image && file_exists($imagePath.'/'.$deliveryBoy->adhar_image)) {
            unlink($imagePath.'/'.$deliveryBoy->adhar_image);
        }

        $adharImage = $request->file('adhar_image');
        $adharCardName = 'adhar_image-' . time() . '.' . $adharImage->getClientOriginalExtension();
        $adharImage->move($imagePath, $adharCardName);
        $deliveryBoy->adhar_image = $adharCardName;
    }

    // Save changes to database
    $deliveryBoy->save();

    return response()->json([
        'success' => true,
        //'delivery' => $deliveryBoy
    ]);
    //return redirect()->route('admin.deliveryboy.index')->with('alert-success', 'Delivery boy updated successfully.');

}
public function appreport()
    {
        if (request()->ajax()) {
            $roles = Report::select('id', 'store_id','user_id', 'status', 'created_at', 'updated_at','image','type','reasone','description')
            ->where('type', 'user')->get();

            return view('admin.appreport.index_ajax', compact('roles'));
        } else {
            return view('admin.appreport.index');
        }
    }
    public function appreportdlt($id)
    {
        $role = Report::select('id')->where($id);
        if (isset($role)) {
            Report::where('id', $id)->delete();
            $this->CommonHelper->sendJsonResponse(false, [], ['Appreport successfully deleted.'], '');
        } else {
            $this->CommonHelper->sendJsonResponse(true, [], ['The plan could not be deleted. Try again.'], '', 500);
        }
    }
    public function updateStatus(Request $request)
    {
        $id = $request->input('id');
        $status = $request->input('status');

        DB::table('tbl_report')->where('id', $id)->update([
            'status' => $status,
            'updated_at' => now()
        ]);

        return response()->json(['message' => 'Status updated successfully']);
    }
}






