<?php

namespace App\Http\Controllers;

use Illuminate\Contracts\Filesystem\Filesystem;
use League\Glide\Responses\LaravelResponseFactory;
use League\Glide\ServerFactory;
use Validator;
use App\Models\Media;
use App\Models\User;

class MediaController extends Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function showImages(Filesystem $filesystem, $path)
    {
        $server = ServerFactory::create([
            'response' => new LaravelResponseFactory(app('request')),
            'source' => public_path('media'),
            'cache' => public_path('media'),
            'cache_path_prefix' => '.cache',
            'base_url' => '/media',
        ]);

        return $server->getImageResponse($path, request()->all());
    }
}