<?php

namespace App\Http\Controllers\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\customer;
use App\Models\product;
use App\Models\orderlist;

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    
    public function index()
    {

        $users = User::select('id', 'name','lastname','email', 'contact_no', 'created_at')
            ->orderBy('id', 'desc')
            ->where('status', '!=', '2')
            ->limit(7)
            ->get();



        $total_users = User::where('status', '!=', '2')->count();

       $total_order = orderlist::where('status', '!=', '2')->count();
       $total_product = product::where('status', '!=', '2')->count();

        return view('admin.dashboard', compact('users', 'total_users','total_order','total_product'));
    }
}
