<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $__env->yieldContent('title'); ?><?php echo e(' | ' . env('APP_NAME')); ?></title>

    <?php $__env->startSection('stylesheets'); ?>
        <!-- Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
        <!-- Icons -->
        <link rel="stylesheet" href="<?php echo e(asset('admin_template/assets/vendor/nucleo/css/nucleo.css')); ?>" type="text/css">
        <link rel="stylesheet" href="<?php echo e(asset('admin_template/assets/vendor/@fortawesome/fontawesome-free/css/all.min.css')); ?>" type="text/css">
        <!-- Argon CSS -->
        <link rel="stylesheet" href="<?php echo e(asset('admin_template/css/dashboard.css')); ?>" type="text/css">
        <!-- Custom style -->
        <link rel="stylesheet" href="<?php echo e(asset('css/app-custom.css')); ?>">
        <!-- Toastr -->
        <link rel="stylesheet" href="<?php echo e(asset('admin_template/plugins/toastr/toastr.min.css')); ?>">
    <?php echo $__env->yieldSection(); ?>

</head>


<body>
    <!-- Sidenav -->
    <?php echo $__env->make('layouts.admin.left_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Main content -->
    <div class="main-content">
        <!-- Topnav -->
        <?php echo $__env->make('layouts.admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Header -->
        <div class="header bg-primary pb-6">
            <?php $__env->startSection('header'); ?>
            <?php echo $__env->yieldSection(); ?>
        </div>
        <!-- Page content -->
        <div class="container-fluid mt--6">

            <?php $__env->startSection('content'); ?>
            <?php echo $__env->yieldSection(); ?>
            
            <!-- Footer -->
            <?php echo $__env->make('layouts.admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>

    <?php $__env->startSection('scripts'); ?>
        <!-- Core -->
        <script src="<?php echo e(asset('admin_template/assets/vendor/jquery/dist/jquery.min.js')); ?>"></script>
        <script src="<?php echo e(asset('admin_template/assets/vendor/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('admin_template/assets/vendor/js-cookie/js.cookie.js')); ?>"></script>
        <script src="<?php echo e(asset('admin_template/assets/vendor/jquery.scrollbar/jquery.scrollbar.min.js')); ?>"></script>
        <script src="<?php echo e(asset('admin_template/assets/vendor/jquery-scroll-lock/dist/jquery-scrollLock.min.js')); ?>"></script>
        <!-- Argon JS -->
        <script src="<?php echo e(asset('admin_template/assets/js/dashboard.js?v=1.2.0')); ?>"></script>
        <!-- Toastr -->
        <script src="<?php echo e(asset('admin_template/plugins/toastr/toastr.min.js')); ?>"></script>
        <!-- Jquery Validate -->
        <script src="<?php echo e(asset('admin_template/plugins/jquery-validate/jquery.validate.min.js')); ?>"></script>
        <!-- Custom script -->
        <script src="<?php echo e(asset('js/app-custom.js')); ?>"></script>
    <?php echo $__env->yieldSection(); ?>
</body>

</html><?php /**PATH C:\xampp\htdocs\silsa\resources\views/layouts/admin/main.blade.php ENDPATH**/ ?>