<?php



use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LanguageController;

use App\Http\Controllers\ApplicationController;
use App\Http\Controllers\UserProfileController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\MediaController;

use App\Http\Controllers\AuthenticationController;
use App\Http\Controllers\MiscController;
use App\Http\Controllers\CardController;
use App\Http\Controllers\CssController;
use App\Http\Controllers\BasicUiController;
use App\Http\Controllers\AdvanceUiController;
use App\Http\Controllers\ExtraComponentsController;
use App\Http\Controllers\BasicTableController;
use App\Http\Controllers\DataTableController;
use App\Http\Controllers\FormController;
use App\Http\Controllers\ChartController;
use App\Http\Controllers\AdminuserController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\UsersController;
use Spatie\MediaLibrary\HasMedia\HasMediaTrait;
use App\Models\Deliveryboy;
use App\Http\Controllers\Auth\ForgotPasswordController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// to serve media images with glide
Route::get('/media_images/{path?}', [MediaController::class,'showImages'])->where('path', '.*');
Route::get('/media/get_images/{collection_name}/{id}', [MediaController::class,'getImages']);

//Route::get('/home', function () {
 //    return view('welcome');
//});

//Route::get('home/{id?}', 'Auth\LoginController@homedetails')->name('homedetails');

// authentication routes
 
Route::get('/', [LoginController::class, 'showLoginForm'])->name('login');
Route::get('login',[LoginController::class, 'showLoginForm'])->name('login');
Route::post('adminlogin',[RoleController::class, 'adminlogin'])->name('adminlogin');
Route::post('logout',[LoginController::class, 'logout'])->name('logout');
Route::Post('imagesdelete',[RoleController::class, 'imagesdelete'])->name('imagesdelete');
   Route::get('privacypolicy', [RoleController::class,'privacypolicy'])->name('privacypolicy');
Route::group([
    'prefix' => 'admin',
    'as' => 'admin.',
    ], function () {
      
        // dashboard routek
       Route::get('/drivers', [RoleController::class,'drivers'])->name('drivers.index');
       Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
      Route::delete('/order/delete/{id}', [DashboardController::class,'orderdelete'])->name('orderlist.delete');   
      

//notification route

Route::get('/notification', [RoleController::class,'noti_index'])->name('notification.index');
Route::get('/notification/add', [RoleController::class,'noti_add'])->name('notification.add');
Route::post('/notification/create', [RoleController::class,'noti_create'])->name('notification.create');
Route::delete('/notification/delete/{id}', [RoleController::class,'noti_delete'])->name('notification.delete');
/*Route::get('/roleedit/{id?}', [RoleController::class,'roleedit'])->name('roleedit');
Route::post('roleeditadmin', [RoleController::class,'roleeditadmin'])->name('roleeditadmin');*/
  

        // users routes
        Route::get('/users', [UsersController::class, 'index'])->name('users.index');
        Route::post('/useractive/{id?}', [UsersController::class, 'useractive'])->name('user.deactive');
        Route::get('/user/add', [UsersController::class, 'add'])->name('user.add');
        Route::post('/user/create', [UsersController::class, 'create'])->name('users.create');
        Route::get('/useredit/{id?}', [UsersController::class, 'useredit'])->name('useredit');
        Route::post('usereditadmin', [UsersController::class, 'usereditadmin'])->name('usereditadmin');
        Route::delete('/user/delete/{id}', [UsersController::class, 'delete'])->name('user.delete');
     

       
     //maincategory list
            Route::get('/maincategorys', [UsersController::class,'maincategorysindex'])->name('maincategorys.index');
            Route::post('/maincategorysactive/{id?}', [UsersController::class, 'maincategorysactive'])->name('maincategorys.deactive');
            Route::get('/maincategorys/add', [UsersController::class,'maincategorysadd'])->name('maincategorys.add');
            Route::post('/maincategorys/add', [UsersController::class,'maincategoryscreate'])->name('maincategorys.add');
            Route::get('maincategorysedit/{id?}', [UsersController::class,'maincategorysedit'])->name('maincategorysedit');
            Route::post('maincategoryseditadmin', [UsersController::class,'maincategoryseditadmin'])->name('maincategoryseditadmin');
            Route::delete('/maincategorys/delete/{id}', [UsersController::class,'maincategorysdelete'])->name('maincategorys.delete');
                Route::post('/maincategory/bulk-delete', [RoleController::class, 'maincategoryDelete'])->name('maincategory.bulkDelete');



                //feedbackoptions list
            Route::get('/feedbackoptions', [UsersController::class,'feedbackoptionsindex'])->name('feedbackoptions.index');
            Route::post('/feedbackoptionsactive/{id?}', [UsersController::class, 'feedbackoptionsactive'])->name('feedbackoptions.deactive');
            Route::get('/feedbackoptions/add', [UsersController::class,'feedbackoptionsadd'])->name('feedbackoptions.add');
            Route::post('/feedbackoptions/add', [UsersController::class,'feedbackoptionscreate'])->name('feedbackoptions.add');
            Route::get('feedbackoptionsedit/{id?}', [UsersController::class,'feedbackoptionssedit'])->name('feedbackoptionssedit');
            Route::post('feedbackoptionseditadmin', [UsersController::class,'feedbackoptionseditadmin'])->name('feedbackoptionseditadmin');
            Route::delete('/feedbackoptions/delete/{id}', [UsersController::class,'feedbackoptionsdelete'])->name('feedbackoptions.delete');
                Route::post('/feedbackoptions/bulk-delete', [RoleController::class, 'feedbackoptionsDelete'])->name('feedbackoptions.bulkDelete');
        

      	 Route::get('/settings', [UsersController::class,'settingsindex'])->name('settings.index');
        Route::delete('/settings/delete/{id}', [UsersController::class,'settingsdelete'])->name('settings.delete');
        Route::get('settingsedit/{id?}', [UsersController::class,'settingsedit'])->name('settingsedit');
        Route::post('settingseditadmin', [UsersController::class,'settingseditadmin'])->name('settingseditadmin');
        
         // privacypolicy routes
        
      
        // plan routes
        Route::get('/role', [RoleController::class,'index'])->name('role.index');
        Route::get('/role/add', [RoleController::class,'add'])->name('role.add');
        Route::post('/role/add', [RoleController::class,'create'])->name('role.create');
        Route::delete('/role/delete/{id}', [RoleController::class,'delete'])->name('role.delete');
        Route::get('/roleedit/{id?}', [RoleController::class,'roleedit'])->name('roleedit');
        Route::post('roleeditadmin', [RoleController::class,'roleeditadmin'])->name('roleeditadmin');

        //   routes
        Route::get('/product', [RoleController::class,'productlist'])->name('product.index');
        Route::post('/productsactive/{id?}', [RoleController::class, 'productsactive'])->name('products.deactive');
        Route::get('/product/add', [RoleController::class,'productadd'])->name('product.add');
        Route::post('/product/create', [RoleController::class,'productcreate'])->name('product.create');
        Route::delete('/product/delete/{id}', [RoleController::class,'productdelete'])->name('product.delete');
        Route::get('/productedit/{id?}', [RoleController::class,'productedit'])->name('productedit');
        Route::post('producteditadmin', [RoleController::class,'producteditadmin'])->name('producteditadmin');
        Route::get('/appreport', [RoleController::class, 'appreport'])->name('appreport');
         Route::delete('/appreport/delete/{id}', [RoleController::class,'appreportdlt'])->name('appreport.delete');
          Route::post('/update-status', [RoleController::class, 'updateStatus'])->name('update-status');
           Route::post('/get-productcategory', [RoleController::class, 'getproductCategory'])->name('getproductCategory');  


         // store routes
         Route::get('/store', [RoleController::class,'storelist'])->name('store.index');
         Route::get('/store/add', [RoleController::class,'storeadd'])->name('store.add');
         Route::post('/store/create', [RoleController::class,'storecreate'])->name('store.create');
         Route::get('/storeedit/{id?}', [RoleController::class,'storeedit'])->name('storeedit');
         Route::post('storeeditadmin', [RoleController::class,'storeeditadmin'])->name('storeeditadmin');
         Route::delete('/store/delete/{id}', [RoleController::class,'storedelete'])->name('store.delete');
        Route::post('/get-category', [RoleController::class, 'getCategory'])->name('getCategory'); 
        

          // vendor routes
          Route::get('/vendor', [RoleController::class,'vendorlist'])->name('vendor.index');
          Route::get('/vendor/add', [RoleController::class,'vendoradd'])->name('vendor.add');
          Route::post('/vendor/create', [RoleController::class,'vendorcreate'])->name('vendor.create');
          Route::get('/vendoredit/{id?}', [RoleController::class,'vendoredit'])->name('vendoredit');
          Route::post('vendoreditadmin', [RoleController::class,'vendoreditadmin'])->name('vendoreditadmin');
          Route::delete('/vendor/delete/{id}', [RoleController::class,'vendordelete'])->name('vendor.delete');

        // customer routes
        Route::get('/customer', [RoleController::class,'customerlist'])->name('customer.index');
        Route::post('/customeractive/{id?}', [RoleController::class, 'customeractive'])->name('customer.deactive');
        Route::get('/customer/add', [RoleController::class,'customeradd'])->name('customer.add');
        Route::post('/customer/create', [RoleController::class,'customercreate'])->name('customer.create');
        Route::delete('/customer/delete/{id}', [RoleController::class,'customerdelete'])->name('customer.delete');
        Route::get('/customeredit/{id?}', [RoleController::class,'customeredit'])->name('customeredit');
        Route::post('customereditadmin', [RoleController::class,'customereditadmin'])->name('customereditadmin');
        
        //category list
        Route::get('/categorys', [UsersController::class,'categorysindex'])->name('categorys.index');
        Route::post('/categorysactive/{id?}', [UsersController::class, 'categorysactive'])->name('categorys.deactive');
    Route::get('/categorys/add', [UsersController::class,'categorysadd'])->name('categorys.add');
    Route::post('/categorys/add', [UsersController::class,'categoryscreate'])->name('categorys.add');
    Route::get('categorysedit/{id?}', [UsersController::class,'categorysedit'])->name('categorysedit');
    Route::post('categoryseditadmin', [UsersController::class,'categoryseditadmin'])->name('categoryseditadmin');
    Route::delete('/categorys/delete/{id}', [UsersController::class,'categorysdelete'])->name('categorys.delete');

        //order list
        
        Route::get('/orderlist', [RoleController::class,'orderlist'])->name('orderlist.index');

        //Route::get('generateCsv',[RoleController::class,'generateCsv'])->name('download.csv');

        Route::delete('/order/delete/{id}', [RoleController::class,'orderdelete'])->name('orderlist.delete');
        Route::get('/orderlistedit/{id?}', [RoleController::class,'orderlistedit'])->name('orderlistedit');
        Route::post('ordereditadmin', [RoleController::class,'ordereditadmin'])->name('ordereditadmin');
        Route::get('/orderdetails/{id?}', [RoleController::class,'orderdetails'])->name('orderdetails');

        // sliders routes
        Route::get('/sliders', [RoleController::class,'sliderslist'])->name('sliders.index');
        Route::post('/slideractive/{id?}', [RoleController::class, 'slideractive'])->name('sliders.deactive');
        Route::get('/sliders/add', [RoleController::class,'slidersadd'])->name('sliders.add');
        Route::post('/sliders/create', [RoleController::class,'sliderscreate'])->name('sliders.create');
        Route::delete('/sliders/delete/{id}', [RoleController::class,'slidersdelete'])->name('sliders.delete');
        Route::get('/slidersedit/{id?}', [RoleController::class,'slidersedit'])->name('slidersedit');
        Route::post('sliderseditadmin', [RoleController::class,'sliderseditadmin'])->name('sliderseditadmin');
	    Route::get('exportcsv', [RoleController::class,'exportcsv'])->name('exportcsv');
       
    // payment receiver routes
    Route::get('/payment', [RoleController::class,'paymentlist'])->name('payment.index');
    Route::get('/payment/add', [RoleController::class,'paymentadd'])->name('payment.add');
    Route::post('/payment/create', [RoleController::class,'paymentcreate'])->name('payment.create');
    Route::delete('/payment/delete/{id}', [RoleController::class,'paymentdelete'])->name('payment.delete');
    Route::get('/paymentedit/{id?}', [RoleController::class,'paymentedit'])->name('paymentedit');
    Route::post('paymenteditadmin', [RoleController::class,'paymenteditadmin'])->name('paymenteditadmin');
	   
	   //promocode deatil 
        Route::get('/promocodes', [RoleController::class,'promocodesindex'])->name('promocodes.index');
        Route::post('/promocodesactive/{id?}', [RoleController::class, 'promocodesactive'])->name('promocodes.deactive');
    Route::get('/promocodes/add', [RoleController::class,'promocodesadd'])->name('promocodes.add');
    Route::post('/promocodes/add', [RoleController::class,'promocodescreate'])->name('promocodes.add');
    Route::get('promocodesedit/{id?}', [RoleController::class,'promocodesedit'])->name('promocodesedit');
    Route::post('promocodeseditadmin', [RoleController::class,'promocodeseditadmin'])->name('promocodeseditadmin');
    Route::delete('/promocodes/delete/{id}', [RoleController::class,'promocodesdelete'])->name('promocodes.delete');
	
	
	 //generalsettings 
    Route::get('/generalsettings', [RoleController::class,'generalsettingsindex'])->name('generalsettings.index');
    Route::get('/generalsettings/add', [RoleController::class,'generalsettingsadd'])->name('generalsettings.add');
    Route::post('/generalsettings/add', [RoleController::class,'generalsettingscreate'])->name('generalsettings.add');
    Route::get('generalsettingsedit/{id?}', [RoleController::class,'generalsettingsedit'])->name('generalsettingsedit');
    Route::get('generalsettingstheme/{id?}', [RoleController::class,'generalsettingstheme'])->name('generalsettingstheme');
    Route::post('generalsettingseditadmin', [RoleController::class,'generalsettingseditadmin'])->name('generalsettingseditadmin');
    Route::delete('/generalsettings/delete/{id}', [RoleController::class,'generalsettingsdelete'])->name('generalsettings.delete');
    Route::get('/admin/logo', [RoleController::class,'generalsettingslogo'])->name('generalsettings.logo');
       
    Route::get('/deliveryboy', [RoleController::class,'deliveryboyindex'])->name('deliveryboy.index');
    Route::post('/deliveryboyactive/{id?}', [RoleController::class, 'deliveryboyactive'])->name('deliveryboy.deactive');
    Route::get('/deliveryboy/add', [RoleController::class,'deliveryboyadd'])->name('deliveryboy.add');
    Route::post('/deliveryboy/add', [RoleController::class,'deliveryboycreate'])->name('deliveryboy.add');
    Route::get('deliveryboyedit/{id?}', [RoleController::class,'deliveryboyedit'])->name('deliveryboyedit');
    Route::post('deliveryboyeditadmin', [RoleController::class,'deliveryboyeditadmin'])->name('deliveryboyeditadmin');
    Route::get('/deliveryboydetails/{id?}', [RoleController::class,'deliveryboydetails'])->name('deliveryboydetails');
    Route::delete('/deliveryboy/delete/{id}', [RoleController::class,'deliveryboydelete'])->name('deliveryboy.delete');
    Route::post('deliveryboy/approve/{id}', [RoleController::class, 'driverapprove'])->name('deliveryboy.approve');

    Route::post('deliveryboyeditadmins', [RoleController::class, 'updateDeliveryBoy'])->name('deliveryboyeditadmins');
    Route::get('/get-driving-license-image/{id}', function ($id) {
        $delivery = Deliveryboy::findOrFail($id); // Assuming you're using the Delivery model
        $imageUrl = asset('/drivers/' . $delivery->driving_license); // Adjust the path as needed
    
        return response()->json(['imageUrl' => $imageUrl]);
    });


    Route::post('deliveryboy/approve/{id}', [RoleController::class, 'rcapprove'])->name('deliveryboy.approve');
    Route::post('deliveryboy/reject/{id}', [RoleController::class, 'rcreject'])->name('deliveryboy.reject');

    Route::post('deliveryboy/approves/{id}', [RoleController::class, 'rcapproves'])->name('deliveryboy.approves');
    Route::post('deliveryboy/rejects/{id}', [RoleController::class, 'rcrejects'])->name('deliveryboy.rejects');

    Route::post('deliveryboys/approveadhar/{id}', [RoleController::class, 'adharapprove'])->name('deliveryboys.approveadhar');
    Route::post('deliveryboys/rejectadhar/{id}', [RoleController::class, 'adharreject'])->name('deliveryboys.rejectadhar');

    Route::get('/approveddriver', [RoleController::class, 'approvedDrivers'])->name('approveddriver.index');
    Route::get('/pandingdriver', [RoleController::class, 'pendingDrivers'])->name('pandingdriver.index');

         //google maps
     Route::get('googlemapsedit/{id?}', [RoleController::class,'googlemapsedit'])->name('googlemapsedit');
    Route::get('/googlemaps/add', [RoleController::class,'googlemapsadd'])->name('googlemaps.add');
     Route::post('/googlemaps/add', [RoleController::class,'googlemapscreate'])->name('googlemaps.add');
    Route::post('googlemapseditadmin', [RoleController::class,'googlemapseditadmin'])->name('googlemapseditadmin');
    Route::post('razorpaypayedit', [RoleController::class,'razorpaypayedit'])->name('razorpaypayedit');
       
// settings
    Route::get('/settings', [RoleController::class,'settingsindex'])->name('settings.index');
    Route::get('/settings/add', [RoleController::class,'settingsadd'])->name('settings.add');
    Route::post('/settings/add', [RoleController::class,'settingscreate'])->name('settings.add');
    Route::get('settingsedit/{id?}', [RoleController::class,'settingsedit'])->name('settingsedit');
    Route::post('settingseditadmin', [RoleController::class,'settingseditadmin'])->name('settingseditadmin');
    Route::delete('/settings/delete/{id}', [RoleController::class,'settingsdelete'])->name('settings.delete');
  
//Email tamplete  generalsettings list
    Route::get('/tamplete', [RoleController::class,'tampleteindex'])->name('emailtamplete.index');
    Route::get('/tamplete/add', [RoleController::class,'tampleteadd'])->name('tamplete.add');
    Route::post('/tamplete/add', [RoleController::class,'tampletecreate'])->name('tamplete.add');
    Route::get('tampleteedit/{id?}', [RoleController::class,'tampleteedit'])->name('tampleteedit');
    Route::post('tampleteeditadmin', [RoleController::class,'tampleteeditadmin'])->name('tampleteeditadmin');
    Route::delete('/tamplete/delete/{id}', [RoleController::class,'tampletedelete'])->name('tamplete.delete');

    Route::get('/items', [RoleController::class,'itemsindex'])->name('items.index');
    Route::get('/items/add', [RoleController::class,'itemsadd'])->name('items.add');
    Route::post('/items/add', [RoleController::class,'itemscreate'])->name('items.add');
    Route::get('itemsedit/{id?}', [RoleController::class,'itemsedit'])->name('itemsedit');
    Route::post('itemseditadmin', [RoleController::class,'itemseditadmin'])->name('itemseditadmin');
    Route::delete('/items/delete/{id}', [RoleController::class,'itemsdelete'])->name('items.delete');

    Route::get('/items', [RoleController::class,'itemsindex'])->name('items.index');
    Route::get('/items/add', [RoleController::class,'itemsadd'])->name('items.add');
    Route::post('/items/add', [RoleController::class,'itemscreate'])->name('items.add');
    Route::get('itemsedit/{id?}', [RoleController::class,'itemsedit'])->name('itemsedit');
    Route::post('itemseditadmin', [RoleController::class,'itemseditadmin'])->name('itemseditadmin');
    Route::delete('/items/delete/{id}', [RoleController::class,'itemsdelete'])->name('items.delete');

    Route::get('/driversPayouts', [RoleController::class,'driversPayoutsindex'])->name('driversPayouts.index');
    Route::get('/driversPayout/{id?}', [RoleController::class,'driversPayoutindex'])->name('driversPayout.index');
    Route::get('/driversPayouts/add/{id}', [RoleController::class,'driversPayoutsadd'])->name('driversPayouts.add');
    Route::post('/driversPayouts/create', [RoleController::class,'driversPayoutscreate'])->name('driversPayouts.create');
    Route::get('driversPayoutsedit/{id?}', [RoleController::class,'driversPayoutsedit'])->name('driversPayout.driversPayoutsedit');
    Route::post('driversPayoutseditadmin', [RoleController::class,'driversPayoutseditadmin'])->name('driversPayoutseditadmin');
    Route::delete('/driversPayouts/delete/{id}', [RoleController::class,'driversPayoutsdelete'])->name('driversPayouts.delete');

    Route::get('/sales/add', [RoleController::class,'salesadd'])->name('sales.add');
     Route::post('salesaddnew', [RoleController::class,'salesaddnew'])->name('salesaddnew');

});
    Route::post('/promocodes/bulk-delete', [RoleController::class, 'bulkDelete'])->name('admin.promocodes.bulkDelete');
    Route::post('/delivery/bulk-delete', [RoleController::class, 'deliveryDelete'])->name('admin.delivery.bulkDelete');
    Route::post('/orderlist/bulk-delete', [RoleController::class, 'orderlistDelete'])->name('admin.orderlist.bulkDelete');
    Route::post('/product/bulk-delete', [RoleController::class, 'productlistDelete'])->name('admin.product.bulkDelete');
    Route::post('/items/bulk-delete', [RoleController::class, 'itemslistDelete'])->name('admin.items.bulkDelete');
    Route::post('/category/bulk-delete', [RoleController::class, 'categoryDelete'])->name('admin.category.bulkDelete');
    Route::post('/customers/bulk-delete', [RoleController::class, 'customersDelete'])->name('admin.customers.bulkDelete');
    Route::post('/slider/bulk-delete', [RoleController::class, 'sliderDelete'])->name('admin.slider.bulkDelete');
    Route::post('/users/bulk-delete', [RoleController::class, 'usersDelete'])->name('admin.users.bulkDelete');
    Route::post('/payments/bulk-delete', [RoleController::class, 'paymentsDelete'])->name('admin.payments.bulkDelete');
     Route::post('/notification/bulk-delete', [RoleController::class, 'notificationlistDelete'])->name('notification.bulkDelete');


    Route::get('/admin/notifications/count', [RoleController::class, 'getNotificationCount'])->name('admin.notifications.count');
    Route::post('/admin/order/mark-viewed', [RoleController::class, 'markAsViewed'])->name('order.markViewed');
    Route::get('/orders/get', [RoleController::class, 'getOrders'])->name('orders.get');
    Route::get('/admin/orderlist/{id}', [RoleController::class, 'markAsViewed'])->name('order.details');

    Route::get('/get-driver-amount', [RoleController::class, 'getDriverAmount'])->name('getDriverAmount');
    Route::get('/get-drivers-order', [RoleController::class, 'totoalorders'])->name('totoalorders');
    Route::post('/mark-as-viewed', [RoleController::class, 'markAsVieweds'])->name('markAsViewed');
    Route::get('/get-order-reject', [RoleController::class, 'orderreject'])->name('orderreject');
    Route::post('/mark-as-viewedss', [RoleController::class, 'markAsViewedss'])->name('markAsViewedss');


    //changepassword
    Route::get('/changepass', [ForgotPasswordController::class, 'getemail'])->name('password.email');
    Route::post('/oldpass', [ForgotPasswordController::class, 'changesendOtp'])->name('oldpass');
    Route::get('/new-password', [ForgotPasswordController::class, 'changepass'])->name('changepass');
    Route::post('/changepassword/update', [ForgotPasswordController::class, 'channgeupdatePassword'])->name('channgepassword.update');







