<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Apiv1Controller;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::post('/v1/login', [Apiv1Controller::class,'login']);
Route::post('/v1/settings', [Apiv1Controller::class,'settings']);
Route::post('/v1/signup', [Apiv1Controller::class,'register']);
Route::post('/v1/propertylist', [Apiv1Controller::class,'propertylist']);
Route::post('/v1/savepropertylist', [Apiv1Controller::class,'savepropertylist']);
Route::post('/v1/propertytypelist', [Apiv1Controller::class,'propertytypelist']);

Route::post('/v1/forgetPassword', [Apiv1Controller::class,'forgetPassword']);
Route::post('/v1/verify_account', [Apiv1Controller::class,'verify_account']);
Route::post('/v1/changePassword', [Apiv1Controller::class,'changePassword']);
Route::post('/v1/sendTestEmail', [Apiv1Controller::class,'sendTestEmail']);


Route::group(['middleware' => ['jwt.verify']], function() {

    Route::post('/v1/getprofile',[Apiv1Controller::class,'getprofile']);
    Route::post('/v1/editprofile', [Apiv1Controller::class,'editprofile']);
    Route::post('/v1/logout',[Apiv1Controller::class,'logout']);
    Route::post('/v1/categories', [Apiv1Controller::class,'categories']);
    Route::post('/v1/getgoals', [Apiv1Controller::class,'getgoals']);
    Route::post('/v1/addgoals', [Apiv1Controller::class,'addgoals']);
    Route::post('/v1/editgoals', [Apiv1Controller::class,'editgoals']);
    Route::post('/v1/deletegoals', [Apiv1Controller::class,'deletegoals']);
    Route::post('/v1/reminder', [Apiv1Controller::class,'reminder']);
    Route::post('/v1/addreminder', [Apiv1Controller::class,'addreminder']);
    Route::post('/v1/editreminder', [Apiv1Controller::class,'editreminder']);
    Route::post('/v1/deletereminder', [Apiv1Controller::class,'deletereminder']);
    
     Route::post('/v1/activity', [Apiv1Controller::class,'activity']);
     Route::post('/v1/addactivity', [Apiv1Controller::class,'addactivity']);
     Route::post('/v1/editactivity', [Apiv1Controller::class,'editactivity']);
     Route::post('/v1/deleteactivity', [Apiv1Controller::class,'deleteactivity']);
     
     Route::post('/v1/note', [Apiv1Controller::class,'note']);
     Route::post('/v1/addnote', [Apiv1Controller::class,'addnote']);
     Route::post('/v1/editnote', [Apiv1Controller::class,'editnote']);
     Route::post('/v1/deletenote', [Apiv1Controller::class,'deletenote']);
     
     Route::post('/v1/delete_account', [Apiv1Controller::class,'delete_account']);
     
      Route::post('/v1/update_personal_history', [Apiv1Controller::class,'update_personal_history']);
     
     

   
});


    
   
    


   
    
    





