<nav class="navbar navbar-top navbar-expand navbar-dark bg-primary ">

    <div class="container-fluid">

        <div class="collapse navbar-collapse" id="navbarSupportedContent">

            <!-- Navbar links -->

            <div class="navbarflex">

            <ul class="navbar-nav align-items-center   ">

                <li class="nav-item">

                    <!-- Sidenav toggler -->

                    <div class="pr-3 sidenav-toggler sidenav-toggler-dark" data-action="sidenav-pin" data-target="#sidenav-main">

                        <div class="sidenav-toggler-inner">

                            <i class="sidenav-toggler-line"></i>

                            <i class="sidenav-toggler-line"></i>

                            <i class="sidenav-toggler-line"></i>

                        </div>

                    </div>

                </li>

            </ul>

            <ul class="navbar-nav align-items-center">

				<li class="nav-item">

					<nav class="navbar bg-body-tertiary">

						<div class="serchbox">

						<div class="container-fluid">

							<form class="d-flex" role="search">

							<!--	<input class="form-control me-2" type="search" placeholder="Type here...." aria-label="Search">

						<button class="btn btn-outline-success" type="submit">Search</button>-->

							</form>

						</div>

						</div>

					</nav>

				</li>

			</ul>
                    <?php
						$notificationCount = DB::table('orderlist')->where('status', '=', 1)->count();
						/* $orders = DB::table('orderlist')->where('status', 1)->get(); */
					?>	
            <ul class="navbar-nav align-items-center  ml-auto ml-md-0 ">
				 <!-- Notification Icon -->
				<li class="nav-item dropdown">
				<a class="nav-link" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="position: relative; font-size: 1.5rem;">
					<i class="ni ni-bell-55"></i> <!-- Notification Icon -->
					<span class="badge badge-danger badge-counter" style="position: absolute; top: 0; right: 10px; font-size: 0.8rem; transform: translate(50%, -50%);">
						<span id="notification-count">{{ $notificationCount}}</span>
					</span>
				</a>
                
                    <div class="dropdown-menu dropdown-menu-right" id="orderListContainer">
                        <div class="dropdown-header noti-title">
                            <h6 class="text-overflow m-0">Notifications</h6>
                        </div>
                        <p class="text-center">Loading notifications...</p>
                    </div>
				</li>

                <li class="nav-item dropdown">

                    <a class="nav-link pr-0" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">

                        <div class="media align-items-center">

                            <span class="avatar avatar-sm rounded-circle">

                                <img alt="Image placeholder" src="{{ asset('img/profile.png') }}">

                            </span>

                            <div class="media-body  ml-2  d-none d-lg-block">

                                <span class="mb-0 text-sm  font-weight-bold">{{ auth()->user()->name }}</span>

                            </div>

                        </div>

                    </a>

                    <div class="dropdown-menu  dropdown-menu-right ">

                        <div class="dropdown-header noti-title">

                            <h6 class="text-overflow m-0">Welcome!</h6>

                        </div>
                    
                        <a href="{{ route('logout') }}" onclick="event.preventDefault();document.getElementById('logout-form').submit();" class="dropdown-item">

                            <i class="ni ni-user-run"></i>

                            <span>Sign Out</span>

                        </a>

                        <form id="logout-form" method="POST" action="{{ route('logout') }}" style="display: none;">

                            @csrf

                        </form>

                    </div>

                </li>

            </ul>

            </div>

        </div>

    </div>
</nav>

<script>
    function handleSessionExpiration() {
        $(document).ajaxError(function(event, xhr) {
            if (xhr.status === 401 || xhr.status === 419) {
                alert('Your session has expired. Redirecting to login page...');
                window.location.href = "{{ route('login') }}";
            }
        });
    }

    $(document).ready(function() {
        handleSessionExpiration();
    });
</script>

    <script>
function fetchOrder() {
    $.ajax({
        url: '{{ route("orders.get") }}', 
        method: 'GET',
        success: function(response) {
            const orders = response.orders;
            const container = $('#orderListContainer');
            const notificationCount = $('#notification-count');

            notificationCount.text(orders.length);

            if (orders.length > 0) {
                let content = '<div class="dropdown-header noti-title"><h6 class="text-overflow m-0">Notifications</h6></div>';
                orders.forEach(order => {
                    content += `
                        <a href="javascript:void(0);" 
                           class="dropdown-item view-order" 
                           data-id="${order.id}" 
                           onclick="markAsViewed(event, ${order.id})">
                            <span>You have new order #${order.orderid} [View]</span>
                        </a>`;
                });
                container.html(content);
            } else {
                container.html('<p class="text-center">You have no notifications</p>');
            }
        },
        error: function(xhr, status, error) {
            console.error("Error fetching orders: ", error);
        }
    });
}
setInterval(fetchOrder, 5000);
fetchOrder();
</script>

<script>
function markAsViewed(event, orderId) {
    event.preventDefault(); 

    $.ajax({
        url: '{{ route("order.markViewed") }}', 
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            order_id: orderId
        },
        success: function(response) {
            window.location.href = '{{ url("admin/orderdetails") }}/' + orderId;
        },
        error: function(xhr, status, error) {
            alert("There was an error marking the order as viewed. Please try again.");
        }
    });
}
</script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
let previousOrderCount = 0;

function fetchOrderss() {
    $.ajax({
        url: '{{ route("totoalorders") }}',
        method: 'GET',
        success: function(response) {
            const orders = response.orders;
            const container = $('#orderListContainer');
            const notificationCount = $('#notification-count');

            // Show SweetAlert popup if new orders are added
            if (orders.length > previousOrderCount) {
                const newOrderIds = orders
                    .slice(previousOrderCount)
                    .map(order => order.id); 

                Swal.fire({
                    title: 'New Order Received!',
                    text: `A new grocery order has been placed. Please review and take action`,
                    icon: 'success',
                    confirmButtonText: 'View Order',
                    confirmButtonColor: '#A3CB38', 
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    allowEnterKey: false,
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '{{ route("markAsViewed") }}',
                            method: 'POST',
                            data: {
                                _token: '{{ csrf_token() }}',
                                order_ids: newOrderIds
                            },
                            success: function(response) {
                                console.log("Status updated. New count:", response.newCount);
                                
                                // Redirect to order details after status update
                                window.location.href = '{{ url("admin/orderdetails") }}/' + newOrderIds[0];
                            },
                            error: function(err) {
                                console.error("Error updating order status:", err);
                            }
                        });
                    }
                });
            }

            previousOrderCount = orders.length;
            notificationCount.text(orders.length);

            if (orders.length > 0) {
                let content = '<div class="dropdown-header noti-title"><h6 class="text-overflow m-0">Notifications</h6></div>';
                orders.forEach(order => {
                    content += `
                        <a href="javascript:void(0);" 
                           class="dropdown-item view-order" 
                           data-id="${order.id}">
                            <span>You have new order #${order.orderid} [View]</span>
                        </a>`;
                });
                container.html(content);
            } else {
                container.html('<p class="text-center">You have no notifications</p>');
            }
        },
        error: function(xhr, status, error) {
            console.error("Error fetching orders: ", error);
        }
    });
}

setInterval(fetchOrderss, 300000); 
fetchOrderss();
</script>

<script>
function checkRejectedOrders() {
    $.ajax({
        url: '{{ route("orderreject") }}',
        method: 'GET',
        success: function(response) {
            const rejectedOrders = response.orders;

            if (rejectedOrders.length > 0) {
                const orderIdsText = rejectedOrders.map(order => order.orderid).join(', ');
                Swal.fire({
                    title: 'Driver Rejected the Order',
                    html: `The assigned driver has rejected the delivery request. Please assign a new driver.<br></br><strong>Order ID:</strong> #${orderIdsText}`,
                    icon: 'warning',
                    confirmButtonText: 'View Order',
                    confirmButtonColor: '#A3CB38',
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    allowEnterKey: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '{{ route("markAsViewedss") }}',
                            method: 'POST',
                            data: {
                                _token: '{{ csrf_token() }}',
                                order_id: rejectedOrders
                            },
                            success: function(response) {
                                console.log('Rejected orders updated.');
                                window.location.href = '{{ url("admin/orderdetails") }}/' + rejectedOrders[0].id;
                            },
                            error: function(xhr, status, error) {
                                console.error("Error updating rejected orders:", error);
                            }
                        });
                    }
                });
            }
        },
        error: function(xhr, status, error) {
            console.error("Error fetching rejected orders:", error);
        }
    });
}

setInterval(checkRejectedOrders, 300000);
checkRejectedOrders();
</script>

<script>
    function fetchNotificationCount() {
        $.ajax({
			url: "{{ route('admin.notifications.count') }}", 
            method: "GET",
            success: function(response) {
                if (response && response.count !== undefined) {
                    $('#notification-count').text(response.count);
                }
            },
            error: function() {
                console.error("Failed to fetch notification count.");
            }
        });
    }
    setInterval(fetchNotificationCount, 30000);
    fetchNotificationCount();
</script>

<style>

.swal2-container input[type="checkbox"] {
    display: none !important;
}

    .media span {

        color: white;

    }



	.navbar {

		padding:0;

	} 



	.dropdown-menu {

    min-width: 10rem;

    padding: 5px 15px;

	}



	h6 {

    	font-size: 18px !important;

	}



	.navbar .form-control {

		border-radius: 8px;

    	border: solid #A3CB38 2px;

    	height: 30px;

    	margin: 0px 5px;

	}



	.navbar .btn {

		padding: 0px 15px;

		border-radius: 8px;

		color: white;

		background: #A3CB38;

		border: none

	}



	.navbarflex {

    	display: flex;

    	flex-wrap: wrap;

    	justify-content: space-between;

	}



	form.d-flex{

		margin:0;

	}



	.navbar-expand .navbar-collapse{

		display:block !important;

		padding:10px 0;

	}



	ul.navbar-nav.align-items-center.ml-md-auto {

			display: none;

	}



    .sidenav-toggler-dark .sidenav-toggler-line{

        background-color:black;

    }

    



	/*responsive start*/



	/*tablate*/

	@media (min-width:768px) and (max-width:1023px) {

		

		ul.navbar-nav.align-items-center.ml-md-auto {

			display: block;

			padding: 8px 0;

		}



		nav.navbar.bg-body-tertiary {

    		display: none;

		}



		.sidenav-toggler-line{

			border-radius: 10px;

		}



        .sidenav-toggler-line {

            height: 5px !important;

            width: 25px !important;

        }

	}

	

	/*mobile*/

	@media (min-width:320px) and (max-width:767px) {



		ul.navbar-nav.align-items-center.ml-md-auto {

			display: block;

			padding: 10px 0;

		}



		nav.navbar.bg-body-tertiary {

    		display: none;

		}

		.sidenav-toggler-line{

			width: 36px;

    		transition: all 0.15s ease;

    		padding: 3px 0px;

    		border-radius: 10px;

		}

	}



	/*small desktop*/

	@media (min-width:1024px)and (max-width:1199px) {

		ul.navbar-nav.align-items-center.ml-md-auto {

			display:block;

			margin:0 !important;

		}

        .sidenav-toggler-line {

            height: 6px !important;

            width: 38px !important;

        }

        ul.navbar-nav.align-items-center.ml-md-auto {

			padding: 8px 0;

		}

        .sidenav-toggler-line{

			border-radius: 10px;

		}

	}

</style>
