@if (count($users) > 0)
<script>
$(document).ready(function() {
    $('#userlist').DataTable({
        "oLanguage": {
            "sSearch": "Search:"
        },
        "searching": true,
        "order": [[2, "asc"]], // Order by the visible "ID" column (sequential index)
       "columnDefs": [
            { "targets": [1], "visible": false, "searchable": false } // Hide database ID column
        ],
        "fnDrawCallback": function() {
            var api = this.api();
            api.column(2, {search: 'applied', order: 'applied'}).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1; // Set row index to start from 1
            });
        }
    });
});
</script>

<?php 
$user_id = request()->session()->get('user_id');
$alldetails = DB::table('rolemenumanage')
               ->where('u_id', $user_id)
               ->get();
?>
<div class="table-responsive">
    <table class="table align-items-center table-flush table-striped" id="userlist"> 
        <thead class="thead-light">
            <tr>
                <th scope="col">
                <input type="checkbox" id="select-all">
                <i class="fa fa-trash text-danger" id="delete-all" style="cursor: pointer; margin-left: 8px;"></i> ALL
                </th>
                <th scope="col" style="display:none;">ID</th>
                <th scope="col">ID</th>
                <th scope="col">Name</th>
                <th scope="col">Email</th>
                <th scope="col">Contact No</th>
                <th scope="col">Created</th>
                <th scope="col">Status</th>
                <th scope="col">Action</th>
            </tr>
        </thead>
        <tbody class="list">
            <?php $count = count($users);
            
            ?>
            @foreach ($users as $user)
            <tr> 
                <td class="budget"><input type="checkbox" name="delete_ids[]" value="{{ $user->id }}"></td>
                <td class="budget" style="display:none;">{{ $user->id }}</td>
                <td class="budget"> {{ $loop->index + 1 }} </td> 
                <td class="budget">{{ $user->name }}</td>
                        <td class="budget">
                            {{ $user->email }}
                        </td>
                        <td class="budget">
                            {{ $user->contact_no }}
                        </td>
                        <td class="budget">
                            {{ $user->created_at->diffForHumans() }}
                        </td>
                          
                        <td>
                            @if ($user->status == '1')
                                <a class="deactive action active" data-id="{{ $user->id }}" statusid="1"
                                    dataid-id="1" style="color: red !important;"></a>
                                <label class="switch" style="margin-left: 8px;">
                                    <input type="checkbox" checked>
                                    <span class="slider round" onclick="changeStatus({{ $user->id }}, 2)"></span>
                                </label>
                            @else
                                <a class="deactive action" data-id="{{ $user->id }}" statusid="2" dataid-id="2"
                                    style="color: #013921 !important;"></a>
                                <label class="switch" style="margin-left: 8px;">
                                    <input type="checkbox">
                                    <span class="slider round" onclick="changeStatus({{ $user->id }}, 1)"></span>
                                </label>
                            @endif
                        </td>
                        <td class="tdd">
                            <?php 
                            foreach ($alldetails as $key => $value) {
                            }
                            ?>
                          

                              <a style="padding:0 10px;" href="useredit/{{$user->id}}" class="" data-id="{{$user->id}}"><i class="far far fa-edit text-danger"></i></a>
                              <form class="delete-action" style="padding:0 10px"; method="post"
                               action="{{ route('admin.user.delete', ['id' =>$user->id]) }}">
                                @csrf
                                @method('DELETE')

                                <label for="deleteButton{{ $user->id }}" class="none-display">
                                    <i class="fa fa-trash text-danger"></i>
                                </label>

                                <input type="submit" id="deleteButton{{ $user->id }}" style="display: none;">
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@else
    <div class="col-md-12 text-center mt-1 mb-1">
        <h3>No users found</h3>
    </div>
@endif
<style>
.tdd{
    display: flex;
    align-items: baseline;
}

td.actions {
        display: flex;
        align-items: baseline;
    }

    label.none-display {
        cursor: pointer;
    }

    .switch {
            position: relative;
            display: inline-block;
            width: 50px;
            height: 24px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 1px;
            left: 1px;
            right: 0;
            bottom: 0;
            background-color: #f40707 !important;
            transition: 0.4s;
            border-radius: 34px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 20px;
            width: 20px;
            left: 2px;
            bottom: 2px;
            background-color: white;
            transition: 0.4s;
            border-radius: 50%;
        }

        input:checked + .slider {
            background-color: #013921;
        }

        input:checked + .slider:before {
            transform: translateX(26px);
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

    /* Rounded sliders */
    .slider.round {
        border-radius: 34px;
    }

    .slider.round:before {
        border-radius: 50%;
    }
   
</style> 
<script>

$(document).ready(function() {
    // Select All functionality
    $('#select-all').change(function() {
        const isChecked = $(this).is(':checked');
        $('input[name="delete_ids[]"]').prop('checked', isChecked);
    });

    // Delete Selected functionality
    $('#delete-all').click(function() {
        const selectedCheckboxes = $('input[name="delete_ids[]"]:checked');
        if (selectedCheckboxes.length === 0) {
            alert('Please select at least one record to delete.');
            return;
        }

        const confirmDelete = confirm('Are you sure you want to delete all selected records?');
        if (confirmDelete) {
            const form = $('<form>', {
                method: 'POST',
                action: '{{ route("admin.users.bulkDelete") }}'
            }).append('@csrf'); // Add CSRF token

            selectedCheckboxes.each(function() {
                form.append($('<input>', {
                    type: 'hidden',
                    name: 'delete_ids[]',
                    value: $(this).val()
                }));
            });

            $(document.body).append(form);
            form.submit();
        }
    });
});
</script>