@extends('layouts.admin.main')
@section('title', 'Edit General Settings')

@section('header')
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-lg-6 col-7">
                <h6 class="h2 text-white d-inline-block mb-0"></h6>
            </div>
        </div>
    </div>
@endsection

@section('content')

<?php 
    $user_id = request()->session()->get('user_id');
    $alldetails = DB::table('rolemenumanage')
        ->where('u_id', $user_id)
        ->get();
?>

<div class="row">
    <div class="col">
        <div class="card">
            <div class="card-header border-0">
                <div class="row align-items-center">
                    <div class="col">
                        @if (isset($generalsettings))
                            <h3 class="mb-0">Edit General Settings</h3>
                        @else
                            <h3 class="mb-0">Add General Settings</h3>
                        @endif
                    </div>
                </div>
            </div>

            <div class="card-body mt-3"> 
                @include('layouts.messages')
                @if(isset($alldetails))
                    @foreach($alldetails as $menunamelist)
                        @if($menunamelist->menuname == 'settings')
                            @if($menunamelist->edit == '1' || Session::get('role') == '1') 
                                <form enctype="multipart/form-data" method="POST"
                                      action="{{ isset($generalsettings) ? route('admin.settingseditadmin') : route('admin.settings.add') }}"
                                      id="create-canclereason">
                                    @csrf

                                    <div class="row restaurant_payout_create">
                                        <div class="restaurant_payout_create-inner">
                                            <fieldset>
                                                <legend>General Setting Details</legend>

                                                @if (isset($generalsettings))
                                                    <input type="hidden" form="create-canclereason" id="generalsettingsid"
                                                           class="form-control" name="generalsettingsid" placeholder="id"
                                                           value="{{ $generalsettings['id'] }}">
                                                @endif

                                                <!-- Page Name -->
                                                <div class="form-group row width-5">
                                                    <label class="col-12 control-label" for="pagename">Page Name
                                                        <span class=" text-red" style="margin-left: -4px !important;">*</span>
                                                    </label>
                                                    <div class="col-12">
                                                        <input type="text" form="create-canclereason" id="pagename"
                                                               class="form-control" name="pagename" placeholder="Page name"
                                                               value="{{ $generalsettings['pagename'] ?? '' }}">
                                                    </div>
                                                </div>

                                                <!-- Mobile Number (Only visible if Page Name is "Contact Support") -->
                                                <div class="form-group row width-5" id="mobileField" style="display: none;">
                                                    <label class="col-12 control-label" for="mobile_no">Mobile Number
                                                        <span class=" text-red" style="margin-left: -4px !important;">*</span>
                                                    </label>
                                                    <div class="col-12">
                                                        <input type="text" form="create-canclereason" id="mobileNumber"
                                                               class="form-control" name="mobile_no" placeholder="Mobile Number"
                                                               value="{{ isset($generalsettings) && strtolower($generalsettings['pagename']) == 'contact support' ? $generalsettings['mobile_no'] : '' }}">
                                                    </div>
                                                </div>

                                                <!-- Description -->
                                                <div class="form-group row width-5">
                                                    <label class="col-12 control-label">Description
                                                        <span class=" text-red"style="margin-left: -4px !important;" >*</span>
                                                    </label>
                                                    <div class="col-12">
                                                        <textarea style="height: 10em;" form="create-canclereason" id="myTextarea"
                                                                  name="description" class="form-control" placeholder="Description">{{ $generalsettings['description'] ?? '' }}</textarea>
                                                    </div>
                                                </div>

                                                <!-- Submit Buttons -->
                                                <div class="col-sm-12 d-flex mt-3">
                                                    <div class="add_button">
                                                        <button type="submit" form="create-canclereason" class="btn btn-primary mr-1">
                                                            {{ isset($generalsettings) ? 'Edit' : 'Add' }}
                                                        </button>
                                                        <a href="{{ url()->previous() }}" class="btn btn-primary mr-1">Cancel</a>
                                                    </div>
                                                </div>

                                            </fieldset>
                                        </div>
                                    </div>
                                </form>
                            @endif 
                        @endif
                    @endforeach 
                @endif
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts') 
@parent
<script>
    document.addEventListener("DOMContentLoaded", function() {
        toggleMobileField();

        document.getElementById('pagename').addEventListener('input', function() {
            toggleMobileField();
        });

        function toggleMobileField() {
            var pageName = document.getElementById('pagename').value.trim().toLowerCase();
            var mobileField = document.getElementById('mobileField');
            
            if (pageName === 'contact support') {
                mobileField.style.display = 'block';
            } else {
                mobileField.style.display = 'none';
            }
        }
    });
</script>

<script src="//cdnjs.cloudflare.com/ajax/libs/tinymce/4.5.1/tinymce.min.js"></script>
<script type="text/javascript">
    tinymce.init({
        selector: '#myTextarea',
        height: 200,
        theme: 'modern',
        plugins: [
            'advlist autolink lists link image charmap print preview hr anchor pagebreak',
            'searchreplace wordcount visualblocks visualchars code fullscreen',
            'insertdatetime media nonbreaking save table contextmenu directionality',
            'emoticons template paste textcolor colorpicker textpattern imagetools'
        ],
        toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
        toolbar2: 'print preview media | forecolor backcolor emoticons',
        image_advtab: true
    });
</script>
@endsection

<style>
      .form-control {
    background-color: #f5f5f5;
    border: 1px solid #ccc;
}
.form-control {
    color: #67757c;
    min-height: 38px;
    display: initial;
}
.form-control {
    display: block;
    width: 100%;
    /* padding: .375rem .75rem; */
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #ced4da;
    border-radius: .25rem;
    transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
}

.row.restaurant_payout_create .form-group.row .col-7 .form-control {
    width: 100%;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

    .row.restaurant_payout_create {
    max-width: 70%;
    margin: 0 auto;
    display: table;
    width: 100%;
}

.restaurant_payout_create .restaurant_payout_create-inner {
    margin: 0 -10px;
}
.restaurant_payout_create-inner {
    position: relative;
}

.restaurant_payout_create-inner fieldset {
    padding: 10px;
    border: 1px solid #ccc;
    margin-bottom: 15px;
    border-radius: 5px;
    background: #fff;
    position: relative;
}

.restaurant_payout_create-inner fieldset legend {
    background: #013921;
}
.restaurant_payout_create-inner fieldset legend {
    display: inline-block;
    width: auto;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    color: #fff;
    padding: 7px 14px;
    background: #013921;
    border-radius: 5px;
}

.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.row.restaurant_payout_create label.control-label {
    color: #000;
    font-weight: 500;
    -webkit-box-flex: 0;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

.row.restaurant_payout_create .form-group.row .col-7 {
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}
.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.form-group.row.width-50 {
    width: 50%;
}

@media screen and (max-width: 991px) {
    .row.restaurant_payout_create {
        max-width: 100%;
    }
    .restaurant_payout_create-inner fieldset {
    display: grid
    }

    .form-group.row.width-50 {
    width: 100%;
}
.row.check{

margin: 15px 0px;
}
}
    .justify {
        justify-content: center;
    }

    h6.h2 {
        font-size: 32px;
    }

    h3 {
        color: #A3CB38 !important;
        font-size: 18px !important;
    }

    .tab-content-title {
        border-bottom: solid #A3CB38 2px !important;
        padding: 20px 20px 20px 20px !important;
    }

    .navbar-top.border-bottom.navbar-dark {
        background-color: white !important;
        border-style: doted !important;
    }

    .pb-6,
    .py-6 {
        padding: 0 27px;
    }

    .navbarflex {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
    }

    .navbar-expand .navbar-nav {
        margin-left: 0 !important;
    }

    div#planlist_info {
        color: #A3CB38;
    }

    th {
        color: black !important;
        font-size: 12px !important;
        font-weight: 800 !important;
    }

    .d-flex {
        justify-content: center;
        flex-wrap: wrap;
    }

    .navbar .form-control {
        border-radius: 8px;
        border: solid #A3CB38 2px;
        height: 30px;
        margin: 0px 5px;
        width: 200px;
    }



    label {

        font-size: 16px;
    }

    .form-control {
        border-radius: 10px !important;
        width: 79%;
        padding: 8px 15px;
        height: 40px;
    }

    .form-group {
        margin-bottom: 4.5rem !important;
    }

    .add_button .btn {
        padding: 7px 30px;
    }



    .card-header.border-0 {
        border-bottom: solid #A3CB38 2px !important;
    }

    form#create-canclereason {
        margin-bottom: 0px;
    }

    .card-body {
        padding-bottom: 20px;
    }

    body.g-sidenav-hidden {
        overflow-x: hidden;
    }

    body.g-sidenav-show.g-sidenav-pinned {
        overflow-x: hidden;
    }

    footer.footer.pt-0 {
        padding-left: 30px;
    }

    .new-alert.alert.alert-danger.alert-dismissible.mb-2 {
        width: 370px !important;
        margin: 10px auto !important;
    }

    .pb-6,
    .py-6 {
        padding: 40 0px !important;
    }

    /*tablate*/
    @media (min-width:768px) and (max-width:1023px) {
        .main-content .navbar-top .collapse {
            justify-content: space-between;
            ;
        }

        .navbar-expand .navbar-nav {
            margin-left: 0 !important;
        }

        .table td {
            font-size: 16px !important;
        }

        th {
            color: black !important;
            font-size: 16px !important;
            font-weight: 800 !important;
        }

        H3 {
            font-size: 20px !important;
        }

        .btn {
            font-size: 16px !important;

        }

        .actions .delete-action .btn {
            font-size: 14px !important;
        }

        table.dataTable.no-footer {
            padding: 15px 0 0 0;
        }

        div#planlist_filter {
            padding: 15px 0px;
        }

        label {

            font-size: 18px !important;
        }



        .col-md-3 {
            padding-right: 0 !important;
        }

    }

    /*mobile*/
    @media (min-width:320px) and (max-width:767px) {
        .table td {
            font-size: 14px !important;
        }

        th {
            color: black !important;
            font-size: 14px !important;
            font-weight: 800 !important;
        }

        H3 {
            font-size: 17px !important;
        }

        .btn {
            font-size: 14px !important;
        }

        .actions .delete-action .btn {
            font-size: 12px !important;
        }

        table.dataTable.no-footer {
            padding: 15px 0 0 0;
        }

        div#planlist_filter {
            padding: 15px 0px;
        }

        label {
            padding: 0;
            font-size: 14px !important;
        }

        .form-control {
            width: 100% !important;
        }

        .add_button button {
            margin: 0 0 0 0 !important
        }

        .form-group {
            margin-bottom: 20px !important;
        }

        .card-body {
            padding-top: 0 !important;
        }

        footer.footer.pt-0 {
            padding-left: 0px;
        }
    }
            footer.footer.pt-0 {
        padding-left: 0px !important;
}
</style>