@if (count($notifications) > 0)
<script>
$(document).ready(function() {
    $('#tamplete').dataTable({
        "oLanguage": {
            "sSearch": "search:"
        },
       "searching": true,
        "order": [[1, "desc"]], // Sort by hidden database ID column
        "columnDefs": [
            { "targets": [1], "visible": false, "searchable": false } // Hide database ID column
        ],
        "fnDrawCallback": function() {
            var api = this.api();
            api.column(2, {search: 'applied', order: 'applied'}).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1; // Set row index to start from 1
            });
        }
    });
});
</script>

<?php 
    $user_id=request()->session()->get('user_id');
    $alldetails = DB::table('rolemenumanage')
     ->where('u_id',$user_id)
     ->get();
?>

    <div class="table-responsive">
        <table class="table align-items-center table-flush table-striped" id="tamplete">
            <thead class="thead-light">
                <tr>
                    <th scope="col">
                
                        @if(isset($alldetails)) 
                            @foreach($alldetails as $menunamelist) 
                                @if($menunamelist->menuname == 'notification')
                                    @if($menunamelist->deletev == '1' || Session::get('role') == '1')
                                        <!-- Check all and delete all functionality -->
                                        <input type="checkbox" id="select-all">
                                        <i class="fa fa-trash text-danger" id="delete-all" style="cursor: pointer; margin-left: 8px;"></i> ALL
                                    @elseif($menunamelist->deletev == '0')
                                        <!-- Prevent deletion, show permission alert -->
                                        <input type="checkbox" id="selectall">
                                        <i class="fa fa-trash text-danger" id="deleteall" style="cursor: pointer; margin-left: 8px;" onclick="showPermissionAlert()"></i> ALL
                                    @endif
                                @endif
                            @endforeach
                        @endif
                </th>
                 <th scope="col" style="display:none;">ID</th> 
                    <th scope="col">ID</th>
                    <th scope="col">title</th>
                    <th scope="col">Body</th>
                    <!-- <th scope="col">image</th> -->
                    <th scope="col">Action</th>
                </tr>
            </thead>
            <tbody class="list">
                <?php $count = count($notifications); ?>
                @foreach ($notifications as $noti)
                <tr>
                     <td class="budget">
                      <input type="checkbox" name="delete_ids[]" value="{{ $noti->id }}">
                    </td>
                    <td class="budget" style="display:none;"></td>
                    <td class="budget">{{ $loop->index+1 }}</td>
                    <td class="budget">{{ $noti->title }}</td>
                    <td class="budget">{!! $noti->body !!}</td>        
                    <!-- <td class="budget">{{ $noti->image_url }}</td> -->   
                    <td class="actions">
                    @if(isset($alldetails))
                    @foreach($alldetails as $menunamelist)
                    @if($menunamelist->menuname == 'notification')
                        @if($menunamelist->deletev == '1' || Session::get('role') == '1')
                        <form class="delete-action" method="post" action="{{ route('admin.notification.delete', ['id' => $noti->id]) }}">
                            @csrf
                            @method('DELETE')
                            <label for="deleteButton{{ $noti->id }}" class="none-display" title="Delete Notification">
                                <i class="fa fa-trash text-danger"></i>
                            </label>
                            <input type="submit" id="deleteButton{{ $noti->id }}" style="display: none;">
                        </form>

                        @elseif($menunamelist->deletev == '0')
                        <label for="deleteButton{{ $noti->id }}" class="none-display" onclick="showPermissionAlert()">
                            <i class="fa fa-trash text-danger" style="margin-right: 8px;"></i>  
                        </label>
                        @endif
                    
                    @endif
                    @endforeach

                    @endif

                        
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@else
    <div class="col-md-12 text-center mt-1 mb-1">
        <h3>No notifications found</h3>
    </div>
@endif
<script>
        function showPermissionAlert() {
    alert("This is for demo, you are not allow to delete this content.");
        }
</script>

<style>
    td.actions {
        display: flex;
        align-items: baseline;
    }
    label.none-display {
        cursor: pointer;
    }

    table#tamplete {
    width: 100% !important;
}
</style>

<script>

$(document).ready(function() {
    // Select All functionality
    $('#select-all').change(function() {
        const isChecked = $(this).is(':checked');
        $('input[name="delete_ids[]"]').prop('checked', isChecked);
    });

    // Delete Selected functionality
    $('#delete-all').click(function() {
        const selectedCheckboxes = $('input[name="delete_ids[]"]:checked');
        if (selectedCheckboxes.length === 0) {
            alert('Please select at least one record to delete.');
            return;
        }

        const confirmDelete = confirm('Are you sure you want to delete all selected records?');
        if (confirmDelete) {
            const form = $('<form>', {
                method: 'POST',
                action: '{{ route("notification.bulkDelete") }}'
            }).append('@csrf'); // Add CSRF token

            selectedCheckboxes.each(function() {
                form.append($('<input>', {
                    type: 'hidden',
                    name: 'delete_ids[]',
                    value: $(this).val()
                }));
            });

            $(document.body).append(form);
            form.submit();
        }
    });
});
</script>   

