@if (count($customers) > 0)
<script>
$(document).ready(function() {
    $('#planlist').DataTable({
        "oLanguage": {
            "sSearch": "Search:"
        },
        "searching": true,
        "order": [[1, "desc"]], // Sort by hidden database ID column
        "columnDefs": [
            { "targets": [1], "visible": false, "searchable": false } // Hide database ID column
        ],
        "fnDrawCallback": function() {
            var api = this.api();
            api.column(2, {search: 'applied', order: 'applied'}).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1; // Set row index to start from 1
            });
        }
    });
});
</script>


<?php 
$user_id = request()->session()->get('user_id'); 
$alldetails = DB::table('rolemenumanage') ->where('u_id', $user_id) ->get(); 
?>
<div class="table-responsive">
    <table class="table align-items-center table-flush table-striped" id="planlist">
        <thead class="thead-light">
            <tr>
                <th scope="col">
                @if(isset($alldetails)) 
                    @foreach($alldetails as $menunamelist) 
                        @if($menunamelist->menuname == 'customer')
                            @if($menunamelist->deletev == '1' || Session::get('role') == '1')
                                <!-- Check all and delete all functionality -->
                                <input type="checkbox" id="select-all">
                                <i class="fa fa-trash text-danger" id="delete-all" style="cursor: pointer; margin-left: 8px;"> ALL</i>
                                @elseif($menunamelist->deletev == '0')
                                <!-- Prevent deletion, show permission alert -->
                                <input type="checkbox" id="selectall" onclick="showPermissionAlert()" disabled>
                                <i class="fa fa-trash text-danger" id="deleteall" style="cursor: pointer; margin-left: 8px;" onclick="showPermissionAlert()"></i> ALL

                            @endif
                        @endif 
                    @endforeach 
                @endif
                </th>
                <th scope="col" style="display:none;">ID</th>
                <th scope="col">ID</th>
                <th scope="col">Name</th>
                <th scope="col">Email</th>
                <th scope="col">Mobile no</th>
                <th scope="col">User Image</th>
                <th scope="col">Status</th>
                <th scope="col">Action</th>
            </tr>
        </thead>
        <tbody class="list">
            <?php $count = count($customers); 
            ?>
            @foreach ($customers as $customer)
            <tr>
                <td class="budget"><input type="checkbox" name="delete_ids[]" value="{{ $customer->id }}"></td>
                <td class="budget" style="display:none;">{{ $customer->id }}</td>
                <td class="budget">{{ $loop->index+1 }}</td>
    <td class="budget">{{ $customer->name }}  {{ $customer->lastname }}</td>
   
    <td class="budget">{{ $customer->email }}</td>
    <td class="budget">{{ $customer->contact_no }}</td>
    <td>
    @if ($customer && $customer->user_image)
        <img src="{{ asset('//user_image/' . $customer->user_image) }}" width="40" height="36" alt="User Image" class="selected" />
    @else
        <img src="{{ asset('/admin_template/assets/img/brand/profile.png') }}" width="40" height="36" class="navbar-brand-img" alt="...">
    @endif
</td>                               
    <td>
        @if ($customer->status == '1')
            <a class="deactive action active" data-id="{{ $customer->id }}" statusid="1"
                dataid-id="1" style="color: red !important;"></a>
            <label class="switch" style="margin-left: 8px;">
                <input type="checkbox" checked>
                <span class="slider round" onclick="changeStatus({{ $customer->id }}, 2)"></span>
            </label>
        @else
            <a class="deactive action" data-id="{{ $customer->id }}" statusid="2" dataid-id="2"
                style="color: #013921 !important;"></a>
            <label class="switch" style="margin-left: 8px;">
                <input type="checkbox">
                <span class="slider round" onclick="changeStatus({{ $customer->id }}, 1)"></span>
            </label>
        @endif
    </td>
        <td>
        @if(isset($alldetails)) 
    @foreach($alldetails as $menunamelist) 
        @if($menunamelist->menuname == 'customer')
            @if($menunamelist->deletev == '1' || Session::get('role') == '1')
                <!-- If deletev is '1' or the user is admin, show the delete button -->
                <form class="delete-action" style="padding:0 10px;" method="post" action="{{ route('admin.customer.delete', ['id' => $customer->id]) }}">
                    @csrf
                    @method('DELETE')

                    <label for="deleteButton{{ $customer->id }}" style="cursor: pointer;">
                        <i class="fa fa-trash text-danger"></i>
                    </label>

                    <input type="submit" id="deleteButton{{ $customer->id }}" style="display: none;">
                </form>
            @elseif($menunamelist->deletev == '0')
                <!-- If deletev is '0', show the icon but prevent deletion -->
                <label for="deleteButton{{ $customer->id }}" class="none-display" onclick="showPermissionAlert()">
                    <i class="fa fa-trash text-danger"></i>
                </label>
            @endif
        @endif 
    @endforeach 
@endif

    <!-- @if(Session::get("role")=='admin')
    <form class="delete-action" style="padding:0 10px"; method="post"
           action="{{ route('admin.customer.delete', ['id' => $customer->id]) }}">
        @csrf
        @method('DELETE')

        <label for="deleteButton{{ $customer->id }}" class="none-display">
            <i class="fa fa-trash text-danger"></i>
        </label>

        <input type="submit" id="deleteButton{{ $customer->id }}" style="display: none;">
    </form>
@endif -->
</td>
</tr>
@endforeach
</tbody>
</table>
</div>@else
<div class="col-md-12 text-center mt-1 mb-1">
  <h3>No customers found</h3>
</div>
@endif
<script>
        function showPermissionAlert() {
    alert("This is for demo, you are not allow to delete this content.");
        }
</script>
<style>
 label.none-display {
        cursor: pointer;
    }
element.style {
        display: flex;
        align-items: center;
    }

    td.actions {
        display: flex;
        align-items: baseline;
    }

    label.none-display {
        cursor: pointer;
    }

    .switch {
        position: relative;
        display: inline-block;
        width: 44px;
        height: 21px;

    }

    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #f40707 !important;
        -webkit-transition: .4s;
        transition: .4s;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 16px;
        width: 16px;
        left: 2px;
        bottom: 3px;
        background-color: white;
        -webkit-transition: .4s;
        transition: .4s;
    }

    input:checked+.slider {
        background-color: #013921 !important;
    }

    input:focus+.slider {
        box-shadow: 0 0 1px #2196F3;
    }

    input:checked+.slider:before {
        -webkit-transform: translateX(26px);
        -ms-transform: translateX(26px);
        transform: translateX(26px);
    }

    /* Rounded sliders */
    .slider.round {
        border-radius: 34px;
    }

    .slider.round:before {
        border-radius: 50%;
    }

</style>
<script>

$(document).ready(function() {
    // Select All functionality
    $('#select-all').change(function() {
        const isChecked = $(this).is(':checked');
        $('input[name="delete_ids[]"]').prop('checked', isChecked);
    });

    // Delete Selected functionality
    $('#delete-all').click(function() {
        const selectedCheckboxes = $('input[name="delete_ids[]"]:checked');
        if (selectedCheckboxes.length === 0) {
            alert('Please select at least one record to delete.');
            return;
        }

        const confirmDelete = confirm('Are you sure you want to delete all selected records?');
        if (confirmDelete) {
            const form = $('<form>', {
                method: 'POST',
                action: '{{ route("admin.customers.bulkDelete") }}'
            }).append('@csrf'); // Add CSRF token

            selectedCheckboxes.each(function() {
                form.append($('<input>', {
                    type: 'hidden',
                    name: 'delete_ids[]',
                    value: $(this).val()
                }));
            });

            $(document.body).append(form);
            form.submit();
        }
    });
});
</script>