@extends('layouts.admin.main') @section('title', 'Add user')
@section('header')
    <div class="container-fluid">
        <div class="row align-items-center ">
            <div class="col-lg-6 col-7">
                <h6 class="h2 text-white d-inline-block mb-0"></h6>
            </div>
        </div>
    </div>    
@endsection
@section('content')
<div class="row">
  <!-- Light table -->
  <div class="col">
    <div class="card">
      <!-- Card header -->
      <div class="card-header border-0">
        <h3 class="mb-0">Add User / Customer</h3>
      </div>
      	<div class="card-body">@include('layouts.messages')
        	<form enctype="multipart/form-data" method="POST" action="@if(isset($customers)) {{ route('admin.customereditadmin') }} @else {{ route('admin.customer.create') }} @endif" id="create-plan">@csrf</form>
       			<div class="row restaurant_payout_create ">

                    <div class="restaurant_payout_create-inner">

					<fieldset>
						<legend>Customer Details</legend>
						<div class="form-group row width-50">
							<label class="col-3 control-label">Name
								<span class="m-l-5 text-red">*</span>
							</label>
							@if(isset($customers))
							<input type="hidden" form="create-plan" id="roleid" class="form-control" name="customerid" placeholder="id" value="@if(isset($customers)){{$customers['id']}}@endif">
							@endif
							<div class="col-7">
								<input type="text" form="create-plan" id="name" class="form-control" name="firstname" placeholder="Name" value="@if(isset($customers)){{$customers['name']}}@endif">
							</div>
						</div>


						<div class="form-group row width-50">
							<label class="col-3 control-label">Last Name
								<span class="m-l-5 text-red">*</span>
							</label>
							<div class="col-7">
								<input type="text" form="create-plan" id="name" class="form-control" name="lastname" placeholder="Lastname" value="@if(isset($customers)){{$customers['lastname']}}@endif">
							</div>
						</div>
						<div class="form-group row width-50">
							<label class="col-3 control-label">image
								<span class="m-l-5 text-red">*</span>
							</label>						
							<div class="col-7">
								<input type="file" form="create-plan" id="image" class="form-control" name="image" value="@if(isset($customers)){{$customers['image']}}@endif">
							</div>
						</div>	
						<div class="form-group row width-50">
							<label class="col-3 control-label">Email
								<span class="m-l-5 text-red">*</span>
							</label>		
							<div class="col-7">
							<input type="text" form="create-plan" id="name" class="form-control" name="email" placeholder="Email" value="@if(isset($customers)){{$customers['email']}}@endif">
							</div>
						</div>	
						<div class="form-group row width-50">
							<label class="col-3 control-label" >Password
								<span class="m-l-5 text-red">*</span>
							</label>
							<div class="col-7">
							<input type="password" form="create-plan" id="name" class="form-control" name="password" placeholder="Password" value="">
							</div>
						</div>	
						<div class="form-group row width-50">
							<label class="col-3 control-label">Mobile No
								<span class="m-l-5 text-red">
								</span>
							</label>
							<div class="col-7">
							<input type="number" form="create-plan" id="name" class="form-control" name="mobile" placeholder="Mobile" value="@if(isset($customers)){{$customers['contact_no']}}@endif">
							</div>
						</div>
						<div class="col-sm-12 d-flex">
						<div class="add_button">
							<button type="submit" form="create-plan" class="btn btn-primary mr-1 mb-1">Save</button>
							<a href="{{ url()->previous() }}" class="btn btn-primary mr-1 mb-1">Back</a>
						</div>
						</fieldset>
          			</div>
       			</div>
      		</div>
    	</div>
  	</div>
</div>
@endsection @section('scripts') @parent
<script src="//cdnjs.cloudflare.com/ajax/libs/tinymce/4.5.1/tinymce.min.js"></script>
<script type="text/javascript">
  tinymce.init({
          selector: '#myTextarea',
          height: 200,
          theme: 'modern',
          plugins: [
          'advlist autolink lists link image charm   print preview hr anchor pagebreak',
          'searchreplace wordcount visualblocks visualchars code fullscreen',
          'insertdatetime media nonbreaking save table contextmenu directionality',
          'emoticons template paste textcolor colorpicker textpattern imagetools'
          ],
          toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
          toolbar2: 'print preview media | forecolor backcolor emoticons',
          image_advtab: true
      });
</script>
<script>
  tinymce.init({
     selector: 'textarea#editor',  //Change this value according to your HTML
     auto_focus: 'element1',
     width: "700",
     height: "200"
  });
  
   $( document ).ready(function() {
  
    $('#buttonpost').on("click", function(){
     tinyMCE.triggerSave();
     var value = $("textarea#editor").val();  
     $("#display-post").html(value);
     $(".texteditor-container").hide();
     return false;
  });
  
  });
</script>@endsection

<style>
    .form-control {
    background-color: #f5f5f5;
    border: 1px solid #ccc;
}
.form-control {
    color: #67757c;
    min-height: 38px;
    display: initial;
}
.form-control {
    display: block;
    width: 100%;
    /* padding: .375rem .75rem; */
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #ced4da;
    border-radius: .25rem;
    transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
}

.row.restaurant_payout_create .form-group.row .col-7 .form-control {
    width: 100%;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

    .row.restaurant_payout_create {
    max-width: 70%;
    margin: 0 auto;
    display: table;
    width: 100%;
}

.restaurant_payout_create .restaurant_payout_create-inner {
    margin: 0 -10px;
}
.restaurant_payout_create-inner {
    position: relative;
}

.restaurant_payout_create-inner fieldset {
    padding: 10px;
    border: 1px solid #ccc;
    margin-bottom: 15px;
    border-radius: 5px;
    background: #fff;
    position: relative;
}

.restaurant_payout_create-inner fieldset legend {
    background: #00b761;
}
.restaurant_payout_create-inner fieldset legend {
    display: inline-block;
    width: auto;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    color: #fff;
    padding: 7px 14px;
    background: #105610;
    border-radius: 5px;
}

.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.row.restaurant_payout_create label.control-label {
    color: #000;
    font-weight: 500;
    -webkit-box-flex: 0;
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}

.row.restaurant_payout_create .form-group.row .col-7 {
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
}
.form-group.row {
    display: inline-block;
    width: 100%;
    padding: 0 5px;
    margin: 0;
    margin-right: -3px;
    margin-bottom: 25px;
    vertical-align: top;
}

.form-group.row.width-50 {
    width: 50%;
}

@media screen and (max-width: 991px) {
    .row.restaurant_payout_create {
        max-width: 100%;
    }
    .restaurant_payout_create-inner fieldset {
    display: grid
    }

    .form-group.row.width-50 {
    width: 100%;
}
.row.check{

margin: 15px 0px;
}
}
	

  .justify{
    justify-content:center;
  }

  h6.h2 {
        font-size: 32px;
    }

    h3 {
        color: green !important;
        font-size: 18px !important;
    }

    

	.navbar-top.border-bottom.navbar-dark {
        background-color: white!important;
        border-style:doted !important;
    }

    .pb-6, .py-6 {
        padding: 0 27px;
    }

    .navbarflex {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
    }
    .navbar-expand .navbar-nav{
        margin-left:0 !important;
    }

  
    div#planlist_info{
        color: #4F8A10;
    }

	th {
        color: black !important;
        font-size: 12px !important;
        font-weight: 800 !important;
    }
    
		.d-flex {
   			 display: flex !important;
    	flex-wrap: wrap;
    	justify-content: space-evenly;
	}
    
    .form-body .form-control{
         border-radius: 10px !important;
		    width: 79% ;
   		  padding: 8px 15px;
    	  height: 40px;
	}
	
	  label {
    	
    	font-size: 16px;
	}

	.navbar .form-control {
   	 	border-radius: 8px;
    	height: 30px;
    	margin: 0px 5px;
    	width: 200px;
	}

	.card-header.border-0 {
   		 border-bottom: solid green 2px !important;
	}

	table.mt-1 {
   	 	max-width: 100%;
    	margin: 0 auto;
	}

	.col.s12 {
    	padding: 45px 0;
	}

	th.col-md-2 {
    text-align: center;
    padding: 0px 50px 10px 0px;
	}

    .add_button .btn {
         padding: 7px 30px;
    }

    .add_button button.btn {
         margin: 0 60px 0 0px !important;
    }

    .add_button{
        padding: 50px 0;
    }

	td input {
   	 	padding: 4px 68px;
    	margin: 0 35px;
	}

	td.col-md-2 {
		font-size: 15px;
   		 padding-top: 10px;
    	font-family: serif
	}

    div#mceu_21 {
      width: 79%;
  }

  .size input[type="number"] {
    width: 30% !important;
}


  .form-group {
    margin-bottom: 40px;
}
 label.product_name{
  color:black ;
 }

label.product {
    color: black;
    font-weight: 600;
}

label.product_price {
    padding-left: 60px;
}



  /*tablat*/
  @media (min-width:768px) and (max-width:1023px) {
        .main-content .navbar-top .collapse {
             justify-content: space-between;;
        }

        .navbar-expand .navbar-nav{
            margin-left:0 !important;
        }

        .table td{
            font-size:16px !important;
        }

        th {
            color: black !important;
            font-size: 16px !important;
            font-weight: 800 !important;
        }

        H3{
            font-size: 20px !important;
        }

        .btn{
            font-size:16px !important;
                
        }
                
        .actions .delete-action .btn {
            font-size: 14px !important;
		}
		

        label {
            padding: 0 !important;
			font-size: 18px;
        }
      }

      /*mobile*/
	  @media (min-width:320px) and (max-width:767px) {
        .table td{
            font-size:14px !important;
        }

        th {
            color: black !important;
            font-size: 14px !important;
            font-weight: 800 !important;
        }

        H3{
            font-size: 17px !important;
        }

        .btn{
            font-size:14px !important;
        }



        label {
            padding: 0;
			    font-size: 14px !important;

        }

        label.product_price {
         padding-left: 0 !important;
        }
      

        .form-control{
            width:100% !important;
        }   

		.col.s12 {
    	border: solid white;
    	overflow: auto;
			}

	

  .size input[type="number"] {
    width: 100% !important; 
  }

}  



</style>
  
  