@if (count($roles) > 0)
<script>
$(document).ready(function() {
    $('#planlist').dataTable({
        "oLanguage": {
            "sSearch": "Search:"  
        },
        "searching": true,      
        "order": [[1, "desc"]], 
        "fnDrawCallback": function() {
            var api = this.api();
            api.column(1, {search: 'applied', order: 'applied'}).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1;  
            });
        }
    });
});
</script>

<script>
    function toggleReadMore(link) {
        const td = link.closest('td');
        const shortText = td.querySelector('.short-text');
        const fullText = td.querySelector('.full-text');

        const isExpanded = shortText.style.display === 'none';

        shortText.style.display = isExpanded ? 'inline' : 'none';
        fullText.style.display = isExpanded ? 'none' : 'inline';
        link.textContent = isExpanded ? 'Read More' : 'Show Less';
    }
</script>

<div class="table-responsive">

    <table class="table align-items-center table-flush table-striped" id="planlist">

        <thead class="thead-light">

            <tr>
                <th scope="col" style="display:none;">
                <th scope="col"> ID</th>
                <th scope="col"> User Name</th>
                <th scope="col"> Reason</th>
                <th scope="col"> Description</th>
                <th scope="col"> Image</th>
                <th scope="col"> Status</th>
                <th scope="col">ACTION</th>

            </tr>

        </thead>

        <tbody class="list">
         <?php $count = count($roles);
         ?>
            @foreach ($roles as $key => $role)
            <?php
            if (!function_exists('insertLineBreaks')) {
                function insertLineBreaks($text, $limit = null) {
                    $words = explode(' ', $text);
                    $formatted = '';
                    $count = $limit ?? count($words);

                    for ($i = 0; $i < $count && $i < count($words); $i++) {
                        $formatted .= $words[$i] . ' ';
                        if (($i + 1) % 10 == 0) {
                            $formatted .= '<br>';
                        }
                    }

                    return trim($formatted);
                }
            }

                $wordCount = str_word_count($role->description); 
                $username = DB::table('users')->where('id', $role->user_id)->first();
                $storename = DB::table('store')->where('id', $role->store_id)->first();
                ?>
            <tr>
                <td class="budget" style="display:none;">
                    {{ $role->id }}
                </td>
                <td class="budget">
                    {{ $count - $key }}
                </td>
                <td class="budget">
                    {{ $username->name ?? ''}}
                </td>
                <td class="budget">
                    {{ $role->reasone }}
                </td>
                <td class="budget">
                    @if($wordCount > 15)
                        <span class="short-text">{!! insertLineBreaks($role->description, 15) !!}...</span>
                        <span class="full-text" style="display: none;">{!! insertLineBreaks($role->description) !!}</span>
                        <a href="javascript:void(0);" class="read-more-link" onclick="toggleReadMore(this)">Read More</a>
                    @else
                        {!! insertLineBreaks($role->description) !!}
                    @endif
                </td>
                <td class="budget">
                      @if (!empty($role->image))
                        <img src="{{ asset('report/' . $role->image) }}" width="80" height="50">
                    @else
                    @endif
                </td>
                <td class="budget">
                    <select class="status-dropdown" data-id="{{ $role->id }}">
                        <option value="1" {{ $role->status == 1 ? 'selected' : '' }}>Active</option>
                        <option value="0" {{ $role->status == 0 ? 'selected' : '' }}>Resolved</option>
                    </select>
                </td>

                <td class="actions">
                    <form class="delete-action" style="padding:0 10px"; method="post"
                      action="{{ route('admin.appreport.delete', ['id' => $role->id]) }}">
                        @csrf
                        @method('DELETE')

                        <label for="deleteButton{{ $role->id }}" class="none-display">
                            <i class="fa fa-trash text-danger"></i>
                        </label>

                        <input type="submit" id="deleteButton{{ $role->id }}" style="display: none;">
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@else
<div class="col-md-12 text-center mt-1 mb-1">

    <h3>No report found !</h3>

</div>

@endif
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('.status-dropdown').change(function () {
            var newStatus = $(this).val();
            var reportId = $(this).data('id');

            $.ajax({
                url: "{{ route('admin.update-status') }}", 
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    id: reportId,
                    status: newStatus
                },
                success: function (response) {
                    alert(response.message);
                },
                error: function () {
                    alert('Status update failed!');
                }
            });
        });
    });
</script>
<style>
label.none-display {
        cursor: pointer;
    }
    .status-dropdown {
        padding: 6px 10px;
        border: 1px solid #ced4da;
        border-radius: 6px;
        background-color: #f8f9fa;
        font-size: 14px;
        color: #333;
        transition: all 0.2s ease-in-out;
        width: 120px;
        outline: none;
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 140 140' xmlns='http://www.w3.org/2000/svg'%3E%3Cpolygon points='70,100 30,40 110,40' fill='%23666'%3E%3C/polygon%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 12px;
    }

    .status-dropdown:hover {
        background-color: #e9ecef;
        border-color: #adb5bd;
    }

    .status-dropdown:focus {
        border-color: #80bdff;
        box-shadow: 0 0 0 0.1rem rgba(0, 123, 255, 0.25);
    }
</style>



