<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class productimage extends Authenticatable implements JWTSubject
    {
    
    use Notifiable;
    protected $table='productimage';

     protected $fillable = ['p_id','images', 'created_at','updated_at',];

    
    protected $hidden = [
            'password', 'remember_token',
        ];

        public function getJWTIdentifier()
        {
            return $this->getKey();
        }
        public function getJWTCustomClaims()
        {
            return [];
        }
        public function product()
        {
            return $this->belongsTo(product::class, 'p_id');
        }


}
