<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class product extends Authenticatable implements JWTSubject
    {
    
    use Notifiable;
    protected $table='product';

     protected $fillable = ['productname','categories_id','productdetails','product_weight','images','prices','producttype', 'product_stoke', 'status', 'created_at','updated_at',];

    
    protected $hidden = [
            'password', 'remember_token',
        ];

        public function getJWTIdentifier()
        {
            return $this->getKey();
        }
        public function getJWTCustomClaims()
        {
            return [];
        }
	
    public function productpricesuserwise()
    {
        return $this->hasMany('App\Models\productpricesuser','productid','id');
    }

    public function category()
    {
        return $this->belongsTo(Categories::class, 'categories_id');
    }

    public function images()
    {
        return $this->hasMany(productimage::class, 'p_id');
    }
}
