<?php

namespace App\Models;


use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class orderdetail extends Authenticatable implements JWTSubject
    {
    
    use Notifiable;
    protected $table='orderdetails';

    protected $fillable = ['id','or_id','quantity','p_id','orderprices','instruction','created_at','updated_at',];

    
    protected $hidden = [
            'password', 'remember_token',
        ];

        public function getJWTIdentifier()
        {
            return $this->getKey();
        }
        public function getJWTCustomClaims()
        {
            return [];
        }
        public function productname()
        {
            return $this->hasMany('App\Models\product','id', 'p_id');
        }       
}
