<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\MediaLibrary\HasMedia\HasMedia;
use Spatie\MediaLibrary\HasMedia\HasMediaTrait;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use Notifiable;
    protected $table = 'user';
   
    protected $fillable = [
        'name','email','surname','dateofbirth','mobile_no','device_token','first_period_date','last_cycle','last_period','breast_cancel','hpv_previos_lesson','cervical_cancer','breast_cancel_family'];
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return [];
    }
    protected $hidden = [
        'password', 'remember_token',
    ];
     public function job_lookings()
        {
            return $this->hasMany('App\job_lookings','id', 'Looking');
        }

    public function resume()
    {
        return $this->hasOne('App\Media', 'model_id')->where('collection_name', '=', 'resume_file');
    }

    public function setPasswordAttribute($password)
    {
        $this->attributes['password'] = (Hash::needsRehash($password)) ? Hash::make($password) : $password;
    }

    public function scopeUsers($query)
    {
        return $query->where('role', 'user');
    }

    public function scopeAgents($query)
    {
        return $query->where('role', 'agent');
    }

    public function scopeCompanies($query)
    {
        return $query->where('role', 'company');
    }
    public function modulelist()
    {
        return $this->hasMany('App\Models\rolemenumanage','id', 'u_id');
    }
    public function productpricesuserwise()
    {
        return $this->hasMany('App\Models\productpricesuser','userid','id');
    }
    public function jobs()
    {
        return $this->belongsToMany('App\Job')->withPivot('status');
    }
}
