<?php

namespace App\Models;


use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Note extends Authenticatable implements JWTSubject
    {
    
    use Notifiable;
    protected $table='note';

     protected $fillable = ['title','sub_title','user_id','date','type','created_at','updated_at'];

    
    protected $hidden = [
            'password', 'remember_token',
        ];

        public function getJWTIdentifier()
        {
            return $this->getKey();
        }
        public function getJWTCustomClaims()
        {
            return [];
        }
        
         
        
}
