<?php

namespace App\Models;
use Spatie\MediaLibrary\Models\Media as BaseMedia;

class Media extends BaseMedia
{
    protected $appends = ['main_image_url', 'thumb_image_url', 'file_url'];

    public function getMainImageUrlAttribute() {
        return (strstr($this->mime_type, 'image/')) ? (asset('media_images' . DIRECTORY_SEPARATOR . $this->id . DIRECTORY_SEPARATOR . $this->file_name)) : '';
    }

    public function getThumbImageUrlAttribute() {
        return (strstr($this->mime_type, 'image/')) ? (asset('media_images' . DIRECTORY_SEPARATOR . $this->id . DIRECTORY_SEPARATOR . $this->file_name) . '?' . http_build_query(['w' => '200', 'h' => '200'])) : '';
    }

    public function getFileUrlAttribute() {
        return (strstr($this->mime_type, 'application/')) ? (asset('media' . DIRECTORY_SEPARATOR . $this->id . DIRECTORY_SEPARATOR . $this->file_name)) : '';
    }
}