<?php

namespace App\Models;


use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Getgoals extends Authenticatable implements JWTSubject
    {
    
    use Notifiable;
    protected $table='goals';

     protected $fillable = ['title','sub_title','user_id','created_at','updated_at'];

    
    protected $hidden = [
            'password', 'remember_token',
        ];

        public function getJWTIdentifier()
        {
            return $this->getKey();
        }
        public function getJWTCustomClaims()
        {
            return [];
        }
        
        public function username()
        {
            return $this->hasMany('App\Models\User','id','c_id');
        }
          
        
}
