<?php

namespace App\models;


use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Address extends Authenticatable implements JWTSubject
    {
    
    use Notifiable;
    protected $table='addresses';

     protected $fillable = ['id','user_id','house_office_no','house_office_no','building_apartment_name','address','landmark_area','latitude','longitude','created_at','updated_at'];

    
    protected $hidden = [
            'password', 'remember_token',
        ];

        public function getJWTIdentifier()
        {
            return $this->getKey();
        }
        public function getJWTCustomClaims()
        {
            return [];
        }

    
}
