<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use App\Helpers\CommonHelper;
use Illuminate\Support\Str;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function __construct()
    {
        $this->CommonHelper = new CommonHelper;
    }

    public function generateRandomString($length = 96)
    {
        return Str::random($length);
    }

    public function getArrayFromErrorMessages($validator_messages = [])
    {
        $error_messages = [];

        foreach ($validator_messages as $key => $value) {
            foreach ($value as $error_message) {
                $error_messages[] = $error_message;
            }
        }

        return $error_messages;
    }
}
