<?php



namespace App\Http\Controllers\Auth;



use App\Http\Controllers\Controller;

use App\Providers\RouteServiceProvider;

use Illuminate\Foundation\Auth\AuthenticatesUsers;

use Illuminate\Http\Request;

use App\rolemenumanage;

use Session;

use App\User;



class LoginController extends Controller

{

    /*

    |--------------------------------------------------------------------------

    | Login Controller

    |--------------------------------------------------------------------------

    |

    | This controller handles authenticating users for the application and

    | redirecting them to your home screen. The controller uses a trait

    | to conveniently provide its functionality to your applications.

    |

    */



    use AuthenticatesUsers;



    /**

     * Where to redirect users after login.

     *

     * @var string

     */

    protected $redirectTo = '/admin';



    /**

     * Create a new controller instance.

     *

     * @return void

     */

    public function __construct()

    {

        $this->middleware('guest')->except('logout');

    }

        public function homedetails($id)

    {

	$updateStatus = array(

                'status' => '1',

                'updated_at' => date("Y-m-d H:i:s")

            );

            $updateData= User::where('id','=',$id)->update($updateStatus);

	$userdetails=User::where('id',$id)->first();

        return view('welcome', compact('userdetails'));

        exit();

    }

    protected function authenticated(Request $request, $user)

    {

        Session::put('user_id', $user->id);

        Session::put('role', $user->role);

        if ($user->role != 'appuser') {

            return redirect()->intended('/admin');

        }

        else {

            $this->logout($request);

        }

    }



    public function logout(Request $request)

    {

        $this->guard()->logout();
        $request->session()->invalidate();
        $request->session()->flush();
        return redirect('/login');

    }

}

