<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use Illuminate\Mail\Message;
use Symfony\Component\Mime\Part\TextPart;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\customer;
use App\Models\User;
use App\Models\product;
use App\Models\orderlist;
use App\Models\orderdetail;
use App\Models\productimage;
use App\Models\productpricesuser;
use App\Models\settings;
use App\Models\sliders;
use App\Models\Address;
use App\Models\Categories;
use App\Models\Getgoals;
use App\Models\Activity;
use App\Models\Note;
use App\Models\Reminder;
use App\Models\businessdetail;
use App\Models\Push_notification;
use Auth;
use JWTAuth;
use Config;
use Tymon\JWTAuth\Exceptions\JWTException;
use Firebase\JWT\JWT;
use GuzzleHttp\Client;


class Apiv1Controller extends Controller
{
    public $credentials_error = 'Please enter correct credentials.';

    public $values_error = 'Please enter correct values.';
    protected $i_path;
    public function __construct()
    {
        parent::__construct();
        $this->i_path = "https://single2mingal.com/silsa/public";
         

    }

    public function register(Request $request)
        {
            // Validate the request data
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'surname' => 'required',
                'email' => 'required',
                'dateofbirth' => 'required', // Ensure a minimum password length
                'mobile_no' => 'required', // Adjust based on expected format
                'device_token' => 'required', // Image validation
            ]);
        
            // If validation fails, return errors
            if ($validator->fails()) {
                return response()->json(['status' => '201', 'message' => $validator->errors()->first()], 400);
            }
        
            // Check if the mobile number is already in use
            if ($request->mobile_no && User::where('mobile_no', $request->mobile_no)->exists()) {
                
                return response()->json(['status' => '201', 'message' => 'The mobile number is already used.'], 400);
            }
        
            // Create the new user
            $usernew = User::create([
                'name' => $request->name,
                'surname' => $request->surname,
                'email' => $request->email,
                'dateofbirth' =>$request->dateofbirth,
                'mobile_no' => $request->mobile_no,
                'device_token' =>$request->device_token,
                'first_period_date' =>$request->first_period_date,
                'last_cycle' =>$request->last_cycle,
                'last_period' =>$request->last_period,
                'breast_cancel' =>$request->breast_cancel,
                'hpv_previos_lesson' =>$request->hpv_previos_lesson,
                'cervical_cancer' =>$request->cervical_cancer,
                'breast_cancel_family' =>$request->breast_cancel_family,
            ]);
        
            // Generate JWT token
            $token = JWTAuth::fromUser($usernew);
        
            return response()->json([
                                'status' => '201',
                                'message' => 'Your Account Created Successfully.',
                                'bearer_token' => $token,
                                'User_details' =>'true',
                                'device_token' => $usernew->device_token,
                                'user' => $usernew,
                            ], 201);
                    
        
           
        }
    public function login(Request $request)
    {
 
        $request->validate([
                'mobile_no' => 'required',
            ]);
            
            $mobile = $request->get('mobile_no');
            
            $user = User::where('mobile_no', $mobile)->first();
            
            
            if (!$user) {
                return response()->json([
                    'status' => '201',
                    'User_details' =>'false',
                    'message' => 'User details not found.',
                ], 400);
            }
            
            try {
                // Create token directly from user model
                $token = JWTAuth::fromUser($user);
            } catch (JWTException $e) {
                return response()->json([
                    'status' => '400',
                    'message' => 'Could not create token.',
                ], 400);
            }
            
            // Save device token
            $user->device_token = $request->get('device_token'); // make sure request has this
            $user->save();
            
            return response()->json([
                'status' => '201',
                'message' => 'Login successful.',
                'bearer_token' => $token,
                'User_details' =>'true',
                'device_token' => $user->device_token,
                'user' => $user,
            ], 201);
            
    }
    public function logout(Request $request)
    {
     $token = JWTAuth::getToken();
     $apy = JWTAuth::getPayload($token)->toArray();
     $userId = $apy['sub'];
     $userExist = User::where(['id' => $userId])->first();

     if (!$userExist) {
         $response = ['status' => '400', 'message' => "Token mismatch or expired, please try again."];
         return response()->json(compact('response'), 400);
         exit();
     } else {
         $userUpdate = [
             'updated_at' => date("Y-m-d H:i:s"),
         ];
         User::where('id', $userId)->update($userUpdate);

         $response = ['status' => '201', 'message' => "Logout successfully.."];
         return response()->json(compact('response'), 201);
         exit();
        }
    }
    public function getprofile(Request $request)
    {
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
        
        $profile = User::where('id', $userId)
            ->first(); 
    
        if ($profile) {
           $response = [
                'status' => '201',
                'message' => 'Profile details retrieved successfully.',
                'profile' =>   [
                    'id' => $profile->id,
                    'name' => $profile->name,
                    'surname' =>$profile->surname,
                    'email' => $profile->email,
                    'dateofbirth' => $profile->dateofbirth,
                    'first_period_date' =>$profile->first_period_date,
                    'mobile_no'=>$profile->mobile_no,
                    'device_token'=>$profile->device_token,
                    'last_cycle'=>$profile->last_cycle,
                    'last_period'=>$profile->last_period,
                    'breast_cancel'=>$profile->breast_cancel,
                    'hpv_previos_lesson'=>$profile->hpv_previos_lesson,
                    'cervical_cancer'=>$profile->cervical_cancer,
                    'breast_cancel_family'=>$profile->breast_cancel_family,
                ] 
            ];
    
            return response()->json($response, 200); // Use status 200 for successful retrieval
        } else {
            $response = [
                'status' => '400',
                'message' => 'Profile details do not exist'
            ];
    
            return response()->json($response, 400);
        }
    }
       public function getCategories()
        {
            $categories = Categories::all();
            $categories->transform(function ($category) {
            
                $category->categories_image = $category->categories_image 
                    ? url('/categories/' . $category->categories_image) 
                    : url('/categories/default-image.png'); 
                
                return $category;
            });
        
            return response()->json([
                'status' => 'success',
                'categories' => $categories
            ], 200);
        }
    
    public function editprofile(Request $request)
    {
        
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];
        
        $userExist = User::where('id', $userId)->first();

        if (!empty($userExist)) {
           

                $updatedPersonalData = [
                'name' => $request->input('name'),
                'surname' => $request->input('surname'),
                'dateofbirth' => $request->input('dateofbirth'),
                'mobile_no' => $request->input('mobile_no'),
                'updated_at' => date("Y-m-d H:i:s"),
                ];

                $userExist->where('id', '=', $userId)->update($updatedPersonalData);

    
            $response = ['status' => '201', 'message' => "User profile updated successfully.",  'data' => $updatedPersonalData];

            return response()->json(compact('response'), 201);
            exit();
        } else {
            $response = ['status' => '400', 'message' => "User does not exist."];

            return response()->json(compact('response'), 400);
            exit();
        }
    }
     public function update_personal_history(Request $request)
    {
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        $user = User::find($userId);
    
        if (!$user) {
            return response()->json([
                'status' => 400,
                'message' => 'User does not exist.'
            ], 400);
        }
    
        // Allowed fields
        $allowedTypes = [
            'breast_cancel',
            'hpv_previos_lesson',
            'cervical_cancer',
            'breast_cancel_family'
        ];
    
        $type = $request->input('type');
        $value = $request->input('value');
    
        if (!in_array($type, $allowedTypes)) {
            return response()->json([
                'status' => 422,
                'message' => 'Invalid personal history type.'
            ], 422);
        }
    
        // Update dynamically
        $user->update([
            $type => $value
        ]);
    
        return response()->json([
            'status' => 200,
            'message' => 'Personal history updated successfully.',
            'data' => [
                $type => $value
            ]
        ], 200);
    }
    
    
    public function getgoals()
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];
        $goalslist = Getgoals::where('user_id',$userId)->select('id','title','sub_title')->get();
        return response()->json([
            'status' => 'success',
            'goalslist' => $goalslist
        ], 200);
    }
    public function addgoals(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Validate request
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string',
        ]);
        // Add goal
        $goal = Getgoals::create([
            'user_id' => $userId,
            'title' => $request->title,
            'sub_title' => $request->subtitle,
        ]);
    
        // Fetch updated goals list
        $goalslist = Getgoals::where('user_id', $userId)->select('id','title','sub_title')->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Goal added successfully.',
            'goalslist' => $goalslist
        ], 201);
    }
    public function editgoals(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Validate request
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string',
        ]);
    
        // Find goal belonging to the user
        $goal = Getgoals::where('id', $request->id)
                        ->where('user_id', $userId)
                        ->first();
    
        if (!$goal) {
            return response()->json([
                'status' => 'error',
                'message' => 'Goal not found or unauthorized.'
            ], 404);
        }
    
        // Update goal
        $goal->update([
            'title' => $request->title,
            'sub_title' => $request->subtitle,
        ]);
    
        // Fetch updated goals list
        $goalslist = Getgoals::where('user_id', $userId)->select('id','title','sub_title')->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Goal updated successfully.',
            'goalslist' => $goalslist
        ], 200);
    }
    public function deletegoals(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Find goal belonging to the user
        $goal = Getgoals::where('id',$request->id)
                        ->where('user_id', $userId)
                        ->first();
    
        if (!$goal) {
            return response()->json([
                'status' => 'error',
                'message' => 'Goal not found or unauthorized.'
            ], 404);
        }
    
        // Delete goaladdgoals
        $goal->delete();
    
        // Fetch updated goals list
        $goalslist = Getgoals::where('user_id', $userId)->select('id','title','sub_title')->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Goal deleted successfully.',
            'goalslist' => $goalslist
        ], 200);
    }
    
    
    public function reminder()
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];
        $goalslist = Reminder::where('user_id',$userId)->select('id','title','sub_title')->get();
        return response()->json([
            'status' => 'success',
            'reminderlist' => $goalslist
        ], 200);
    }
    public function addreminder(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Validate request
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string',
        ]);
        // Add Reminder
        $goal = Reminder::create([
            'user_id' => $userId,
            'title' => $request->title,
            'sub_title' => $request->subtitle,
        ]);
    
        // Fetch updated Reminder list
        $goalslist = Reminder::where('user_id', $userId)->select('id','title','sub_title')->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Reminder added successfully.',
            'reminderlist' => $goalslist
        ], 201);
    }
    public function editreminder(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Validate request
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string',
        ]);
    
        // Find Reminder belonging to the user
        $goal = Reminder::where('id', $request->id)
                        ->where('user_id', $userId)
                        ->first();
    
        if (!$goal) {
            return response()->json([
                'status' => 'error',
                'message' => 'Goal not found or unauthorized.'
            ], 404);
        }
    
        // Update Reminder
        $goal->update([
            'title' => $request->title,
            'sub_title' => $request->subtitle,
        ]);
    
        // Fetch updated Reminder list
        $goalslist = Reminder::where('user_id', $userId)->select('id','title','sub_title')->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Reminder updated successfully.',
            'reminderlist' => $goalslist
        ], 200);
    }
    public function deletereminder(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Find Reminder belonging to the user
        $goal = Reminder::where('id',$request->id)
                        ->where('user_id', $userId)
                        ->first();
    
        if (!$goal) {
            return response()->json([
                'status' => 'error',
                'message' => 'Reminder not found or unauthorized.'
            ], 404);
        }
    
        // Delete Reminderaddgoals
        $goal->delete();
    
        // Fetch updated Reminder list
        $goalslist = Reminder::where('user_id', $userId)->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Reminder deleted successfully.',
            'reminderlist' => $goalslist
        ], 200);
    }
    
    
    public function activity()
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];
        $goalslist = Activity::where('user_id',$userId)->get();
        return response()->json([
            'status' => 'success',
            'activitylist' => $goalslist
        ], 200);
    }
    public function addactivity(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Validate request
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string',
        ]);
        // Add Activity
        $goal = Activity::create([
            'user_id' => $userId,
            'title' => $request->title,
            'sub_title' => $request->subtitle,
            'date' => $request->date,
            'time' => $request->time,
            'location' => $request->location,
            'notes' => $request->notes,
        ]);
    
        // Fetch updated Activity list
        $goalslist = Activity::where('user_id', $userId)->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Activity added successfully.',
            'activitylist' => $goalslist
        ], 201);
    }
    public function editactivity(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Validate request
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string',
        ]);
    
        // Find Activity belonging to the user
        $goal = Activity::where('id', $request->id)
                        ->where('user_id', $userId)
                        ->first();
    
        if (!$goal) {
            return response()->json([
                'status' => 'error',
                'message' => 'Activity not found or unauthorized.'
            ], 404);
        }
    
        // Update Activity
        $goal->update([
            'title' => $request->title,
            'sub_title' => $request->subtitle,
            'date' => $request->date,
            'time' => $request->time,
            'location' => $request->location,
            'notes' => $request->notes,
        ]);
    
        // Fetch updated Activity list
        $goalslist = Activity::where('user_id', $userId)->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Activity updated successfully.',
            'activitylist' => $goalslist
        ], 200);
    }
    public function deleteactivity(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Find goal belonging to the user
        $goal = Activity::where('id',$request->id)
                        ->where('user_id', $userId)
                        ->first();
    
        if (!$goal) {
            return response()->json([
                'status' => 'error',
                'message' => 'Activity not found or unauthorized.'
            ], 404);
        }
    
        // Delete Activity
        $goal->delete();
    
        // Fetch updated Activity list
        $goalslist = Activity::where('user_id', $userId)->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Activity deleted successfully.',
            'activitylist' => $goalslist
        ], 200);
    }
    
    
    public function note()
    {
        $token = JWTAuth::getToken();
        $apy = JWTAuth::getPayload($token)->toArray();
        $userId = $apy['sub'];
        $goalslist = Note::where('user_id',$userId)->get();
        return response()->json([
            'status' => 'success',
            'notelist' => $goalslist
        ], 200);
    }
    public function addnote(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Validate request
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string',
        ]);
        // Add Activity
        $goal = Note::create([
            'user_id' => $userId,
            'title' => $request->title,
            'sub_title' => $request->subtitle,
            'date' => $request->date,
            'type' => $request->type,
        ]);
    
        // Fetch updated Note list
        $goalslist = Note::where('user_id', $userId)->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Note added successfully.',
            'notelist' => $goalslist
        ], 201);
    }
    public function editnote(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Validate request
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string',
        ]);
    
        // Find Activity belonging to the user
        $goal = Note::where('id', $request->id)
                        ->where('user_id', $userId)
                        ->first();
    
        if (!$goal) {
            return response()->json([
                'status' => 'error',
                'message' => 'Activity not found or unauthorized.'
            ], 404);
        }
    
        // Update Note
        $goal->update([
            'title' => $request->title,
            'sub_title' => $request->subtitle,
            'date' => $request->date,
            'type' => $request->type,
          
        ]);
    
        // Fetch updated Note list
        $goalslist = Note::where('user_id', $userId)->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Note updated successfully.',
            'notelist' => $goalslist
        ], 200);
    }
    public function deletenote(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Find goal belonging to the user
        $goal = Note::where('id',$request->id)
                        ->where('user_id', $userId)
                        ->first();
    
        if (!$goal) {
            return response()->json([
                'status' => 'error',
                'message' => 'Note not found or unauthorized.'
            ], 404);
        }
    
        // Delete Note
        $goal->delete();
    
        // Fetch updated Note list
        $goalslist = Note::where('user_id', $userId)->get();
    
        return response()->json([
            'status' => 'success',
            'message' => 'Note deleted successfully.',
            'notelist' => $goalslist
        ], 200);
    }
    public function delete_account(Request $request)
    {
        // Get logged-in user ID from JWT
        $token = JWTAuth::getToken();
        $payload = JWTAuth::getPayload($token)->toArray();
        $userId = $payload['sub'];
    
        // Find User account belonging to the user
        $userdetails = User::where('id', $userId)->first();
    
        if (!$userdetails) {
            return response()->json([
                'status' => 'error',
                'message' => 'User not found or unauthorized.'
            ], 404);
        }
    
        // Delete User account
        $userdetails->delete();
        
        return response()->json([
            'status' => 'success',
            'message' => 'User Account deleted successfully.',
        ], 200);
    }
    
   

    



}



    



