<?php
namespace App\Http\Controllers\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Role;
use App\Models\product;
use App\Models\categorys;
use App\Models\promocode;
use App\Models\generalsettings;
use App\Models\User;
use App\Models\customer;
use App\Models\orderlist;
use App\Models\orderdetail;
use App\Models\sliders;
use App\Models\productimage;
use App\Models\productpricesuser;
use Validator;
use Illuminate\Support\Facades\Hash;

class RoleController extends Controller
{

    public function __construct()

    {

        parent::__construct();

        $this->middleware('auth');

    }



    public function index()

    {

        if (request()->ajax()) {

            $roles = Role::select('id', 'rolename', 'status', 'created_at','updated_at')
                 ->paginate(5);

                

            return view('admin.role.index_ajax', compact('roles'));

        } else {

            return view('admin.role.index');

        }

    }



    public function add()

    {

        return view('admin.role.add');

    }

    public function roleedit($id)
    {

        $roles = Role::select('id', 'rolename', 'status', 'created_at','updated_at')->where('id',$id)

                ->first();

        return view('admin.role.add',compact('roles'));
        exit();

    }
    public function roleeditadmin()
    {
 
        $id=request()->get('roleid');
        $updateStatus = array(
            'rolename' => request()->get('rolename'),
        );
        role::where('id','=',$id)->update($updateStatus);
        return redirect()->route('admin.role.index');
        exit();

    }
    public function create(Request $request)

    {

        $validator = Validator::make(request()->all(), [

            'rolename' => 'required',
        ]);
        if ($validator->fails()) {

            // $this->CommonHelper->sendJsonResponse(true, [], $this->getArrayFromErrorMessages($validator->messages()->toArray()), '', 400);        

            return redirect()->back()

                ->with('alert-danger', 'Please fill required all fields');

        }
        $useraddste='1';
        $role = role::create([
            'rolename' => $request->get('rolename'),
            'status' => $useraddste,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);


        if ($role->id) {
            return redirect()->route('admin.role.index')
            ->with('alert-success', 'rol creado con éxito.');
        }
        else {
            return redirect()->back()
            ->with('alert-danger', 'No se pudo crear el plan. Inténtalo de nuevo.');
        }
    }
    public function delete($id)
    {

        $role = role::select('id')->where('id',$id)->first();

        if ($role->delete()) {

            $this->CommonHelper->sendJsonResponse(false, [], ['rol eliminado con éxito.'], '');

        }

        else {

            $this->CommonHelper->sendJsonResponse(true, [], ['No se pudo eliminar el plan. Inténtalo de nuevo.'], '', 500);

        }

    }

    public function productlist()

    {
     if (request()->ajax()) {

            $products = product::select('id', 'c_id','producttype','productname','prices','productdetails','images','status', 'created_at','updated_at')
                 ->paginate(5);

            return view('admin.product.index_ajax', compact('products'));

        } else {

            return view('admin.product.index');

        }

    }



    public function productadd()

    {
      $categorys = categorys::where('status', '!=', '2')->get();
    
        return view('admin.product.add',compact('categorys'));

    }

    public function productedit($id)
    {
        $categorys = categorys::where('status', '!=', '2')->get();
        $products = product::select('id', 'productname','productdetails','c_id','prices','images','status', 'created_at','updated_at')->where('id',$id)
                ->first();

        return view('admin.product.add',compact('products','categorys'));
        exit();

    }
    public function producteditadmin(Request $request)
    {
        $id=request()->get('productid');
        $imagepath = public_path() . '/productimages';
        if (!empty($request->File('images'))) {
            //productimage::where('p_id',$id)->delete();
            if($file = $request->File('images')){
            foreach($file as $file){
            $image_name = rand(1000,10000);
            $img_ext = $file->getClientOriginalExtension();
            $filename = 'product-' . $image_name. '.' . $img_ext;
            $path = $file->move($imagepath, $filename); //image save public folder
            $product = productimage::create([
            'images' => $filename,
            'p_id' => $id,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
            ]);
            }
                
            }
            $updateStatus = array(
            'productname' => $request->get('productname'),
            'productdetails' => $request->get('productdetails'),
            'producttype' => $request->get('producttype'),
            'c_id' => $request->get('c_id'),
	        'prices' => $request->get('prices'),

            
            );
        }else{
           $updateStatus = array(
            'productname' => $request->get('productname'),
            'productdetails' => $request->get('productdetails'),
            'c_id' => $request->get('c_id'),
            'producttype' => $request->get('producttype'),
	        'prices' => $request->get('prices'),
            );
        }
        product::where('id','=',$id)->update($updateStatus);
        return redirect()->route('admin.product.index');
        exit();

    }
    public function productcreate(Request $request)
    {
       $product=product::where('productname',$request->get('productname'))->get()->count();
        if($product>0)
        {
            return redirect()->back()

            ->with('alert-danger', 'This  product name  is already use');
        }else{
        $validator = Validator::make(request()->all(), [

            'productname' => 'required',
            'productdetails' => 'required',

            
        ]);
        if ($validator->fails()) {

            // $this->CommonHelper->sendJsonResponse(true, [], $this->getArrayFromErrorMessages($validator->messages()->toArray()), '', 400);        

            return redirect()->back()

                ->with('alert-danger', 'Please fill required all fields');

        }
        $imagepath = public_path() . '/productimages';
        
        $useraddste='1';
        $product = product::create([
            'productname' => $request->get('productname'),
            'productdetails' => $request->get('productdetails'),
            'prices' => $request->get('prices'),
            'producttype' => $request->get('producttype'),
            'c_id' => $request->get('c_id'),
            'status' => $useraddste,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);

          $firebaseToken = User::whereNotNull('device_token')->pluck('device_token')->all();
          $SERVER_API_KEY = 'AAAAlmQQrQk:APA91bHw-uejuf6B4Pjx6s17KD10uvqH0SynUzWGpxBDMJ5QMGQBuUn4Cj0p6orikSRRFFbGwysMRpoYacr7lIqz70S1ImvF-2raKVmhraV5yV8PUTQ_vRZMXkXNOVAPRvYejrKGDnVz';
            $data = [
                "registration_ids" => $firebaseToken,
                "notification" => [
                    "Productname"=>$request->get('productname'),
                    "prices"=>$request->get('prices'),
                    "body"=>"New product add in store",
                    "title"=>"Add new product in store",                    
                    "Type"=>"1",    
                ],
                    "data" => [
                    "id" => "-1",
                    "Productname"=>$request->get('productname'),
                    "prices"=>$request->get('prices'),
                    "body"=>"New product add in store",
                    "title"=>"Add new product in store",                    
                    "Type"=>"1",
                ]
            ];
            $dataString = json_encode($data);
            $headers = [
                    'Authorization: key=' . $SERVER_API_KEY,
                    'Content-Type: application/json',
                ];
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

                $response = curl_exec($ch);

	$productid=$product->id;
        if ($product->id) {
		 if($file = $request->File('images')){
            foreach($file as $file){
                $image_name = rand(1000,10000);
            $img_ext = $file->getClientOriginalExtension();
            $filename = 'product-' . $image_name. '.' . $img_ext;
            $path = $file->move($imagepath, $filename); //image save public folder
            $product = productimage::create([
            'images' => $filename,
            'p_id' => $productid,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
            ]);
            }
                
            }
            return redirect()->route('admin.product.index')
            ->with('alert-success', 'Product created successfully.');
        }
        else {
            return redirect()->back()
            ->with('alert-danger', 'No se pudo crear el plan. Inténtalo de nuevo.');
        }
    }
}
    public function productdelete($id)
    {

        $product = product::select('id')->where('id',$id)->first();

        if ($product->delete()) {

            $this->CommonHelper->sendJsonResponse(false, [], ['Product  deleted successfully.'], '');

        }

        else {

            $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete Product. Please try again.'], '', 500);

        }

    }

    public function customerlist()

    {

        if (request()->ajax()) {

            $customers = User::where('role','appuser')->paginate(5);

                

            return view('admin.customer.index_ajax', compact('customers'));

        } else {

            return view('admin.customer.index');

        }

    }



    public function customeradd()

    {
        $productlist=product::get();
        return view('admin.customer.add',compact('productlist'));

    }

    public function customeredit($id)
    {

        $customers = User::with('productpricesuserwise')->where('id',$id)->first();
        $productlist=product::get();
        return view('admin.customer.add',compact('customers','productlist'));
        exit();

    }
    public function customereditadmin(Request $request)
    {
 
        $id=request()->get('customerid');

        productpricesuser::where('userid',$id)->delete();
        if(!empty($request->get('password')))
        {
            $passworda=Hash::make($request->get('password'));
            $customerupdate = array(
            'name' => $request->get('firstname'),
            'lastname' => $request->get('lastname'),
            'email' => $request->get('email'),
            'password' =>$passworda,
            'contact_no' => $request->get('mobile'),
            'updated_at' => date("Y-m-d H:i:s"),
            );
        }else{
            $customerupdate = array(
            'name' => $request->get('firstname'),
            'lastname' => $request->get('lastname'),
            'email' => $request->get('email'),
            'contact_no' => $request->get('mobile'),
            'updated_at' => date("Y-m-d H:i:s"),
            );
        }
        
        User::where('id','=',$id)->update($customerupdate);

        foreach ($request->get('product') as $key => $value) {

                    productpricesuser::create([
                        'productid' => $key,
                        'productprices' => $value,
                        'userid' => $id,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                     ]);
                }

        return redirect()->route('admin.customer.index');
        exit();

    }
    public function customercreate(Request $request)
    {

        $validator = Validator::make(request()->all(), [

            'firstname' => 'required',
            'lastname' => 'required',
            'email' => 'required',
            'password' => 'required',
            
        ]);
        if ($validator->fails()) {

            // $this->CommonHelper->sendJsonResponse(true, [], $this->getArrayFromErrorMessages($validator->messages()->toArray()), '', 400);        

            return redirect()->back()

                ->with('alert-danger', 'Please fill required all fields');

        }
        $userExist=User::where('email',$request->get('email'))->get()->count();
        if($userExist>0)
        {
            return redirect()->back()

                ->with('alert-danger', 'This email id is already registered');
        }else{
            $passworda=Hash::make($request->get('password'));
            $useraddste='1';
            $customer = User::create([
                'name' => $request->get('firstname'),
                'lastname' => $request->get('lastname'),
                'email' => $request->get('email'),
                'password' => $passworda,
                'contact_no' => $request->get('mobile'),
                
                'role'=>'appuser',
                'status' => $useraddste,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            ]);


            if ($customer->id) {
                foreach ($request->get('product') as $key => $value) {

                    productpricesuser::create([
                        'productid' => $key,
                        'productprices' => $value,
                        'userid' => $customer->id,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                     ]);
                }
                
                return redirect()->route('admin.customer.index')
                ->with('alert-success', 'customer created successfully.');
            }
            else {
                return redirect()->back()
                ->with('alert-danger', 'No se pudo crear el plan. Inténtalo de nuevo.');
            }
       } 
    }
    public function customerdelete($id)
    {

        $customer = User::select('id')->where('id',$id)->first();

        if ($customer->delete()) {

            $this->CommonHelper->sendJsonResponse(false, [], ['Cliente eliminada exitosamente.'], '');

        }


        else {

            $this->CommonHelper->sendJsonResponse(true, [], ['No se pudo eliminar el plan. Inténtalo de nuevo.'], '', 500);

        }

    }
    public function orderlist()
    {
        if (request()->ajax()) {

            $orderlist = orderlist::with('productname','username')->paginate(5);
            
            return view('admin.orderlist.index_ajax', compact('orderlist'));

        } else {

            return view('admin.orderlist.index');

        }

    }
    public function orderlistedit($id)
    {

        $orderlist = orderlist::where('id',$id)

                ->first();

        return view('admin.orderlist.add',compact('orderlist'));
        exit();

    }
    public function orderdetails($id)
    {

        $orderlist = orderdetail::with('productname')->where('or_id',$id)->get();
        
        return view('admin.orderlist.orderdetails',compact('orderlist'));
        exit();

    }
    
    public function ordereditadmin(Request $request)
    {
        $statusNames = [
            '1' => 'Ordered',
            '2' => 'Packed',
            '3' => 'Shipped',
            '4' => 'Delivery',
            '5' => 'Delivered'
        ];
        $id=request()->get('orderid');
        $status = $request->get('status');
        $statusName = $statusNames[$status];
                
        $customerupdate = array(
            'status' => $request->get('status'),
            'updated_at' => date("Y-m-d H:i:s"),
            );
    
        orderlist::where('id','=',$id)->update($customerupdate);
        
         $firebaseToken = User::whereNotNull('device_token')->pluck('device_token')->all();
          $SERVER_API_KEY = 'AAAAlmQQrQk:APA91bHw-uejuf6B4Pjx6s17KD10uvqH0SynUzWGpxBDMJ5QMGQBuUn4Cj0p6orikSRRFFbGwysMRpoYacr7lIqz70S1ImvF-2raKVmhraV5yV8PUTQ_vRZMXkXNOVAPRvYejrKGDnVz';
            $data = [
                "registration_ids" => $firebaseToken,
                "notification" => [
                "body" => "Order has been updated to $statusName",
                "title" => "Order Status Update",
                ],
                "data" => [
                    "id" => $id,
                    "status" => $status,
                    "body" => "Order has been updated to $statusName",
                    "title" => "Order Status Update",
                ]
            ];
            $dataString = json_encode($data);
            $headers = [
                    'Authorization: key=' . $SERVER_API_KEY,
                    'Content-Type: application/json',
                ];
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

                $response = curl_exec($ch);
                
        return redirect()->route('admin.orderlist.index');
        exit();

    }
    public function orderdelete($id)
    {

        $orderlist = orderlist::select('id')->where('id',$id)->first();

        if ($orderlist->delete()) {

            $this->CommonHelper->sendJsonResponse(false, [], ['Pedido eliminado con éxito.'], '');

        }

        else {

            $this->CommonHelper->sendJsonResponse(true, [], ['No se pudo eliminar el plan. Inténtalo de nuevo.'], '', 500);

        }

    }
    public function sliderslist()

    {

        if (request()->ajax()) {

            $sliderslist = sliders::select('id', 'slider_image')
                 ->paginate(5);

                

            return view('admin.sliders.index_ajax', compact('sliderslist'));

        } else {

            return view('admin.sliders.index');

        }

    }
     public function slidersadd()

    {

        return view('admin.sliders.add');

    }
    public function sliderscreate(Request $request)
    {
        
        
       
        $imagepath = public_path() . '/slider_image';
        if (!empty($request->File('slider_image'))) {
            $img_ext = $request->File('slider_image')->getClientOriginalExtension();
            $filename = 'slider_image-' . time() . '.' . $img_ext;
            $path = $request->file('slider_image')->move($imagepath, $filename); //image save public folder
        }else{
           $filename =''; 
        }
        $useraddste='1';
        $product = sliders::create([
           'slider_image' => $filename,
            'status' => $useraddste,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);


        if ($product->id) {
            return redirect()->route('admin.sliders.index')
            ->with('alert-success', 'slider creado con exito.');
        }
        else {
            return redirect()->back()
            ->with('alert-danger', 'No se pudo crear el plan. Inténtalo de nuevo.');
        }
    }
    public function slidersedit($id)
    {

        $sliderslist = sliders::select('id', 'slider_image','status', 'created_at','updated_at')->where('id',$id)

                ->first();

        return view('admin.sliders.add',compact('sliderslist'));
        exit();

    }
    public function sliderseditadmin(Request $request)
    {
 
        $id=request()->get('sliderid');
        $imagepath = public_path() . '/slider_image';
        if (!empty($request->File('slider_image'))) {
            $img_ext = $request->File('slider_image')->getClientOriginalExtension();
            $filename = 'slider_image-' . time() . '.' . $img_ext;
            $path = $request->file('slider_image')->move($imagepath, $filename); //image save public folder
            $updateStatus = array(
            
            'slider_image' => $filename,
            );
        }else{
           $updateStatus = array(
           
            );
        }
        sliders::where('id','=',$id)->update($updateStatus);
        return redirect()->route('admin.sliders.index');
        exit();

    }
     public function slidersdelete($id)
    {

        $role = sliders::select('id')->where('id',$id)->first();

        if ($role->delete()) {

            $this->CommonHelper->sendJsonResponse(false, [], ['sliders eliminado con exito.'], '');

        }

        else {

            $this->CommonHelper->sendJsonResponse(true, [], ['No se pudo eliminar el plan. Inténtalo de nuevo.'], '', 500);

        }

    }
    public function exportcsv(Request $request)
    {
            $timelineData=orderlist::with('productname','username')->get();
            $csv_data = [];
            foreach ($timelineData as $key => $data) {
                
                $data_temp = [];
                $search = $data['id'];
                 $data123 = orderdetail::leftJoin('product', 'product.id', '=', 'orderdetails.p_id')->where('or_id',$search)->get();
                 $productde = [];
                 $quantityde = [];
                 $prices=[];
                    foreach ($data123 as $key => $productdetails) {
                         $productde[]=$productdetails['productname'];
                         $quantityde[]=$productdetails['quantity'];
                         $prices[]=$productdetails['orderprices'];
                     }
                    
                  if(count($productde)>0)
                  {
                    $List = implode(', ', $productde);

                }else{
                    $List = '';
                }
                if(count($quantityde)>0)
                  {
                    $qualist = implode(', ', $quantityde);

                }else{
                    $qualist = '';
                }      
                if(count($prices)>0)
                  {
                    $prices = implode(', ', $prices);

                }else{
                    $prices = '';
                }  
                $data_temp['Identificación'] = $data['id'];
                $data_temp['Solicitar ID'] = $data['orderid'];
                if(isset($data['username'][0]['name']))
                {
                $data_temp['Nombre de usuario'] = $data['username'][0]['name'].$data['username'][0]['lastname'];
                }else{
                    $data_temp['Nombre de usuario'] ='';
                }
                $data_temp['Fecha de orden'] = $data['orderdate'];
                  $data_temp['Nombre del producto'] = $List;
                  $data_temp['PRICES'] = $prices;
                  $data_temp['cantidad'] = $qualist ;
                   $data_temp['Cantidad total'] =  $data['totalamount'] ;
                

                $csv_data[] = $data_temp;
            }
            
            $headers = ['Content-Type: application/vnd.ms-excel; charset=UTF-16LE'];
            if(isset($request->usereport) && $request->usereport == 'dashboard')
            {
                $file_name = __('messages.userreport') . "_" . date('Y-m-d') . ".csv";
            }else
            {
                $file_name = 'Ordercsv'. "_" . date('Y-m-d') . ".csv";
            }
            
            $file_path = public_path($file_name);
            $fp = fopen($file_path, "w+");
            fputs($fp, "\xEF\xBB\xBF");
            fputcsv($fp, array_keys($csv_data[0]));
            foreach ($csv_data as $line) {
                fputcsv($fp, $line);
            }
            fclose($fp);
            return response()->download($file_path,$file_name,$headers)->deleteFileAfterSend(true);
           
            exit();
    }
    public function imagesdelete(Request $request)
    {
        

        $images = productimage::select('id')->where('id',request()->get('imagesid'))->first();

        if ($images->delete()) {

           $data = array(
                'msg'    => 'Images deleted successfully.',
                'status' => 'success'
            );
           return $data;
           exit();

        }

        else {

            $this->CommonHelper->sendJsonResponse(true, [], ['No se pudo eliminar el plan. Inténtalo de nuevo.'], '', 500);

        }
    }
	public function promocodesindex()
    {
    if (request()->ajax()) {
        $promocodes = promocode::select('id', 'promocode','promocodediscount','total_used')
        ->paginate(5);

        return view('admin.promocodes.index_ajax', compact('promocodes'));
    } else {
        return view('admin.promocodes.index');
    }
    }
    public function promocodesadd()
    {
        return view('admin.promocodes.add');
    }
    public function promocodescreate(Request $request)
    {

         $promocode=promocode::where('promocode',$request->get('promocode'))->get()->count();
            if($promocode>0)
            {
                return redirect()->back()

                ->with('alert-danger', 'This  promocode name  is already use');
            }else{
        $is_closed='0';
        $useraddste='1'; 
        $promocode = promocode::create([
                    
                    'promocode' =>$request->get('promocode'),
                    'promocodediscount' =>$request->get('promocodediscount'),
                    'total_used' =>$request->get('total_used'),
                    'status' => $useraddste,
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                ]);
        return redirect()->route('admin.promocodes.index');
                exit();
            }
    }
    public function promocodesedit($id)
    {
        $promocodes = promocode::where('id', $id)->first();


        return view('admin.promocodes.add', compact('promocodes'));
                exit();
    }
    public function promocodeseditadmin(Request $request)
        {

            $id = request()->get('promocodesid');

            
            
              $promocodes = [
                'promocode' =>$request->get('promocode'),
                'promocodediscount' =>$request->get('promocodediscount'),
                'total_used' =>$request->get('total_used'),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),

            ];
        

        promocode::where('id', '=', $id)->update($promocodes);


        return redirect()->route('admin.promocodes.index');
        exit();
    }
    public function promocodesdelete($id)
        {
           $promocodes = promocode::select('id')->first($id);

            if (isset($promocodes)) {
                promocode::where('id', $id)->delete();
                $this->CommonHelper->sendJsonResponse(false, [], ['promocode deleted successfully.'], '');
            } else {
                $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete promocode. Please try again.'], '', 500);
            }
        }
    public function generalsettingsindex()
    {
    if (request()->ajax()) {
        $generalsettings = generalsettings::select('id', 'packname','currency','tax','gst')
        ->paginate(5);

        return view('admin.generalsettings.index_ajax', compact('generalsettings'));
    } else {
        return view('admin.generalsettings.index');
    }
    }
    public function generalsettingsadd()
    {
        return view('admin.generalsettings.add');
    }
    public function generalsettingscreate(Request $request)
    {

         $generalsettings=generalsettings::where('packname',$request->get('packname'))->get()->count();
            if($generalsettings>0)
            {
                return redirect()->back()

                ->with('alert-danger', 'This  packname   is already use');
            }else{
        $is_closed='0';
        $useraddste='1'; 
        $generalsettings = generalsettings::create([
                    
                    'packname' =>$request->get('packname'),
                    'currency' =>$request->get('currency'),
                    'tax' =>$request->get('tax'),
                    'gst' =>$request->get('gst'),
                    'status' => $useraddste,
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                ]);
        return redirect()->route('admin.generalsettings.index');
                exit();
            }
    }
    public function generalsettingsedit($id)
    {
        $generalsettings = generalsettings::where('id', $id)->first();


        return view('admin.generalsettings.add', compact('generalsettings'));
                exit();
    }
    public function generalsettingseditadmin(Request $request)
        {
          
            $id = request()->get('generalsettingsid');
            
            
            
              $generalsettings = [
                'packname' =>$request->get('packname'),
                'currency' =>$request->get('currency'),
                'tax' =>$request->get('tax'),
                'gst' =>$request->get('gst'),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),

            ];
        
          
        generalsettings::where('id', '=', $id)->update($generalsettings);
            

        return redirect()->route('admin.generalsettings.index');
        exit();
    }
    public function generalsettingsdelete($id)
        {
           $generalsettings = generalsettings::select('id')->first($id);

            if (isset($generalsettings)) {
                generalsettings::where('id', $id)->delete();
                $this->CommonHelper->sendJsonResponse(false, [], ['generalsetting  deleted successfully.'], '');
            } else {
                $this->CommonHelper->sendJsonResponse(true, [], ['Failed to delete generalsetting. Please try again.'], '', 500);
            }
        }



 

}