<?php

namespace App\Helpers;

class NotificationHelper
{
    // sends push notification, through firebase(fcm), to android users
    public function sendNotifAndroid($notif_type = '', $body_text = '', $notif_data = [], $device_tokens)
    {
        $fcm_url = 'https://fcm.googleapis.com/fcm/send';

        $fields = [
            'data' => [
                'data' => [
                    'title' => env('APP_NAME'),
                    'body' => $body_text,
                    'tag' => 1,
                    'icon' => 'default',
                    'badge' => 1,
                    'notif_type' => $notif_type,
                    'notif_data' => $notif_data,
                ]
            ],
            'registration_ids' => $device_tokens
        ];

        // encode the payload as JSON
        $payload = json_encode($fields);

        $headers = [
            'Content-Type:application/json',
            'Authorization:key=' . env('FCM_SERVER_KEY')
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $fcm_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        $result = curl_exec($ch);

        if ($result === FALSE) {
            // die('FCM Send Error: ' . curl_error($ch));
            return false;
        }

        curl_close($ch);
        
        return $result;
    }
}
