<?php

namespace App\Helpers;

class CommonHelper
{
    public function sendJsonResponse($is_error = true, $data = [], $message = '', $page_count = '', $status_code = 200)
    {
        // to set the response body
        $response_array = [
            'is_error' => $is_error,
            'data' => $data,
            'message' => $message,
            'page_count' => $page_count
        ];

        // to send output and stop execution
        response()->json($response_array, $status_code)->send();
        exit(0);
    }

    public function getStringFromErrorMessages($validator_messages = [])
    {
        $error_messages = [];

        foreach ($validator_messages as $key => $value) {
            foreach ($value as $error_message) {
                $error_messages[] = $error_message;
            }
        }

        return implode(', ', $error_messages);
    }
}
